package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAlertContact invokes the emr.ModifyAlertContact API synchronously
// api document: https://help.aliyun.com/api/emr/modifyalertcontact.html
func (client *Client) ModifyAlertContact(request *ModifyAlertContactRequest) (response *ModifyAlertContactResponse, err error) {
	response = CreateModifyAlertContactResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAlertContactWithChan invokes the emr.ModifyAlertContact API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyalertcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertContactWithChan(request *ModifyAlertContactRequest) (<-chan *ModifyAlertContactResponse, <-chan error) {
	responseChan := make(chan *ModifyAlertContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAlertContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAlertContactWithCallback invokes the emr.ModifyAlertContact API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyalertcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertContactWithCallback(request *ModifyAlertContactRequest, callback func(response *ModifyAlertContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAlertContactResponse
		var err error
		defer close(result)
		response, err = client.ModifyAlertContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAlertContactRequest is the request struct for api ModifyAlertContact
type ModifyAlertContactRequest struct {
	*requests.RpcRequest
	EmailVerificationCode       string           `position:"Query" name:"EmailVerificationCode"`
	ResourceOwnerId             requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PhoneNumberVerificationCode string           `position:"Query" name:"PhoneNumberVerificationCode"`
	BizId                       string           `position:"Query" name:"BizId"`
	Name                        string           `position:"Query" name:"Name"`
	PhoneNumber                 string           `position:"Query" name:"PhoneNumber"`
	Email                       string           `position:"Query" name:"Email"`
}

// ModifyAlertContactResponse is the response struct for api ModifyAlertContact
type ModifyAlertContactResponse struct {
	*responses.BaseResponse
	Done bool `json:"Done" xml:"Done"`
}

// CreateModifyAlertContactRequest creates a request to invoke ModifyAlertContact API
func CreateModifyAlertContactRequest() (request *ModifyAlertContactRequest) {
	request = &ModifyAlertContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyAlertContact", "emr", "openAPI")
	return
}

// CreateModifyAlertContactResponse creates a response to parse from ModifyAlertContact response
func CreateModifyAlertContactResponse() (response *ModifyAlertContactResponse) {
	response = &ModifyAlertContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
