package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExecutionPlanBasicInfo invokes the emr.ModifyExecutionPlanBasicInfo API synchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanbasicinfo.html
func (client *Client) ModifyExecutionPlanBasicInfo(request *ModifyExecutionPlanBasicInfoRequest) (response *ModifyExecutionPlanBasicInfoResponse, err error) {
	response = CreateModifyExecutionPlanBasicInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExecutionPlanBasicInfoWithChan invokes the emr.ModifyExecutionPlanBasicInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanbasicinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanBasicInfoWithChan(request *ModifyExecutionPlanBasicInfoRequest) (<-chan *ModifyExecutionPlanBasicInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyExecutionPlanBasicInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExecutionPlanBasicInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExecutionPlanBasicInfoWithCallback invokes the emr.ModifyExecutionPlanBasicInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanbasicinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanBasicInfoWithCallback(request *ModifyExecutionPlanBasicInfoRequest, callback func(response *ModifyExecutionPlanBasicInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExecutionPlanBasicInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyExecutionPlanBasicInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExecutionPlanBasicInfoRequest is the request struct for api ModifyExecutionPlanBasicInfo
type ModifyExecutionPlanBasicInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Id              string           `position:"Query" name:"Id"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// ModifyExecutionPlanBasicInfoResponse is the response struct for api ModifyExecutionPlanBasicInfo
type ModifyExecutionPlanBasicInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExecutionPlanBasicInfoRequest creates a request to invoke ModifyExecutionPlanBasicInfo API
func CreateModifyExecutionPlanBasicInfoRequest() (request *ModifyExecutionPlanBasicInfoRequest) {
	request = &ModifyExecutionPlanBasicInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyExecutionPlanBasicInfo", "emr", "openAPI")
	return
}

// CreateModifyExecutionPlanBasicInfoResponse creates a response to parse from ModifyExecutionPlanBasicInfo response
func CreateModifyExecutionPlanBasicInfoResponse() (response *ModifyExecutionPlanBasicInfoResponse) {
	response = &ModifyExecutionPlanBasicInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
