package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExecutionPlanClusterInfo invokes the emr.ModifyExecutionPlanClusterInfo API synchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanclusterinfo.html
func (client *Client) ModifyExecutionPlanClusterInfo(request *ModifyExecutionPlanClusterInfoRequest) (response *ModifyExecutionPlanClusterInfoResponse, err error) {
	response = CreateModifyExecutionPlanClusterInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExecutionPlanClusterInfoWithChan invokes the emr.ModifyExecutionPlanClusterInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanclusterinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanClusterInfoWithChan(request *ModifyExecutionPlanClusterInfoRequest) (<-chan *ModifyExecutionPlanClusterInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyExecutionPlanClusterInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExecutionPlanClusterInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExecutionPlanClusterInfoWithCallback invokes the emr.ModifyExecutionPlanClusterInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanclusterinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanClusterInfoWithCallback(request *ModifyExecutionPlanClusterInfoRequest, callback func(response *ModifyExecutionPlanClusterInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExecutionPlanClusterInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyExecutionPlanClusterInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExecutionPlanClusterInfoRequest is the request struct for api ModifyExecutionPlanClusterInfo
type ModifyExecutionPlanClusterInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                                 `position:"Query" name:"ResourceOwnerId"`
	LogPath                string                                           `position:"Query" name:"LogPath"`
	ClusterName            string                                           `position:"Query" name:"ClusterName"`
	Configurations         string                                           `position:"Query" name:"Configurations"`
	IoOptimized            requests.Boolean                                 `position:"Query" name:"IoOptimized"`
	SecurityGroupId        string                                           `position:"Query" name:"SecurityGroupId"`
	EasEnable              requests.Boolean                                 `position:"Query" name:"EasEnable"`
	CreateClusterOnDemand  requests.Boolean                                 `position:"Query" name:"CreateClusterOnDemand"`
	BootstrapAction        *[]ModifyExecutionPlanClusterInfoBootstrapAction `position:"Query" name:"BootstrapAction"  type:"Repeated"`
	UseLocalMetaDb         requests.Boolean                                 `position:"Query" name:"UseLocalMetaDb"`
	EmrVer                 string                                           `position:"Query" name:"EmrVer"`
	Id                     string                                           `position:"Query" name:"Id"`
	IsOpenPublicIp         requests.Boolean                                 `position:"Query" name:"IsOpenPublicIp"`
	ClusterId              string                                           `position:"Query" name:"ClusterId"`
	InstanceGeneration     string                                           `position:"Query" name:"InstanceGeneration"`
	ClusterType            string                                           `position:"Query" name:"ClusterType"`
	VSwitchId              string                                           `position:"Query" name:"VSwitchId"`
	OptionSoftWareList     *[]string                                        `position:"Query" name:"OptionSoftWareList"  type:"Repeated"`
	VpcId                  string                                           `position:"Query" name:"VpcId"`
	NetType                string                                           `position:"Query" name:"NetType"`
	EcsOrder               *[]ModifyExecutionPlanClusterInfoEcsOrder        `position:"Query" name:"EcsOrder"  type:"Repeated"`
	ZoneId                 string                                           `position:"Query" name:"ZoneId"`
	HighAvailabilityEnable requests.Boolean                                 `position:"Query" name:"HighAvailabilityEnable"`
	LogEnable              requests.Boolean                                 `position:"Query" name:"LogEnable"`
}

// ModifyExecutionPlanClusterInfoBootstrapAction is a repeated param struct in ModifyExecutionPlanClusterInfoRequest
type ModifyExecutionPlanClusterInfoBootstrapAction struct {
	Path string `name:"Path"`
	Arg  string `name:"Arg"`
	Name string `name:"Name"`
}

// ModifyExecutionPlanClusterInfoEcsOrder is a repeated param struct in ModifyExecutionPlanClusterInfoRequest
type ModifyExecutionPlanClusterInfoEcsOrder struct {
	NodeType     string `name:"NodeType"`
	DiskCount    string `name:"DiskCount"`
	NodeCount    string `name:"NodeCount"`
	DiskCapacity string `name:"DiskCapacity"`
	Index        string `name:"Index"`
	InstanceType string `name:"InstanceType"`
	DiskType     string `name:"DiskType"`
}

// ModifyExecutionPlanClusterInfoResponse is the response struct for api ModifyExecutionPlanClusterInfo
type ModifyExecutionPlanClusterInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExecutionPlanClusterInfoRequest creates a request to invoke ModifyExecutionPlanClusterInfo API
func CreateModifyExecutionPlanClusterInfoRequest() (request *ModifyExecutionPlanClusterInfoRequest) {
	request = &ModifyExecutionPlanClusterInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyExecutionPlanClusterInfo", "emr", "openAPI")
	return
}

// CreateModifyExecutionPlanClusterInfoResponse creates a response to parse from ModifyExecutionPlanClusterInfo response
func CreateModifyExecutionPlanClusterInfoResponse() (response *ModifyExecutionPlanClusterInfoResponse) {
	response = &ModifyExecutionPlanClusterInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
