package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateExistsNodeCluster invokes the emr.OperateExistsNodeCluster API synchronously
// api document: https://help.aliyun.com/api/emr/operateexistsnodecluster.html
func (client *Client) OperateExistsNodeCluster(request *OperateExistsNodeClusterRequest) (response *OperateExistsNodeClusterResponse, err error) {
	response = CreateOperateExistsNodeClusterResponse()
	err = client.DoAction(request, response)
	return
}

// OperateExistsNodeClusterWithChan invokes the emr.OperateExistsNodeCluster API asynchronously
// api document: https://help.aliyun.com/api/emr/operateexistsnodecluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateExistsNodeClusterWithChan(request *OperateExistsNodeClusterRequest) (<-chan *OperateExistsNodeClusterResponse, <-chan error) {
	responseChan := make(chan *OperateExistsNodeClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateExistsNodeCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateExistsNodeClusterWithCallback invokes the emr.OperateExistsNodeCluster API asynchronously
// api document: https://help.aliyun.com/api/emr/operateexistsnodecluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateExistsNodeClusterWithCallback(request *OperateExistsNodeClusterRequest, callback func(response *OperateExistsNodeClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateExistsNodeClusterResponse
		var err error
		defer close(result)
		response, err = client.OperateExistsNodeCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateExistsNodeClusterRequest is the request struct for api OperateExistsNodeCluster
type OperateExistsNodeClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LogPath                string           `position:"Query" name:"LogPath"`
	MasterInstanceIdList   *[]string        `position:"Query" name:"MasterInstanceIdList"  type:"Repeated"`
	IoOptimized            requests.Boolean `position:"Query" name:"IoOptimized"`
	SecurityGroupId        string           `position:"Query" name:"SecurityGroupId"`
	EasEnable              requests.Boolean `position:"Query" name:"EasEnable"`
	IsResize               requests.Boolean `position:"Query" name:"IsResize"`
	DepositType            string           `position:"Query" name:"DepositType"`
	MachineType            string           `position:"Query" name:"MachineType"`
	UseLocalMetaDb         requests.Boolean `position:"Query" name:"UseLocalMetaDb"`
	EmrVer                 string           `position:"Query" name:"EmrVer"`
	Period                 requests.Integer `position:"Query" name:"Period"`
	ClusterId              string           `position:"Query" name:"ClusterId"`
	VSwitchId              string           `position:"Query" name:"VSwitchId"`
	ClusterType            string           `position:"Query" name:"ClusterType"`
	OptionSoftWareList     *[]string        `position:"Query" name:"OptionSoftWareList"  type:"Repeated"`
	InstanceIdList         *[]string        `position:"Query" name:"InstanceIdList"  type:"Repeated"`
	VpcId                  string           `position:"Query" name:"VpcId"`
	NetType                string           `position:"Query" name:"NetType"`
	Name                   string           `position:"Query" name:"Name"`
	ZoneId                 string           `position:"Query" name:"ZoneId"`
	ChargeType             string           `position:"Query" name:"ChargeType"`
	OperateType            string           `position:"Query" name:"OperateType"`
	HighAvailabilityEnable requests.Boolean `position:"Query" name:"HighAvailabilityEnable"`
}

// OperateExistsNodeClusterResponse is the response struct for api OperateExistsNodeCluster
type OperateExistsNodeClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ClusterId string `json:"ClusterId" xml:"ClusterId"`
}

// CreateOperateExistsNodeClusterRequest creates a request to invoke OperateExistsNodeCluster API
func CreateOperateExistsNodeClusterRequest() (request *OperateExistsNodeClusterRequest) {
	request = &OperateExistsNodeClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "OperateExistsNodeCluster", "emr", "openAPI")
	return
}

// CreateOperateExistsNodeClusterResponse creates a response to parse from OperateExistsNodeCluster response
func CreateOperateExistsNodeClusterResponse() (response *OperateExistsNodeClusterResponse) {
	response = &OperateExistsNodeClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
