package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SignedPageResult invokes the finmall.SignedPageResult API synchronously
// api document: https://help.aliyun.com/api/finmall/signedpageresult.html
func (client *Client) SignedPageResult(request *SignedPageResultRequest) (response *SignedPageResultResponse, err error) {
	response = CreateSignedPageResultResponse()
	err = client.DoAction(request, response)
	return
}

// SignedPageResultWithChan invokes the finmall.SignedPageResult API asynchronously
// api document: https://help.aliyun.com/api/finmall/signedpageresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SignedPageResultWithChan(request *SignedPageResultRequest) (<-chan *SignedPageResultResponse, <-chan error) {
	responseChan := make(chan *SignedPageResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SignedPageResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SignedPageResultWithCallback invokes the finmall.SignedPageResult API asynchronously
// api document: https://help.aliyun.com/api/finmall/signedpageresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SignedPageResultWithCallback(request *SignedPageResultRequest, callback func(response *SignedPageResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SignedPageResultResponse
		var err error
		defer close(result)
		response, err = client.SignedPageResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SignedPageResultRequest is the request struct for api SignedPageResult
type SignedPageResultRequest struct {
	*requests.RpcRequest
	DownloadUrl   string           `position:"Query" name:"DownloadUrl"`
	Digest        string           `position:"Query" name:"Digest"`
	ViewUrl       string           `position:"Query" name:"ViewUrl"`
	ResultCode    requests.Integer `position:"Query" name:"ResultCode"`
	TransactionId string           `position:"Query" name:"TransactionId"`
	ResultDesc    string           `position:"Query" name:"ResultDesc"`
	Timestamp     string           `position:"Query" name:"Timestamp"`
}

// SignedPageResultResponse is the response struct for api SignedPageResult
type SignedPageResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSignedPageResultRequest creates a request to invoke SignedPageResult API
func CreateSignedPageResultRequest() (request *SignedPageResultRequest) {
	request = &SignedPageResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "SignedPageResult", "finmall", "openAPI")
	return
}

// CreateSignedPageResultResponse creates a response to parse from SignedPageResult response
func CreateSignedPageResultResponse() (response *SignedPageResultResponse) {
	response = &SignedPageResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
