package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteImageFromLib invokes the green.DeleteImageFromLib API synchronously
// api document: https://help.aliyun.com/api/green/deleteimagefromlib.html
func (client *Client) DeleteImageFromLib(request *DeleteImageFromLibRequest) (response *DeleteImageFromLibResponse, err error) {
	response = CreateDeleteImageFromLibResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteImageFromLibWithChan invokes the green.DeleteImageFromLib API asynchronously
// api document: https://help.aliyun.com/api/green/deleteimagefromlib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteImageFromLibWithChan(request *DeleteImageFromLibRequest) (<-chan *DeleteImageFromLibResponse, <-chan error) {
	responseChan := make(chan *DeleteImageFromLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteImageFromLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteImageFromLibWithCallback invokes the green.DeleteImageFromLib API asynchronously
// api document: https://help.aliyun.com/api/green/deleteimagefromlib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteImageFromLibWithCallback(request *DeleteImageFromLibRequest, callback func(response *DeleteImageFromLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteImageFromLibResponse
		var err error
		defer close(result)
		response, err = client.DeleteImageFromLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteImageFromLibRequest is the request struct for api DeleteImageFromLib
type DeleteImageFromLibRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Ids      string `position:"Query" name:"Ids"`
}

// DeleteImageFromLibResponse is the response struct for api DeleteImageFromLib
type DeleteImageFromLibResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteImageFromLibRequest creates a request to invoke DeleteImageFromLib API
func CreateDeleteImageFromLibRequest() (request *DeleteImageFromLibRequest) {
	request = &DeleteImageFromLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DeleteImageFromLib", "green", "openAPI")
	return
}

// CreateDeleteImageFromLibResponse creates a response to parse from DeleteImageFromLib response
func CreateDeleteImageFromLibResponse() (response *DeleteImageFromLibResponse) {
	response = &DeleteImageFromLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
