package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDocIndex invokes the imm.DeleteDocIndex API synchronously
// api document: https://help.aliyun.com/api/imm/deletedocindex.html
func (client *Client) DeleteDocIndex(request *DeleteDocIndexRequest) (response *DeleteDocIndexResponse, err error) {
	response = CreateDeleteDocIndexResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDocIndexWithChan invokes the imm.DeleteDocIndex API asynchronously
// api document: https://help.aliyun.com/api/imm/deletedocindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDocIndexWithChan(request *DeleteDocIndexRequest) (<-chan *DeleteDocIndexResponse, <-chan error) {
	responseChan := make(chan *DeleteDocIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDocIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDocIndexWithCallback invokes the imm.DeleteDocIndex API asynchronously
// api document: https://help.aliyun.com/api/imm/deletedocindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDocIndexWithCallback(request *DeleteDocIndexRequest, callback func(response *DeleteDocIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDocIndexResponse
		var err error
		defer close(result)
		response, err = client.DeleteDocIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDocIndexRequest is the request struct for api DeleteDocIndex
type DeleteDocIndexRequest struct {
	*requests.RpcRequest
	Set      string `position:"Query" name:"Set"`
	Project  string `position:"Query" name:"Project"`
	UniqueId string `position:"Query" name:"UniqueId"`
}

// DeleteDocIndexResponse is the response struct for api DeleteDocIndex
type DeleteDocIndexResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDocIndexRequest creates a request to invoke DeleteDocIndex API
func CreateDeleteDocIndexRequest() (request *DeleteDocIndexRequest) {
	request = &DeleteDocIndexRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeleteDocIndex", "imm", "openAPI")
	return
}

// CreateDeleteDocIndexResponse creates a response to parse from DeleteDocIndex response
func CreateDeleteDocIndexResponse() (response *DeleteDocIndexResponse) {
	response = &DeleteDocIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
