package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTrainDatas invokes the ivision.DeleteTrainDatas API synchronously
// api document: https://help.aliyun.com/api/ivision/deletetraindatas.html
func (client *Client) DeleteTrainDatas(request *DeleteTrainDatasRequest) (response *DeleteTrainDatasResponse, err error) {
	response = CreateDeleteTrainDatasResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTrainDatasWithChan invokes the ivision.DeleteTrainDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletetraindatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTrainDatasWithChan(request *DeleteTrainDatasRequest) (<-chan *DeleteTrainDatasResponse, <-chan error) {
	responseChan := make(chan *DeleteTrainDatasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrainDatas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTrainDatasWithCallback invokes the ivision.DeleteTrainDatas API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletetraindatas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTrainDatasWithCallback(request *DeleteTrainDatasRequest, callback func(response *DeleteTrainDatasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTrainDatasResponse
		var err error
		defer close(result)
		response, err = client.DeleteTrainDatas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTrainDatasRequest is the request struct for api DeleteTrainDatas
type DeleteTrainDatasRequest struct {
	*requests.RpcRequest
	DataIds   string           `position:"Query" name:"DataIds"`
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteTrainDatasResponse is the response struct for api DeleteTrainDatas
type DeleteTrainDatasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTrainDatasRequest creates a request to invoke DeleteTrainDatas API
func CreateDeleteTrainDatasRequest() (request *DeleteTrainDatasRequest) {
	request = &DeleteTrainDatasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DeleteTrainDatas", "ivision", "openAPI")
	return
}

// CreateDeleteTrainDatasResponse creates a response to parse from DeleteTrainDatas response
func CreateDeleteTrainDatasResponse() (response *DeleteTrainDatasResponse) {
	response = &DeleteTrainDatasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
