package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTrainDataTagAttribute invokes the ivision.ModifyTrainDataTagAttribute API synchronously
// api document: https://help.aliyun.com/api/ivision/modifytraindatatagattribute.html
func (client *Client) ModifyTrainDataTagAttribute(request *ModifyTrainDataTagAttributeRequest) (response *ModifyTrainDataTagAttributeResponse, err error) {
	response = CreateModifyTrainDataTagAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTrainDataTagAttributeWithChan invokes the ivision.ModifyTrainDataTagAttribute API asynchronously
// api document: https://help.aliyun.com/api/ivision/modifytraindatatagattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTrainDataTagAttributeWithChan(request *ModifyTrainDataTagAttributeRequest) (<-chan *ModifyTrainDataTagAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyTrainDataTagAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTrainDataTagAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTrainDataTagAttributeWithCallback invokes the ivision.ModifyTrainDataTagAttribute API asynchronously
// api document: https://help.aliyun.com/api/ivision/modifytraindatatagattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTrainDataTagAttributeWithCallback(request *ModifyTrainDataTagAttributeRequest, callback func(response *ModifyTrainDataTagAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTrainDataTagAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyTrainDataTagAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTrainDataTagAttributeRequest is the request struct for api ModifyTrainDataTagAttribute
type ModifyTrainDataTagAttributeRequest struct {
	*requests.RpcRequest
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	TagItems  string           `position:"Query" name:"TagItems"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	DataId    string           `position:"Query" name:"DataId"`
}

// ModifyTrainDataTagAttributeResponse is the response struct for api ModifyTrainDataTagAttribute
type ModifyTrainDataTagAttributeResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	TrainData TrainData `json:"TrainData" xml:"TrainData"`
}

// CreateModifyTrainDataTagAttributeRequest creates a request to invoke ModifyTrainDataTagAttribute API
func CreateModifyTrainDataTagAttributeRequest() (request *ModifyTrainDataTagAttributeRequest) {
	request = &ModifyTrainDataTagAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "ModifyTrainDataTagAttribute", "ivision", "openAPI")
	return
}

// CreateModifyTrainDataTagAttributeResponse creates a response to parse from ModifyTrainDataTagAttribute response
func CreateModifyTrainDataTagAttributeResponse() (response *ModifyTrainDataTagAttributeResponse) {
	response = &ModifyTrainDataTagAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
