package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveRecordNotifyConfig invokes the live.DeleteLiveRecordNotifyConfig API synchronously
// api document: https://help.aliyun.com/api/live/deleteliverecordnotifyconfig.html
func (client *Client) DeleteLiveRecordNotifyConfig(request *DeleteLiveRecordNotifyConfigRequest) (response *DeleteLiveRecordNotifyConfigResponse, err error) {
	response = CreateDeleteLiveRecordNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveRecordNotifyConfigWithChan invokes the live.DeleteLiveRecordNotifyConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deleteliverecordnotifyconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveRecordNotifyConfigWithChan(request *DeleteLiveRecordNotifyConfigRequest) (<-chan *DeleteLiveRecordNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveRecordNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveRecordNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveRecordNotifyConfigWithCallback invokes the live.DeleteLiveRecordNotifyConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deleteliverecordnotifyconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveRecordNotifyConfigWithCallback(request *DeleteLiveRecordNotifyConfigRequest, callback func(response *DeleteLiveRecordNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveRecordNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveRecordNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveRecordNotifyConfigRequest is the request struct for api DeleteLiveRecordNotifyConfig
type DeleteLiveRecordNotifyConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveRecordNotifyConfigResponse is the response struct for api DeleteLiveRecordNotifyConfig
type DeleteLiveRecordNotifyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveRecordNotifyConfigRequest creates a request to invoke DeleteLiveRecordNotifyConfig API
func CreateDeleteLiveRecordNotifyConfigRequest() (request *DeleteLiveRecordNotifyConfigRequest) {
	request = &DeleteLiveRecordNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveRecordNotifyConfig", "live", "openAPI")
	return
}

// CreateDeleteLiveRecordNotifyConfigResponse creates a response to parse from DeleteLiveRecordNotifyConfig response
func CreateDeleteLiveRecordNotifyConfigResponse() (response *DeleteLiveRecordNotifyConfigResponse) {
	response = &DeleteLiveRecordNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
