package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveLazyPullStreamConfig invokes the live.DescribeLiveLazyPullStreamConfig API synchronously
// api document: https://help.aliyun.com/api/live/describelivelazypullstreamconfig.html
func (client *Client) DescribeLiveLazyPullStreamConfig(request *DescribeLiveLazyPullStreamConfigRequest) (response *DescribeLiveLazyPullStreamConfigResponse, err error) {
	response = CreateDescribeLiveLazyPullStreamConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveLazyPullStreamConfigWithChan invokes the live.DescribeLiveLazyPullStreamConfig API asynchronously
// api document: https://help.aliyun.com/api/live/describelivelazypullstreamconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveLazyPullStreamConfigWithChan(request *DescribeLiveLazyPullStreamConfigRequest) (<-chan *DescribeLiveLazyPullStreamConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveLazyPullStreamConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveLazyPullStreamConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveLazyPullStreamConfigWithCallback invokes the live.DescribeLiveLazyPullStreamConfig API asynchronously
// api document: https://help.aliyun.com/api/live/describelivelazypullstreamconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveLazyPullStreamConfigWithCallback(request *DescribeLiveLazyPullStreamConfigRequest, callback func(response *DescribeLiveLazyPullStreamConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveLazyPullStreamConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveLazyPullStreamConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveLazyPullStreamConfigRequest is the request struct for api DescribeLiveLazyPullStreamConfig
type DescribeLiveLazyPullStreamConfigRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	AppName    string           `position:"Query" name:"AppName"`
}

// DescribeLiveLazyPullStreamConfigResponse is the response struct for api DescribeLiveLazyPullStreamConfig
type DescribeLiveLazyPullStreamConfigResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	LiveLazyPullConfigList LiveLazyPullConfigList `json:"LiveLazyPullConfigList" xml:"LiveLazyPullConfigList"`
}

// CreateDescribeLiveLazyPullStreamConfigRequest creates a request to invoke DescribeLiveLazyPullStreamConfig API
func CreateDescribeLiveLazyPullStreamConfigRequest() (request *DescribeLiveLazyPullStreamConfigRequest) {
	request = &DescribeLiveLazyPullStreamConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveLazyPullStreamConfig", "live", "openAPI")
	return
}

// CreateDescribeLiveLazyPullStreamConfigResponse creates a response to parse from DescribeLiveLazyPullStreamConfig response
func CreateDescribeLiveLazyPullStreamConfigResponse() (response *DescribeLiveLazyPullStreamConfigResponse) {
	response = &DescribeLiveLazyPullStreamConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
