package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCasterEpisode invokes the live.ModifyCasterEpisode API synchronously
// api document: https://help.aliyun.com/api/live/modifycasterepisode.html
func (client *Client) ModifyCasterEpisode(request *ModifyCasterEpisodeRequest) (response *ModifyCasterEpisodeResponse, err error) {
	response = CreateModifyCasterEpisodeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCasterEpisodeWithChan invokes the live.ModifyCasterEpisode API asynchronously
// api document: https://help.aliyun.com/api/live/modifycasterepisode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCasterEpisodeWithChan(request *ModifyCasterEpisodeRequest) (<-chan *ModifyCasterEpisodeResponse, <-chan error) {
	responseChan := make(chan *ModifyCasterEpisodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCasterEpisode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCasterEpisodeWithCallback invokes the live.ModifyCasterEpisode API asynchronously
// api document: https://help.aliyun.com/api/live/modifycasterepisode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCasterEpisodeWithCallback(request *ModifyCasterEpisodeRequest, callback func(response *ModifyCasterEpisodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCasterEpisodeResponse
		var err error
		defer close(result)
		response, err = client.ModifyCasterEpisode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCasterEpisodeRequest is the request struct for api ModifyCasterEpisode
type ModifyCasterEpisodeRequest struct {
	*requests.RpcRequest
	ResourceId  string           `position:"Query" name:"ResourceId"`
	ComponentId *[]string        `position:"Query" name:"ComponentId"  type:"Repeated"`
	SwitchType  string           `position:"Query" name:"SwitchType"`
	CasterId    string           `position:"Query" name:"CasterId"`
	EpisodeName string           `position:"Query" name:"EpisodeName"`
	EndTime     string           `position:"Query" name:"EndTime"`
	StartTime   string           `position:"Query" name:"StartTime"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	EpisodeId   string           `position:"Query" name:"EpisodeId"`
}

// ModifyCasterEpisodeResponse is the response struct for api ModifyCasterEpisode
type ModifyCasterEpisodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CasterId  string `json:"CasterId" xml:"CasterId"`
	EpisodeId string `json:"EpisodeId" xml:"EpisodeId"`
}

// CreateModifyCasterEpisodeRequest creates a request to invoke ModifyCasterEpisode API
func CreateModifyCasterEpisodeRequest() (request *ModifyCasterEpisodeRequest) {
	request = &ModifyCasterEpisodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ModifyCasterEpisode", "live", "openAPI")
	return
}

// CreateModifyCasterEpisodeResponse creates a response to parse from ModifyCasterEpisode response
func CreateModifyCasterEpisodeResponse() (response *ModifyCasterEpisodeResponse) {
	response = &ModifyCasterEpisodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
