package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCensorJobList invokes the mts.QueryCensorJobList API synchronously
// api document: https://help.aliyun.com/api/mts/querycensorjoblist.html
func (client *Client) QueryCensorJobList(request *QueryCensorJobListRequest) (response *QueryCensorJobListResponse, err error) {
	response = CreateQueryCensorJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCensorJobListWithChan invokes the mts.QueryCensorJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/querycensorjoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCensorJobListWithChan(request *QueryCensorJobListRequest) (<-chan *QueryCensorJobListResponse, <-chan error) {
	responseChan := make(chan *QueryCensorJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCensorJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCensorJobListWithCallback invokes the mts.QueryCensorJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/querycensorjoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCensorJobListWithCallback(request *QueryCensorJobListRequest, callback func(response *QueryCensorJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCensorJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryCensorJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCensorJobListRequest is the request struct for api QueryCensorJobList
type QueryCensorJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	JobIds               string           `position:"Query" name:"JobIds"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryCensorJobListResponse is the response struct for api QueryCensorJobList
type QueryCensorJobListResponse struct {
	*responses.BaseResponse
	RequestId     string                          `json:"RequestId" xml:"RequestId"`
	NonExistIds   NonExistIdsInQueryCensorJobList `json:"NonExistIds" xml:"NonExistIds"`
	CensorJobList CensorJobList                   `json:"CensorJobList" xml:"CensorJobList"`
}

// CreateQueryCensorJobListRequest creates a request to invoke QueryCensorJobList API
func CreateQueryCensorJobListRequest() (request *QueryCensorJobListRequest) {
	request = &QueryCensorJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryCensorJobList", "mts", "openAPI")
	return
}

// CreateQueryCensorJobListResponse creates a response to parse from QueryCensorJobList response
func CreateQueryCensorJobListResponse() (response *QueryCensorJobListResponse) {
	response = &QueryCensorJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
