package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyReplicaRecoveryMode invokes the r_kvstore.ModifyReplicaRecoveryMode API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyreplicarecoverymode.html
func (client *Client) ModifyReplicaRecoveryMode(request *ModifyReplicaRecoveryModeRequest) (response *ModifyReplicaRecoveryModeResponse, err error) {
	response = CreateModifyReplicaRecoveryModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyReplicaRecoveryModeWithChan invokes the r_kvstore.ModifyReplicaRecoveryMode API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyreplicarecoverymode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyReplicaRecoveryModeWithChan(request *ModifyReplicaRecoveryModeRequest) (<-chan *ModifyReplicaRecoveryModeResponse, <-chan error) {
	responseChan := make(chan *ModifyReplicaRecoveryModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyReplicaRecoveryMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyReplicaRecoveryModeWithCallback invokes the r_kvstore.ModifyReplicaRecoveryMode API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyreplicarecoverymode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyReplicaRecoveryModeWithCallback(request *ModifyReplicaRecoveryModeRequest, callback func(response *ModifyReplicaRecoveryModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyReplicaRecoveryModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyReplicaRecoveryMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyReplicaRecoveryModeRequest is the request struct for api ModifyReplicaRecoveryMode
type ModifyReplicaRecoveryModeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RecoveryMode         string           `position:"Query" name:"RecoveryMode"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ReplicaId            string           `position:"Query" name:"ReplicaId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyReplicaRecoveryModeResponse is the response struct for api ModifyReplicaRecoveryMode
type ModifyReplicaRecoveryModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyReplicaRecoveryModeRequest creates a request to invoke ModifyReplicaRecoveryMode API
func CreateModifyReplicaRecoveryModeRequest() (request *ModifyReplicaRecoveryModeRequest) {
	request = &ModifyReplicaRecoveryModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyReplicaRecoveryMode", "redisa", "openAPI")
	return
}

// CreateModifyReplicaRecoveryModeResponse creates a response to parse from ModifyReplicaRecoveryMode response
func CreateModifyReplicaRecoveryModeResponse() (response *ModifyReplicaRecoveryModeResponse) {
	response = &ModifyReplicaRecoveryModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
