package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSlbQuotas invokes the slb.DescribeSlbQuotas API synchronously
// api document: https://help.aliyun.com/api/slb/describeslbquotas.html
func (client *Client) DescribeSlbQuotas(request *DescribeSlbQuotasRequest) (response *DescribeSlbQuotasResponse, err error) {
	response = CreateDescribeSlbQuotasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSlbQuotasWithChan invokes the slb.DescribeSlbQuotas API asynchronously
// api document: https://help.aliyun.com/api/slb/describeslbquotas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSlbQuotasWithChan(request *DescribeSlbQuotasRequest) (<-chan *DescribeSlbQuotasResponse, <-chan error) {
	responseChan := make(chan *DescribeSlbQuotasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSlbQuotas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSlbQuotasWithCallback invokes the slb.DescribeSlbQuotas API asynchronously
// api document: https://help.aliyun.com/api/slb/describeslbquotas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSlbQuotasWithCallback(request *DescribeSlbQuotasRequest, callback func(response *DescribeSlbQuotasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSlbQuotasResponse
		var err error
		defer close(result)
		response, err = client.DescribeSlbQuotas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSlbQuotasRequest is the request struct for api DescribeSlbQuotas
type DescribeSlbQuotasRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
}

// DescribeSlbQuotasResponse is the response struct for api DescribeSlbQuotas
type DescribeSlbQuotasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Quotas    Quotas `json:"Quotas" xml:"Quotas"`
}

// CreateDescribeSlbQuotasRequest creates a request to invoke DescribeSlbQuotas API
func CreateDescribeSlbQuotasRequest() (request *DescribeSlbQuotasRequest) {
	request = &DescribeSlbQuotasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DescribeSlbQuotas", "slb", "openAPI")
	return
}

// CreateDescribeSlbQuotasResponse creates a response to parse from DescribeSlbQuotas response
func CreateDescribeSlbQuotasResponse() (response *DescribeSlbQuotasResponse) {
	response = &DescribeSlbQuotasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
