package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBgpNetworks invokes the vpc.DescribeBgpNetworks API synchronously
// api document: https://help.aliyun.com/api/vpc/describebgpnetworks.html
func (client *Client) DescribeBgpNetworks(request *DescribeBgpNetworksRequest) (response *DescribeBgpNetworksResponse, err error) {
	response = CreateDescribeBgpNetworksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBgpNetworksWithChan invokes the vpc.DescribeBgpNetworks API asynchronously
// api document: https://help.aliyun.com/api/vpc/describebgpnetworks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBgpNetworksWithChan(request *DescribeBgpNetworksRequest) (<-chan *DescribeBgpNetworksResponse, <-chan error) {
	responseChan := make(chan *DescribeBgpNetworksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBgpNetworks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBgpNetworksWithCallback invokes the vpc.DescribeBgpNetworks API asynchronously
// api document: https://help.aliyun.com/api/vpc/describebgpnetworks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBgpNetworksWithCallback(request *DescribeBgpNetworksRequest, callback func(response *DescribeBgpNetworksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBgpNetworksResponse
		var err error
		defer close(result)
		response, err = client.DescribeBgpNetworks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBgpNetworksRequest is the request struct for api DescribeBgpNetworks
type DescribeBgpNetworksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RouterId             string           `position:"Query" name:"RouterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeBgpNetworksResponse is the response struct for api DescribeBgpNetworks
type DescribeBgpNetworksResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	BgpNetworks BgpNetworks `json:"BgpNetworks" xml:"BgpNetworks"`
}

// CreateDescribeBgpNetworksRequest creates a request to invoke DescribeBgpNetworks API
func CreateDescribeBgpNetworksRequest() (request *DescribeBgpNetworksRequest) {
	request = &DescribeBgpNetworksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeBgpNetworks", "vpc", "openAPI")
	return
}

// CreateDescribeBgpNetworksResponse creates a response to parse from DescribeBgpNetworks response
func CreateDescribeBgpNetworksResponse() (response *DescribeBgpNetworksResponse) {
	response = &DescribeBgpNetworksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
