/*
Slurm Rest API RO

API to access Slurm. Only GET requests are implemented.

API version: 0.0.38
Contact: sales@schedmd.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package v0038

import (
	"encoding/json"
)

// checks if the V0038JobResponseProperties type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &V0038JobResponseProperties{}

// V0038JobResponseProperties struct for V0038JobResponseProperties
type V0038JobResponseProperties struct {
	// Charge resources used by this job to specified account
	Account *string `json:"account,omitempty"`
	// time job is eligible for running
	AccrueTime *int64 `json:"accrue_time,omitempty"`
	// administrator's arbitrary comment
	AdminComment *string `json:"admin_comment,omitempty"`
	// job_id of a job array or 0 if N/A
	ArrayJobId *int32 `json:"array_job_id,omitempty"`
	// task_id of a job array
	ArrayTaskId *int32 `json:"array_task_id,omitempty"`
	// Maximum number of running array tasks
	ArrayMaxTasks *int32 `json:"array_max_tasks,omitempty"`
	// string expression of task IDs in this record
	ArrayTaskString *string `json:"array_task_string,omitempty"`
	// association id for job
	AssociationId *int32 `json:"association_id,omitempty"`
	// features required for batch script's node
	BatchFeatures *string `json:"batch_features,omitempty"`
	// if batch: queued job with script
	BatchFlag *bool `json:"batch_flag,omitempty"`
	// name of host running batch script
	BatchHost *string `json:"batch_host,omitempty"`
	// Job flags
	Flags []string `json:"flags,omitempty"`
	// burst buffer specifications
	BurstBuffer *string `json:"burst_buffer,omitempty"`
	// burst buffer state info
	BurstBufferState *string `json:"burst_buffer_state,omitempty"`
	// name of cluster that the job is on
	Cluster *string `json:"cluster,omitempty"`
	// comma separated list of required cluster features
	ClusterFeatures *string `json:"cluster_features,omitempty"`
	// command to be executed
	Command *string `json:"command,omitempty"`
	// arbitrary comment
	Comment *string `json:"comment,omitempty"`
	// absolute path to OCI container bundle
	Container *string `json:"container,omitempty"`
	// job requires contiguous nodes
	Contiguous *bool `json:"contiguous,omitempty"`
	// specialized core count
	CoreSpec *string `json:"core_spec,omitempty"`
	// specialized thread count
	ThreadSpec *string `json:"thread_spec,omitempty"`
	// cores per socket required by job
	CoresPerSocket *string `json:"cores_per_socket,omitempty"`
	// billable TRES
	BillableTres *float32 `json:"billable_tres,omitempty"`
	// number of processors required for each task
	CpusPerTask *string `json:"cpus_per_task,omitempty"`
	// Minimum cpu frequency
	CpuFrequencyMinimum *string `json:"cpu_frequency_minimum,omitempty"`
	// Maximum cpu frequency
	CpuFrequencyMaximum *string `json:"cpu_frequency_maximum,omitempty"`
	// cpu frequency governor
	CpuFrequencyGovernor *string `json:"cpu_frequency_governor,omitempty"`
	// semicolon delimited list of TRES=# values
	CpusPerTres *string `json:"cpus_per_tres,omitempty"`
	// job start deadline 
	Deadline *int32 `json:"deadline,omitempty"`
	// command to be executed
	DelayBoot *int32 `json:"delay_boot,omitempty"`
	// synchronize job execution with other jobs
	Dependency *string `json:"dependency,omitempty"`
	// highest exit code of all job steps
	DerivedExitCode *int32 `json:"derived_exit_code,omitempty"`
	// time job is eligible for running
	EligibleTime *int64 `json:"eligible_time,omitempty"`
	// time of termination, actual or expected
	EndTime *int64 `json:"end_time,omitempty"`
	// comma separated list of excluded nodes
	ExcludedNodes *string `json:"excluded_nodes,omitempty"`
	// exit code for job
	ExitCode *int32 `json:"exit_code,omitempty"`
	// comma separated list of required features
	Features *string `json:"features,omitempty"`
	// Origin cluster's name
	FederationOrigin *string `json:"federation_origin,omitempty"`
	// string of active sibling names
	FederationSiblingsActive *string `json:"federation_siblings_active,omitempty"`
	// string of viable sibling names
	FederationSiblingsViable *string `json:"federation_siblings_viable,omitempty"`
	// Job flags
	GresDetail []string `json:"gres_detail,omitempty"`
	// group job submitted as
	GroupId *int32 `json:"group_id,omitempty"`
	// job ID
	JobId *int32 `json:"job_id,omitempty"`
	JobResources *V0038JobResources `json:"job_resources,omitempty"`
	// state of the job
	JobState *string `json:"job_state,omitempty"`
	// last time job was evaluated for scheduling
	LastSchedEvaluation *int32 `json:"last_sched_evaluation,omitempty"`
	// licenses required by the job
	Licenses *string `json:"licenses,omitempty"`
	// maximum number of cpus usable by job
	MaxCpus *int32 `json:"max_cpus,omitempty"`
	// maximum number of nodes usable by job
	MaxNodes *int32 `json:"max_nodes,omitempty"`
	// mcs_label if mcs plugin in use
	McsLabel *string `json:"mcs_label,omitempty"`
	// semicolon delimited list of TRES=# values
	MemoryPerTres *string `json:"memory_per_tres,omitempty"`
	// name of the job
	Name *string `json:"name,omitempty"`
	// list of nodes allocated to job
	Nodes *string `json:"nodes,omitempty"`
	// requested priority change
	Nice *int32 `json:"nice,omitempty"`
	// number of tasks to invoke on each core
	TasksPerCore *int32 `json:"tasks_per_core,omitempty"`
	// number of tasks to invoke on each socket
	TasksPerSocket *int32 `json:"tasks_per_socket,omitempty"`
	// number of tasks to invoke on each board
	TasksPerBoard *int32 `json:"tasks_per_board,omitempty"`
	// minimum number of cpus required by job
	Cpus *int32 `json:"cpus,omitempty"`
	// minimum number of nodes required by job
	NodeCount *int32 `json:"node_count,omitempty"`
	// requested task count
	Tasks *int32 `json:"tasks,omitempty"`
	// job ID of hetjob leader
	HetJobId *int32 `json:"het_job_id,omitempty"`
	// job IDs for all components
	HetJobIdSet *string `json:"het_job_id_set,omitempty"`
	// HetJob component offset from leader
	HetJobOffset *int32 `json:"het_job_offset,omitempty"`
	// name of assigned partition
	Partition *string `json:"partition,omitempty"`
	// minimum real memory per node
	MemoryPerNode *int32 `json:"memory_per_node,omitempty"`
	// minimum real memory per cpu
	MemoryPerCpu *int32 `json:"memory_per_cpu,omitempty"`
	// minimum # CPUs per node
	MinimumCpusPerNode *int32 `json:"minimum_cpus_per_node,omitempty"`
	// minimum tmp disk per node
	MinimumTmpDiskPerNode *int32 `json:"minimum_tmp_disk_per_node,omitempty"`
	// preemption signal time
	PreemptTime *int64 `json:"preempt_time,omitempty"`
	// time job ran prior to last suspend
	PreSusTime *int64 `json:"pre_sus_time,omitempty"`
	// relative priority of the job
	Priority *int64 `json:"priority,omitempty"`
	// Job profiling requested
	Profile []string `json:"profile,omitempty"`
	// Quality of Service
	Qos *string `json:"qos,omitempty"`
	// node reboot requested before start
	Reboot *bool `json:"reboot,omitempty"`
	// comma separated list of required nodes
	RequiredNodes *string `json:"required_nodes,omitempty"`
	// enable or disable job requeue option
	Requeue *bool `json:"requeue,omitempty"`
	// time of latest size change
	ResizeTime *int64 `json:"resize_time,omitempty"`
	// count of job restarts
	RestartCnt *int32 `json:"restart_cnt,omitempty"`
	// reservation name
	ResvName *string `json:"resv_name,omitempty"`
	// type and if job can share nodes with other jobs
	Shared *string `json:"shared,omitempty"`
	// details requested
	ShowFlags []string `json:"show_flags,omitempty"`
	// sockets per board required by job
	SocketsPerBoard *int32 `json:"sockets_per_board,omitempty"`
	// sockets per node required by job
	SocketsPerNode *int32 `json:"sockets_per_node,omitempty"`
	// time execution begins, actual or expected
	StartTime *int64 `json:"start_time,omitempty"`
	// optional details for state_reason
	StateDescription *string `json:"state_description,omitempty"`
	// reason job still pending or failed
	StateReason *string `json:"state_reason,omitempty"`
	// pathname of job's stderr file
	StandardError *string `json:"standard_error,omitempty"`
	// pathname of job's stdin file
	StandardInput *string `json:"standard_input,omitempty"`
	// pathname of job's stdout file
	StandardOutput *string `json:"standard_output,omitempty"`
	// time of job submission
	SubmitTime *int64 `json:"submit_time,omitempty"`
	// time job last suspended or resumed
	SuspendTime *int64 `json:"suspend_time,omitempty"`
	// slurmctld's arbitrary comment
	SystemComment *string `json:"system_comment,omitempty"`
	// maximum run time in minutes
	TimeLimit *int64 `json:"time_limit,omitempty"`
	// minimum run time in minutes
	TimeMinimum *int64 `json:"time_minimum,omitempty"`
	// threads per core required by job
	ThreadsPerCore *int32 `json:"threads_per_core,omitempty"`
	// Task to TRES binding directives
	TresBind *string `json:"tres_bind,omitempty"`
	// TRES frequency directives
	TresFreq *string `json:"tres_freq,omitempty"`
	// semicolon delimited list of TRES=# values
	TresPerJob *string `json:"tres_per_job,omitempty"`
	// semicolon delimited list of TRES=# values
	TresPerNode *string `json:"tres_per_node,omitempty"`
	// semicolon delimited list of TRES=# values
	TresPerSocket *string `json:"tres_per_socket,omitempty"`
	// semicolon delimited list of TRES=# values
	TresPerTask *string `json:"tres_per_task,omitempty"`
	// tres reqeusted in the job
	TresReqStr *string `json:"tres_req_str,omitempty"`
	// tres used in the job
	TresAllocStr *string `json:"tres_alloc_str,omitempty"`
	// user id the job runs as
	UserId *int64 `json:"user_id,omitempty"`
	// user the job runs as
	UserName *string `json:"user_name,omitempty"`
	// wckey for job
	Wckey *string `json:"wckey,omitempty"`
	// pathname of working directory
	CurrentWorkingDirectory *string `json:"current_working_directory,omitempty"`
}

// NewV0038JobResponseProperties instantiates a new V0038JobResponseProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewV0038JobResponseProperties() *V0038JobResponseProperties {
	this := V0038JobResponseProperties{}
	return &this
}

// NewV0038JobResponsePropertiesWithDefaults instantiates a new V0038JobResponseProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewV0038JobResponsePropertiesWithDefaults() *V0038JobResponseProperties {
	this := V0038JobResponseProperties{}
	return &this
}

// GetAccount returns the Account field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetAccount() string {
	if o == nil || IsNil(o.Account) {
		var ret string
		return ret
	}
	return *o.Account
}

// GetAccountOk returns a tuple with the Account field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetAccountOk() (*string, bool) {
	if o == nil || IsNil(o.Account) {
		return nil, false
	}
	return o.Account, true
}

// HasAccount returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasAccount() bool {
	if o != nil && !IsNil(o.Account) {
		return true
	}

	return false
}

// SetAccount gets a reference to the given string and assigns it to the Account field.
func (o *V0038JobResponseProperties) SetAccount(v string) {
	o.Account = &v
}

// GetAccrueTime returns the AccrueTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetAccrueTime() int64 {
	if o == nil || IsNil(o.AccrueTime) {
		var ret int64
		return ret
	}
	return *o.AccrueTime
}

// GetAccrueTimeOk returns a tuple with the AccrueTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetAccrueTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.AccrueTime) {
		return nil, false
	}
	return o.AccrueTime, true
}

// HasAccrueTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasAccrueTime() bool {
	if o != nil && !IsNil(o.AccrueTime) {
		return true
	}

	return false
}

// SetAccrueTime gets a reference to the given int64 and assigns it to the AccrueTime field.
func (o *V0038JobResponseProperties) SetAccrueTime(v int64) {
	o.AccrueTime = &v
}

// GetAdminComment returns the AdminComment field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetAdminComment() string {
	if o == nil || IsNil(o.AdminComment) {
		var ret string
		return ret
	}
	return *o.AdminComment
}

// GetAdminCommentOk returns a tuple with the AdminComment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetAdminCommentOk() (*string, bool) {
	if o == nil || IsNil(o.AdminComment) {
		return nil, false
	}
	return o.AdminComment, true
}

// HasAdminComment returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasAdminComment() bool {
	if o != nil && !IsNil(o.AdminComment) {
		return true
	}

	return false
}

// SetAdminComment gets a reference to the given string and assigns it to the AdminComment field.
func (o *V0038JobResponseProperties) SetAdminComment(v string) {
	o.AdminComment = &v
}

// GetArrayJobId returns the ArrayJobId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetArrayJobId() int32 {
	if o == nil || IsNil(o.ArrayJobId) {
		var ret int32
		return ret
	}
	return *o.ArrayJobId
}

// GetArrayJobIdOk returns a tuple with the ArrayJobId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetArrayJobIdOk() (*int32, bool) {
	if o == nil || IsNil(o.ArrayJobId) {
		return nil, false
	}
	return o.ArrayJobId, true
}

// HasArrayJobId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasArrayJobId() bool {
	if o != nil && !IsNil(o.ArrayJobId) {
		return true
	}

	return false
}

// SetArrayJobId gets a reference to the given int32 and assigns it to the ArrayJobId field.
func (o *V0038JobResponseProperties) SetArrayJobId(v int32) {
	o.ArrayJobId = &v
}

// GetArrayTaskId returns the ArrayTaskId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetArrayTaskId() int32 {
	if o == nil || IsNil(o.ArrayTaskId) {
		var ret int32
		return ret
	}
	return *o.ArrayTaskId
}

// GetArrayTaskIdOk returns a tuple with the ArrayTaskId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetArrayTaskIdOk() (*int32, bool) {
	if o == nil || IsNil(o.ArrayTaskId) {
		return nil, false
	}
	return o.ArrayTaskId, true
}

// HasArrayTaskId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasArrayTaskId() bool {
	if o != nil && !IsNil(o.ArrayTaskId) {
		return true
	}

	return false
}

// SetArrayTaskId gets a reference to the given int32 and assigns it to the ArrayTaskId field.
func (o *V0038JobResponseProperties) SetArrayTaskId(v int32) {
	o.ArrayTaskId = &v
}

// GetArrayMaxTasks returns the ArrayMaxTasks field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetArrayMaxTasks() int32 {
	if o == nil || IsNil(o.ArrayMaxTasks) {
		var ret int32
		return ret
	}
	return *o.ArrayMaxTasks
}

// GetArrayMaxTasksOk returns a tuple with the ArrayMaxTasks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetArrayMaxTasksOk() (*int32, bool) {
	if o == nil || IsNil(o.ArrayMaxTasks) {
		return nil, false
	}
	return o.ArrayMaxTasks, true
}

// HasArrayMaxTasks returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasArrayMaxTasks() bool {
	if o != nil && !IsNil(o.ArrayMaxTasks) {
		return true
	}

	return false
}

// SetArrayMaxTasks gets a reference to the given int32 and assigns it to the ArrayMaxTasks field.
func (o *V0038JobResponseProperties) SetArrayMaxTasks(v int32) {
	o.ArrayMaxTasks = &v
}

// GetArrayTaskString returns the ArrayTaskString field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetArrayTaskString() string {
	if o == nil || IsNil(o.ArrayTaskString) {
		var ret string
		return ret
	}
	return *o.ArrayTaskString
}

// GetArrayTaskStringOk returns a tuple with the ArrayTaskString field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetArrayTaskStringOk() (*string, bool) {
	if o == nil || IsNil(o.ArrayTaskString) {
		return nil, false
	}
	return o.ArrayTaskString, true
}

// HasArrayTaskString returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasArrayTaskString() bool {
	if o != nil && !IsNil(o.ArrayTaskString) {
		return true
	}

	return false
}

// SetArrayTaskString gets a reference to the given string and assigns it to the ArrayTaskString field.
func (o *V0038JobResponseProperties) SetArrayTaskString(v string) {
	o.ArrayTaskString = &v
}

// GetAssociationId returns the AssociationId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetAssociationId() int32 {
	if o == nil || IsNil(o.AssociationId) {
		var ret int32
		return ret
	}
	return *o.AssociationId
}

// GetAssociationIdOk returns a tuple with the AssociationId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetAssociationIdOk() (*int32, bool) {
	if o == nil || IsNil(o.AssociationId) {
		return nil, false
	}
	return o.AssociationId, true
}

// HasAssociationId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasAssociationId() bool {
	if o != nil && !IsNil(o.AssociationId) {
		return true
	}

	return false
}

// SetAssociationId gets a reference to the given int32 and assigns it to the AssociationId field.
func (o *V0038JobResponseProperties) SetAssociationId(v int32) {
	o.AssociationId = &v
}

// GetBatchFeatures returns the BatchFeatures field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetBatchFeatures() string {
	if o == nil || IsNil(o.BatchFeatures) {
		var ret string
		return ret
	}
	return *o.BatchFeatures
}

// GetBatchFeaturesOk returns a tuple with the BatchFeatures field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetBatchFeaturesOk() (*string, bool) {
	if o == nil || IsNil(o.BatchFeatures) {
		return nil, false
	}
	return o.BatchFeatures, true
}

// HasBatchFeatures returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasBatchFeatures() bool {
	if o != nil && !IsNil(o.BatchFeatures) {
		return true
	}

	return false
}

// SetBatchFeatures gets a reference to the given string and assigns it to the BatchFeatures field.
func (o *V0038JobResponseProperties) SetBatchFeatures(v string) {
	o.BatchFeatures = &v
}

// GetBatchFlag returns the BatchFlag field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetBatchFlag() bool {
	if o == nil || IsNil(o.BatchFlag) {
		var ret bool
		return ret
	}
	return *o.BatchFlag
}

// GetBatchFlagOk returns a tuple with the BatchFlag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetBatchFlagOk() (*bool, bool) {
	if o == nil || IsNil(o.BatchFlag) {
		return nil, false
	}
	return o.BatchFlag, true
}

// HasBatchFlag returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasBatchFlag() bool {
	if o != nil && !IsNil(o.BatchFlag) {
		return true
	}

	return false
}

// SetBatchFlag gets a reference to the given bool and assigns it to the BatchFlag field.
func (o *V0038JobResponseProperties) SetBatchFlag(v bool) {
	o.BatchFlag = &v
}

// GetBatchHost returns the BatchHost field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetBatchHost() string {
	if o == nil || IsNil(o.BatchHost) {
		var ret string
		return ret
	}
	return *o.BatchHost
}

// GetBatchHostOk returns a tuple with the BatchHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetBatchHostOk() (*string, bool) {
	if o == nil || IsNil(o.BatchHost) {
		return nil, false
	}
	return o.BatchHost, true
}

// HasBatchHost returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasBatchHost() bool {
	if o != nil && !IsNil(o.BatchHost) {
		return true
	}

	return false
}

// SetBatchHost gets a reference to the given string and assigns it to the BatchHost field.
func (o *V0038JobResponseProperties) SetBatchHost(v string) {
	o.BatchHost = &v
}

// GetFlags returns the Flags field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetFlags() []string {
	if o == nil || IsNil(o.Flags) {
		var ret []string
		return ret
	}
	return o.Flags
}

// GetFlagsOk returns a tuple with the Flags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetFlagsOk() ([]string, bool) {
	if o == nil || IsNil(o.Flags) {
		return nil, false
	}
	return o.Flags, true
}

// HasFlags returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasFlags() bool {
	if o != nil && !IsNil(o.Flags) {
		return true
	}

	return false
}

// SetFlags gets a reference to the given []string and assigns it to the Flags field.
func (o *V0038JobResponseProperties) SetFlags(v []string) {
	o.Flags = v
}

// GetBurstBuffer returns the BurstBuffer field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetBurstBuffer() string {
	if o == nil || IsNil(o.BurstBuffer) {
		var ret string
		return ret
	}
	return *o.BurstBuffer
}

// GetBurstBufferOk returns a tuple with the BurstBuffer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetBurstBufferOk() (*string, bool) {
	if o == nil || IsNil(o.BurstBuffer) {
		return nil, false
	}
	return o.BurstBuffer, true
}

// HasBurstBuffer returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasBurstBuffer() bool {
	if o != nil && !IsNil(o.BurstBuffer) {
		return true
	}

	return false
}

// SetBurstBuffer gets a reference to the given string and assigns it to the BurstBuffer field.
func (o *V0038JobResponseProperties) SetBurstBuffer(v string) {
	o.BurstBuffer = &v
}

// GetBurstBufferState returns the BurstBufferState field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetBurstBufferState() string {
	if o == nil || IsNil(o.BurstBufferState) {
		var ret string
		return ret
	}
	return *o.BurstBufferState
}

// GetBurstBufferStateOk returns a tuple with the BurstBufferState field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetBurstBufferStateOk() (*string, bool) {
	if o == nil || IsNil(o.BurstBufferState) {
		return nil, false
	}
	return o.BurstBufferState, true
}

// HasBurstBufferState returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasBurstBufferState() bool {
	if o != nil && !IsNil(o.BurstBufferState) {
		return true
	}

	return false
}

// SetBurstBufferState gets a reference to the given string and assigns it to the BurstBufferState field.
func (o *V0038JobResponseProperties) SetBurstBufferState(v string) {
	o.BurstBufferState = &v
}

// GetCluster returns the Cluster field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCluster() string {
	if o == nil || IsNil(o.Cluster) {
		var ret string
		return ret
	}
	return *o.Cluster
}

// GetClusterOk returns a tuple with the Cluster field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetClusterOk() (*string, bool) {
	if o == nil || IsNil(o.Cluster) {
		return nil, false
	}
	return o.Cluster, true
}

// HasCluster returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCluster() bool {
	if o != nil && !IsNil(o.Cluster) {
		return true
	}

	return false
}

// SetCluster gets a reference to the given string and assigns it to the Cluster field.
func (o *V0038JobResponseProperties) SetCluster(v string) {
	o.Cluster = &v
}

// GetClusterFeatures returns the ClusterFeatures field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetClusterFeatures() string {
	if o == nil || IsNil(o.ClusterFeatures) {
		var ret string
		return ret
	}
	return *o.ClusterFeatures
}

// GetClusterFeaturesOk returns a tuple with the ClusterFeatures field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetClusterFeaturesOk() (*string, bool) {
	if o == nil || IsNil(o.ClusterFeatures) {
		return nil, false
	}
	return o.ClusterFeatures, true
}

// HasClusterFeatures returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasClusterFeatures() bool {
	if o != nil && !IsNil(o.ClusterFeatures) {
		return true
	}

	return false
}

// SetClusterFeatures gets a reference to the given string and assigns it to the ClusterFeatures field.
func (o *V0038JobResponseProperties) SetClusterFeatures(v string) {
	o.ClusterFeatures = &v
}

// GetCommand returns the Command field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCommand() string {
	if o == nil || IsNil(o.Command) {
		var ret string
		return ret
	}
	return *o.Command
}

// GetCommandOk returns a tuple with the Command field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCommandOk() (*string, bool) {
	if o == nil || IsNil(o.Command) {
		return nil, false
	}
	return o.Command, true
}

// HasCommand returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCommand() bool {
	if o != nil && !IsNil(o.Command) {
		return true
	}

	return false
}

// SetCommand gets a reference to the given string and assigns it to the Command field.
func (o *V0038JobResponseProperties) SetCommand(v string) {
	o.Command = &v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetComment() string {
	if o == nil || IsNil(o.Comment) {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCommentOk() (*string, bool) {
	if o == nil || IsNil(o.Comment) {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasComment() bool {
	if o != nil && !IsNil(o.Comment) {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *V0038JobResponseProperties) SetComment(v string) {
	o.Comment = &v
}

// GetContainer returns the Container field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetContainer() string {
	if o == nil || IsNil(o.Container) {
		var ret string
		return ret
	}
	return *o.Container
}

// GetContainerOk returns a tuple with the Container field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetContainerOk() (*string, bool) {
	if o == nil || IsNil(o.Container) {
		return nil, false
	}
	return o.Container, true
}

// HasContainer returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasContainer() bool {
	if o != nil && !IsNil(o.Container) {
		return true
	}

	return false
}

// SetContainer gets a reference to the given string and assigns it to the Container field.
func (o *V0038JobResponseProperties) SetContainer(v string) {
	o.Container = &v
}

// GetContiguous returns the Contiguous field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetContiguous() bool {
	if o == nil || IsNil(o.Contiguous) {
		var ret bool
		return ret
	}
	return *o.Contiguous
}

// GetContiguousOk returns a tuple with the Contiguous field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetContiguousOk() (*bool, bool) {
	if o == nil || IsNil(o.Contiguous) {
		return nil, false
	}
	return o.Contiguous, true
}

// HasContiguous returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasContiguous() bool {
	if o != nil && !IsNil(o.Contiguous) {
		return true
	}

	return false
}

// SetContiguous gets a reference to the given bool and assigns it to the Contiguous field.
func (o *V0038JobResponseProperties) SetContiguous(v bool) {
	o.Contiguous = &v
}

// GetCoreSpec returns the CoreSpec field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCoreSpec() string {
	if o == nil || IsNil(o.CoreSpec) {
		var ret string
		return ret
	}
	return *o.CoreSpec
}

// GetCoreSpecOk returns a tuple with the CoreSpec field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCoreSpecOk() (*string, bool) {
	if o == nil || IsNil(o.CoreSpec) {
		return nil, false
	}
	return o.CoreSpec, true
}

// HasCoreSpec returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCoreSpec() bool {
	if o != nil && !IsNil(o.CoreSpec) {
		return true
	}

	return false
}

// SetCoreSpec gets a reference to the given string and assigns it to the CoreSpec field.
func (o *V0038JobResponseProperties) SetCoreSpec(v string) {
	o.CoreSpec = &v
}

// GetThreadSpec returns the ThreadSpec field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetThreadSpec() string {
	if o == nil || IsNil(o.ThreadSpec) {
		var ret string
		return ret
	}
	return *o.ThreadSpec
}

// GetThreadSpecOk returns a tuple with the ThreadSpec field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetThreadSpecOk() (*string, bool) {
	if o == nil || IsNil(o.ThreadSpec) {
		return nil, false
	}
	return o.ThreadSpec, true
}

// HasThreadSpec returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasThreadSpec() bool {
	if o != nil && !IsNil(o.ThreadSpec) {
		return true
	}

	return false
}

// SetThreadSpec gets a reference to the given string and assigns it to the ThreadSpec field.
func (o *V0038JobResponseProperties) SetThreadSpec(v string) {
	o.ThreadSpec = &v
}

// GetCoresPerSocket returns the CoresPerSocket field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCoresPerSocket() string {
	if o == nil || IsNil(o.CoresPerSocket) {
		var ret string
		return ret
	}
	return *o.CoresPerSocket
}

// GetCoresPerSocketOk returns a tuple with the CoresPerSocket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCoresPerSocketOk() (*string, bool) {
	if o == nil || IsNil(o.CoresPerSocket) {
		return nil, false
	}
	return o.CoresPerSocket, true
}

// HasCoresPerSocket returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCoresPerSocket() bool {
	if o != nil && !IsNil(o.CoresPerSocket) {
		return true
	}

	return false
}

// SetCoresPerSocket gets a reference to the given string and assigns it to the CoresPerSocket field.
func (o *V0038JobResponseProperties) SetCoresPerSocket(v string) {
	o.CoresPerSocket = &v
}

// GetBillableTres returns the BillableTres field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetBillableTres() float32 {
	if o == nil || IsNil(o.BillableTres) {
		var ret float32
		return ret
	}
	return *o.BillableTres
}

// GetBillableTresOk returns a tuple with the BillableTres field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetBillableTresOk() (*float32, bool) {
	if o == nil || IsNil(o.BillableTres) {
		return nil, false
	}
	return o.BillableTres, true
}

// HasBillableTres returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasBillableTres() bool {
	if o != nil && !IsNil(o.BillableTres) {
		return true
	}

	return false
}

// SetBillableTres gets a reference to the given float32 and assigns it to the BillableTres field.
func (o *V0038JobResponseProperties) SetBillableTres(v float32) {
	o.BillableTres = &v
}

// GetCpusPerTask returns the CpusPerTask field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCpusPerTask() string {
	if o == nil || IsNil(o.CpusPerTask) {
		var ret string
		return ret
	}
	return *o.CpusPerTask
}

// GetCpusPerTaskOk returns a tuple with the CpusPerTask field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCpusPerTaskOk() (*string, bool) {
	if o == nil || IsNil(o.CpusPerTask) {
		return nil, false
	}
	return o.CpusPerTask, true
}

// HasCpusPerTask returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCpusPerTask() bool {
	if o != nil && !IsNil(o.CpusPerTask) {
		return true
	}

	return false
}

// SetCpusPerTask gets a reference to the given string and assigns it to the CpusPerTask field.
func (o *V0038JobResponseProperties) SetCpusPerTask(v string) {
	o.CpusPerTask = &v
}

// GetCpuFrequencyMinimum returns the CpuFrequencyMinimum field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCpuFrequencyMinimum() string {
	if o == nil || IsNil(o.CpuFrequencyMinimum) {
		var ret string
		return ret
	}
	return *o.CpuFrequencyMinimum
}

// GetCpuFrequencyMinimumOk returns a tuple with the CpuFrequencyMinimum field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCpuFrequencyMinimumOk() (*string, bool) {
	if o == nil || IsNil(o.CpuFrequencyMinimum) {
		return nil, false
	}
	return o.CpuFrequencyMinimum, true
}

// HasCpuFrequencyMinimum returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCpuFrequencyMinimum() bool {
	if o != nil && !IsNil(o.CpuFrequencyMinimum) {
		return true
	}

	return false
}

// SetCpuFrequencyMinimum gets a reference to the given string and assigns it to the CpuFrequencyMinimum field.
func (o *V0038JobResponseProperties) SetCpuFrequencyMinimum(v string) {
	o.CpuFrequencyMinimum = &v
}

// GetCpuFrequencyMaximum returns the CpuFrequencyMaximum field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCpuFrequencyMaximum() string {
	if o == nil || IsNil(o.CpuFrequencyMaximum) {
		var ret string
		return ret
	}
	return *o.CpuFrequencyMaximum
}

// GetCpuFrequencyMaximumOk returns a tuple with the CpuFrequencyMaximum field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCpuFrequencyMaximumOk() (*string, bool) {
	if o == nil || IsNil(o.CpuFrequencyMaximum) {
		return nil, false
	}
	return o.CpuFrequencyMaximum, true
}

// HasCpuFrequencyMaximum returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCpuFrequencyMaximum() bool {
	if o != nil && !IsNil(o.CpuFrequencyMaximum) {
		return true
	}

	return false
}

// SetCpuFrequencyMaximum gets a reference to the given string and assigns it to the CpuFrequencyMaximum field.
func (o *V0038JobResponseProperties) SetCpuFrequencyMaximum(v string) {
	o.CpuFrequencyMaximum = &v
}

// GetCpuFrequencyGovernor returns the CpuFrequencyGovernor field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCpuFrequencyGovernor() string {
	if o == nil || IsNil(o.CpuFrequencyGovernor) {
		var ret string
		return ret
	}
	return *o.CpuFrequencyGovernor
}

// GetCpuFrequencyGovernorOk returns a tuple with the CpuFrequencyGovernor field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCpuFrequencyGovernorOk() (*string, bool) {
	if o == nil || IsNil(o.CpuFrequencyGovernor) {
		return nil, false
	}
	return o.CpuFrequencyGovernor, true
}

// HasCpuFrequencyGovernor returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCpuFrequencyGovernor() bool {
	if o != nil && !IsNil(o.CpuFrequencyGovernor) {
		return true
	}

	return false
}

// SetCpuFrequencyGovernor gets a reference to the given string and assigns it to the CpuFrequencyGovernor field.
func (o *V0038JobResponseProperties) SetCpuFrequencyGovernor(v string) {
	o.CpuFrequencyGovernor = &v
}

// GetCpusPerTres returns the CpusPerTres field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCpusPerTres() string {
	if o == nil || IsNil(o.CpusPerTres) {
		var ret string
		return ret
	}
	return *o.CpusPerTres
}

// GetCpusPerTresOk returns a tuple with the CpusPerTres field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCpusPerTresOk() (*string, bool) {
	if o == nil || IsNil(o.CpusPerTres) {
		return nil, false
	}
	return o.CpusPerTres, true
}

// HasCpusPerTres returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCpusPerTres() bool {
	if o != nil && !IsNil(o.CpusPerTres) {
		return true
	}

	return false
}

// SetCpusPerTres gets a reference to the given string and assigns it to the CpusPerTres field.
func (o *V0038JobResponseProperties) SetCpusPerTres(v string) {
	o.CpusPerTres = &v
}

// GetDeadline returns the Deadline field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetDeadline() int32 {
	if o == nil || IsNil(o.Deadline) {
		var ret int32
		return ret
	}
	return *o.Deadline
}

// GetDeadlineOk returns a tuple with the Deadline field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetDeadlineOk() (*int32, bool) {
	if o == nil || IsNil(o.Deadline) {
		return nil, false
	}
	return o.Deadline, true
}

// HasDeadline returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasDeadline() bool {
	if o != nil && !IsNil(o.Deadline) {
		return true
	}

	return false
}

// SetDeadline gets a reference to the given int32 and assigns it to the Deadline field.
func (o *V0038JobResponseProperties) SetDeadline(v int32) {
	o.Deadline = &v
}

// GetDelayBoot returns the DelayBoot field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetDelayBoot() int32 {
	if o == nil || IsNil(o.DelayBoot) {
		var ret int32
		return ret
	}
	return *o.DelayBoot
}

// GetDelayBootOk returns a tuple with the DelayBoot field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetDelayBootOk() (*int32, bool) {
	if o == nil || IsNil(o.DelayBoot) {
		return nil, false
	}
	return o.DelayBoot, true
}

// HasDelayBoot returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasDelayBoot() bool {
	if o != nil && !IsNil(o.DelayBoot) {
		return true
	}

	return false
}

// SetDelayBoot gets a reference to the given int32 and assigns it to the DelayBoot field.
func (o *V0038JobResponseProperties) SetDelayBoot(v int32) {
	o.DelayBoot = &v
}

// GetDependency returns the Dependency field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetDependency() string {
	if o == nil || IsNil(o.Dependency) {
		var ret string
		return ret
	}
	return *o.Dependency
}

// GetDependencyOk returns a tuple with the Dependency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetDependencyOk() (*string, bool) {
	if o == nil || IsNil(o.Dependency) {
		return nil, false
	}
	return o.Dependency, true
}

// HasDependency returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasDependency() bool {
	if o != nil && !IsNil(o.Dependency) {
		return true
	}

	return false
}

// SetDependency gets a reference to the given string and assigns it to the Dependency field.
func (o *V0038JobResponseProperties) SetDependency(v string) {
	o.Dependency = &v
}

// GetDerivedExitCode returns the DerivedExitCode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetDerivedExitCode() int32 {
	if o == nil || IsNil(o.DerivedExitCode) {
		var ret int32
		return ret
	}
	return *o.DerivedExitCode
}

// GetDerivedExitCodeOk returns a tuple with the DerivedExitCode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetDerivedExitCodeOk() (*int32, bool) {
	if o == nil || IsNil(o.DerivedExitCode) {
		return nil, false
	}
	return o.DerivedExitCode, true
}

// HasDerivedExitCode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasDerivedExitCode() bool {
	if o != nil && !IsNil(o.DerivedExitCode) {
		return true
	}

	return false
}

// SetDerivedExitCode gets a reference to the given int32 and assigns it to the DerivedExitCode field.
func (o *V0038JobResponseProperties) SetDerivedExitCode(v int32) {
	o.DerivedExitCode = &v
}

// GetEligibleTime returns the EligibleTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetEligibleTime() int64 {
	if o == nil || IsNil(o.EligibleTime) {
		var ret int64
		return ret
	}
	return *o.EligibleTime
}

// GetEligibleTimeOk returns a tuple with the EligibleTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetEligibleTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.EligibleTime) {
		return nil, false
	}
	return o.EligibleTime, true
}

// HasEligibleTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasEligibleTime() bool {
	if o != nil && !IsNil(o.EligibleTime) {
		return true
	}

	return false
}

// SetEligibleTime gets a reference to the given int64 and assigns it to the EligibleTime field.
func (o *V0038JobResponseProperties) SetEligibleTime(v int64) {
	o.EligibleTime = &v
}

// GetEndTime returns the EndTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetEndTime() int64 {
	if o == nil || IsNil(o.EndTime) {
		var ret int64
		return ret
	}
	return *o.EndTime
}

// GetEndTimeOk returns a tuple with the EndTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetEndTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.EndTime) {
		return nil, false
	}
	return o.EndTime, true
}

// HasEndTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasEndTime() bool {
	if o != nil && !IsNil(o.EndTime) {
		return true
	}

	return false
}

// SetEndTime gets a reference to the given int64 and assigns it to the EndTime field.
func (o *V0038JobResponseProperties) SetEndTime(v int64) {
	o.EndTime = &v
}

// GetExcludedNodes returns the ExcludedNodes field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetExcludedNodes() string {
	if o == nil || IsNil(o.ExcludedNodes) {
		var ret string
		return ret
	}
	return *o.ExcludedNodes
}

// GetExcludedNodesOk returns a tuple with the ExcludedNodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetExcludedNodesOk() (*string, bool) {
	if o == nil || IsNil(o.ExcludedNodes) {
		return nil, false
	}
	return o.ExcludedNodes, true
}

// HasExcludedNodes returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasExcludedNodes() bool {
	if o != nil && !IsNil(o.ExcludedNodes) {
		return true
	}

	return false
}

// SetExcludedNodes gets a reference to the given string and assigns it to the ExcludedNodes field.
func (o *V0038JobResponseProperties) SetExcludedNodes(v string) {
	o.ExcludedNodes = &v
}

// GetExitCode returns the ExitCode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetExitCode() int32 {
	if o == nil || IsNil(o.ExitCode) {
		var ret int32
		return ret
	}
	return *o.ExitCode
}

// GetExitCodeOk returns a tuple with the ExitCode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetExitCodeOk() (*int32, bool) {
	if o == nil || IsNil(o.ExitCode) {
		return nil, false
	}
	return o.ExitCode, true
}

// HasExitCode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasExitCode() bool {
	if o != nil && !IsNil(o.ExitCode) {
		return true
	}

	return false
}

// SetExitCode gets a reference to the given int32 and assigns it to the ExitCode field.
func (o *V0038JobResponseProperties) SetExitCode(v int32) {
	o.ExitCode = &v
}

// GetFeatures returns the Features field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetFeatures() string {
	if o == nil || IsNil(o.Features) {
		var ret string
		return ret
	}
	return *o.Features
}

// GetFeaturesOk returns a tuple with the Features field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetFeaturesOk() (*string, bool) {
	if o == nil || IsNil(o.Features) {
		return nil, false
	}
	return o.Features, true
}

// HasFeatures returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasFeatures() bool {
	if o != nil && !IsNil(o.Features) {
		return true
	}

	return false
}

// SetFeatures gets a reference to the given string and assigns it to the Features field.
func (o *V0038JobResponseProperties) SetFeatures(v string) {
	o.Features = &v
}

// GetFederationOrigin returns the FederationOrigin field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetFederationOrigin() string {
	if o == nil || IsNil(o.FederationOrigin) {
		var ret string
		return ret
	}
	return *o.FederationOrigin
}

// GetFederationOriginOk returns a tuple with the FederationOrigin field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetFederationOriginOk() (*string, bool) {
	if o == nil || IsNil(o.FederationOrigin) {
		return nil, false
	}
	return o.FederationOrigin, true
}

// HasFederationOrigin returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasFederationOrigin() bool {
	if o != nil && !IsNil(o.FederationOrigin) {
		return true
	}

	return false
}

// SetFederationOrigin gets a reference to the given string and assigns it to the FederationOrigin field.
func (o *V0038JobResponseProperties) SetFederationOrigin(v string) {
	o.FederationOrigin = &v
}

// GetFederationSiblingsActive returns the FederationSiblingsActive field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetFederationSiblingsActive() string {
	if o == nil || IsNil(o.FederationSiblingsActive) {
		var ret string
		return ret
	}
	return *o.FederationSiblingsActive
}

// GetFederationSiblingsActiveOk returns a tuple with the FederationSiblingsActive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetFederationSiblingsActiveOk() (*string, bool) {
	if o == nil || IsNil(o.FederationSiblingsActive) {
		return nil, false
	}
	return o.FederationSiblingsActive, true
}

// HasFederationSiblingsActive returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasFederationSiblingsActive() bool {
	if o != nil && !IsNil(o.FederationSiblingsActive) {
		return true
	}

	return false
}

// SetFederationSiblingsActive gets a reference to the given string and assigns it to the FederationSiblingsActive field.
func (o *V0038JobResponseProperties) SetFederationSiblingsActive(v string) {
	o.FederationSiblingsActive = &v
}

// GetFederationSiblingsViable returns the FederationSiblingsViable field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetFederationSiblingsViable() string {
	if o == nil || IsNil(o.FederationSiblingsViable) {
		var ret string
		return ret
	}
	return *o.FederationSiblingsViable
}

// GetFederationSiblingsViableOk returns a tuple with the FederationSiblingsViable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetFederationSiblingsViableOk() (*string, bool) {
	if o == nil || IsNil(o.FederationSiblingsViable) {
		return nil, false
	}
	return o.FederationSiblingsViable, true
}

// HasFederationSiblingsViable returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasFederationSiblingsViable() bool {
	if o != nil && !IsNil(o.FederationSiblingsViable) {
		return true
	}

	return false
}

// SetFederationSiblingsViable gets a reference to the given string and assigns it to the FederationSiblingsViable field.
func (o *V0038JobResponseProperties) SetFederationSiblingsViable(v string) {
	o.FederationSiblingsViable = &v
}

// GetGresDetail returns the GresDetail field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetGresDetail() []string {
	if o == nil || IsNil(o.GresDetail) {
		var ret []string
		return ret
	}
	return o.GresDetail
}

// GetGresDetailOk returns a tuple with the GresDetail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetGresDetailOk() ([]string, bool) {
	if o == nil || IsNil(o.GresDetail) {
		return nil, false
	}
	return o.GresDetail, true
}

// HasGresDetail returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasGresDetail() bool {
	if o != nil && !IsNil(o.GresDetail) {
		return true
	}

	return false
}

// SetGresDetail gets a reference to the given []string and assigns it to the GresDetail field.
func (o *V0038JobResponseProperties) SetGresDetail(v []string) {
	o.GresDetail = v
}

// GetGroupId returns the GroupId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetGroupId() int32 {
	if o == nil || IsNil(o.GroupId) {
		var ret int32
		return ret
	}
	return *o.GroupId
}

// GetGroupIdOk returns a tuple with the GroupId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetGroupIdOk() (*int32, bool) {
	if o == nil || IsNil(o.GroupId) {
		return nil, false
	}
	return o.GroupId, true
}

// HasGroupId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasGroupId() bool {
	if o != nil && !IsNil(o.GroupId) {
		return true
	}

	return false
}

// SetGroupId gets a reference to the given int32 and assigns it to the GroupId field.
func (o *V0038JobResponseProperties) SetGroupId(v int32) {
	o.GroupId = &v
}

// GetJobId returns the JobId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetJobId() int32 {
	if o == nil || IsNil(o.JobId) {
		var ret int32
		return ret
	}
	return *o.JobId
}

// GetJobIdOk returns a tuple with the JobId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetJobIdOk() (*int32, bool) {
	if o == nil || IsNil(o.JobId) {
		return nil, false
	}
	return o.JobId, true
}

// HasJobId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasJobId() bool {
	if o != nil && !IsNil(o.JobId) {
		return true
	}

	return false
}

// SetJobId gets a reference to the given int32 and assigns it to the JobId field.
func (o *V0038JobResponseProperties) SetJobId(v int32) {
	o.JobId = &v
}

// GetJobResources returns the JobResources field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetJobResources() V0038JobResources {
	if o == nil || IsNil(o.JobResources) {
		var ret V0038JobResources
		return ret
	}
	return *o.JobResources
}

// GetJobResourcesOk returns a tuple with the JobResources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetJobResourcesOk() (*V0038JobResources, bool) {
	if o == nil || IsNil(o.JobResources) {
		return nil, false
	}
	return o.JobResources, true
}

// HasJobResources returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasJobResources() bool {
	if o != nil && !IsNil(o.JobResources) {
		return true
	}

	return false
}

// SetJobResources gets a reference to the given V0038JobResources and assigns it to the JobResources field.
func (o *V0038JobResponseProperties) SetJobResources(v V0038JobResources) {
	o.JobResources = &v
}

// GetJobState returns the JobState field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetJobState() string {
	if o == nil || IsNil(o.JobState) {
		var ret string
		return ret
	}
	return *o.JobState
}

// GetJobStateOk returns a tuple with the JobState field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetJobStateOk() (*string, bool) {
	if o == nil || IsNil(o.JobState) {
		return nil, false
	}
	return o.JobState, true
}

// HasJobState returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasJobState() bool {
	if o != nil && !IsNil(o.JobState) {
		return true
	}

	return false
}

// SetJobState gets a reference to the given string and assigns it to the JobState field.
func (o *V0038JobResponseProperties) SetJobState(v string) {
	o.JobState = &v
}

// GetLastSchedEvaluation returns the LastSchedEvaluation field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetLastSchedEvaluation() int32 {
	if o == nil || IsNil(o.LastSchedEvaluation) {
		var ret int32
		return ret
	}
	return *o.LastSchedEvaluation
}

// GetLastSchedEvaluationOk returns a tuple with the LastSchedEvaluation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetLastSchedEvaluationOk() (*int32, bool) {
	if o == nil || IsNil(o.LastSchedEvaluation) {
		return nil, false
	}
	return o.LastSchedEvaluation, true
}

// HasLastSchedEvaluation returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasLastSchedEvaluation() bool {
	if o != nil && !IsNil(o.LastSchedEvaluation) {
		return true
	}

	return false
}

// SetLastSchedEvaluation gets a reference to the given int32 and assigns it to the LastSchedEvaluation field.
func (o *V0038JobResponseProperties) SetLastSchedEvaluation(v int32) {
	o.LastSchedEvaluation = &v
}

// GetLicenses returns the Licenses field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetLicenses() string {
	if o == nil || IsNil(o.Licenses) {
		var ret string
		return ret
	}
	return *o.Licenses
}

// GetLicensesOk returns a tuple with the Licenses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetLicensesOk() (*string, bool) {
	if o == nil || IsNil(o.Licenses) {
		return nil, false
	}
	return o.Licenses, true
}

// HasLicenses returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasLicenses() bool {
	if o != nil && !IsNil(o.Licenses) {
		return true
	}

	return false
}

// SetLicenses gets a reference to the given string and assigns it to the Licenses field.
func (o *V0038JobResponseProperties) SetLicenses(v string) {
	o.Licenses = &v
}

// GetMaxCpus returns the MaxCpus field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMaxCpus() int32 {
	if o == nil || IsNil(o.MaxCpus) {
		var ret int32
		return ret
	}
	return *o.MaxCpus
}

// GetMaxCpusOk returns a tuple with the MaxCpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMaxCpusOk() (*int32, bool) {
	if o == nil || IsNil(o.MaxCpus) {
		return nil, false
	}
	return o.MaxCpus, true
}

// HasMaxCpus returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMaxCpus() bool {
	if o != nil && !IsNil(o.MaxCpus) {
		return true
	}

	return false
}

// SetMaxCpus gets a reference to the given int32 and assigns it to the MaxCpus field.
func (o *V0038JobResponseProperties) SetMaxCpus(v int32) {
	o.MaxCpus = &v
}

// GetMaxNodes returns the MaxNodes field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMaxNodes() int32 {
	if o == nil || IsNil(o.MaxNodes) {
		var ret int32
		return ret
	}
	return *o.MaxNodes
}

// GetMaxNodesOk returns a tuple with the MaxNodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMaxNodesOk() (*int32, bool) {
	if o == nil || IsNil(o.MaxNodes) {
		return nil, false
	}
	return o.MaxNodes, true
}

// HasMaxNodes returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMaxNodes() bool {
	if o != nil && !IsNil(o.MaxNodes) {
		return true
	}

	return false
}

// SetMaxNodes gets a reference to the given int32 and assigns it to the MaxNodes field.
func (o *V0038JobResponseProperties) SetMaxNodes(v int32) {
	o.MaxNodes = &v
}

// GetMcsLabel returns the McsLabel field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMcsLabel() string {
	if o == nil || IsNil(o.McsLabel) {
		var ret string
		return ret
	}
	return *o.McsLabel
}

// GetMcsLabelOk returns a tuple with the McsLabel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMcsLabelOk() (*string, bool) {
	if o == nil || IsNil(o.McsLabel) {
		return nil, false
	}
	return o.McsLabel, true
}

// HasMcsLabel returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMcsLabel() bool {
	if o != nil && !IsNil(o.McsLabel) {
		return true
	}

	return false
}

// SetMcsLabel gets a reference to the given string and assigns it to the McsLabel field.
func (o *V0038JobResponseProperties) SetMcsLabel(v string) {
	o.McsLabel = &v
}

// GetMemoryPerTres returns the MemoryPerTres field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMemoryPerTres() string {
	if o == nil || IsNil(o.MemoryPerTres) {
		var ret string
		return ret
	}
	return *o.MemoryPerTres
}

// GetMemoryPerTresOk returns a tuple with the MemoryPerTres field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMemoryPerTresOk() (*string, bool) {
	if o == nil || IsNil(o.MemoryPerTres) {
		return nil, false
	}
	return o.MemoryPerTres, true
}

// HasMemoryPerTres returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMemoryPerTres() bool {
	if o != nil && !IsNil(o.MemoryPerTres) {
		return true
	}

	return false
}

// SetMemoryPerTres gets a reference to the given string and assigns it to the MemoryPerTres field.
func (o *V0038JobResponseProperties) SetMemoryPerTres(v string) {
	o.MemoryPerTres = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *V0038JobResponseProperties) SetName(v string) {
	o.Name = &v
}

// GetNodes returns the Nodes field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetNodes() string {
	if o == nil || IsNil(o.Nodes) {
		var ret string
		return ret
	}
	return *o.Nodes
}

// GetNodesOk returns a tuple with the Nodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetNodesOk() (*string, bool) {
	if o == nil || IsNil(o.Nodes) {
		return nil, false
	}
	return o.Nodes, true
}

// HasNodes returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasNodes() bool {
	if o != nil && !IsNil(o.Nodes) {
		return true
	}

	return false
}

// SetNodes gets a reference to the given string and assigns it to the Nodes field.
func (o *V0038JobResponseProperties) SetNodes(v string) {
	o.Nodes = &v
}

// GetNice returns the Nice field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetNice() int32 {
	if o == nil || IsNil(o.Nice) {
		var ret int32
		return ret
	}
	return *o.Nice
}

// GetNiceOk returns a tuple with the Nice field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetNiceOk() (*int32, bool) {
	if o == nil || IsNil(o.Nice) {
		return nil, false
	}
	return o.Nice, true
}

// HasNice returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasNice() bool {
	if o != nil && !IsNil(o.Nice) {
		return true
	}

	return false
}

// SetNice gets a reference to the given int32 and assigns it to the Nice field.
func (o *V0038JobResponseProperties) SetNice(v int32) {
	o.Nice = &v
}

// GetTasksPerCore returns the TasksPerCore field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTasksPerCore() int32 {
	if o == nil || IsNil(o.TasksPerCore) {
		var ret int32
		return ret
	}
	return *o.TasksPerCore
}

// GetTasksPerCoreOk returns a tuple with the TasksPerCore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTasksPerCoreOk() (*int32, bool) {
	if o == nil || IsNil(o.TasksPerCore) {
		return nil, false
	}
	return o.TasksPerCore, true
}

// HasTasksPerCore returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTasksPerCore() bool {
	if o != nil && !IsNil(o.TasksPerCore) {
		return true
	}

	return false
}

// SetTasksPerCore gets a reference to the given int32 and assigns it to the TasksPerCore field.
func (o *V0038JobResponseProperties) SetTasksPerCore(v int32) {
	o.TasksPerCore = &v
}

// GetTasksPerSocket returns the TasksPerSocket field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTasksPerSocket() int32 {
	if o == nil || IsNil(o.TasksPerSocket) {
		var ret int32
		return ret
	}
	return *o.TasksPerSocket
}

// GetTasksPerSocketOk returns a tuple with the TasksPerSocket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTasksPerSocketOk() (*int32, bool) {
	if o == nil || IsNil(o.TasksPerSocket) {
		return nil, false
	}
	return o.TasksPerSocket, true
}

// HasTasksPerSocket returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTasksPerSocket() bool {
	if o != nil && !IsNil(o.TasksPerSocket) {
		return true
	}

	return false
}

// SetTasksPerSocket gets a reference to the given int32 and assigns it to the TasksPerSocket field.
func (o *V0038JobResponseProperties) SetTasksPerSocket(v int32) {
	o.TasksPerSocket = &v
}

// GetTasksPerBoard returns the TasksPerBoard field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTasksPerBoard() int32 {
	if o == nil || IsNil(o.TasksPerBoard) {
		var ret int32
		return ret
	}
	return *o.TasksPerBoard
}

// GetTasksPerBoardOk returns a tuple with the TasksPerBoard field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTasksPerBoardOk() (*int32, bool) {
	if o == nil || IsNil(o.TasksPerBoard) {
		return nil, false
	}
	return o.TasksPerBoard, true
}

// HasTasksPerBoard returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTasksPerBoard() bool {
	if o != nil && !IsNil(o.TasksPerBoard) {
		return true
	}

	return false
}

// SetTasksPerBoard gets a reference to the given int32 and assigns it to the TasksPerBoard field.
func (o *V0038JobResponseProperties) SetTasksPerBoard(v int32) {
	o.TasksPerBoard = &v
}

// GetCpus returns the Cpus field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCpus() int32 {
	if o == nil || IsNil(o.Cpus) {
		var ret int32
		return ret
	}
	return *o.Cpus
}

// GetCpusOk returns a tuple with the Cpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCpusOk() (*int32, bool) {
	if o == nil || IsNil(o.Cpus) {
		return nil, false
	}
	return o.Cpus, true
}

// HasCpus returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCpus() bool {
	if o != nil && !IsNil(o.Cpus) {
		return true
	}

	return false
}

// SetCpus gets a reference to the given int32 and assigns it to the Cpus field.
func (o *V0038JobResponseProperties) SetCpus(v int32) {
	o.Cpus = &v
}

// GetNodeCount returns the NodeCount field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetNodeCount() int32 {
	if o == nil || IsNil(o.NodeCount) {
		var ret int32
		return ret
	}
	return *o.NodeCount
}

// GetNodeCountOk returns a tuple with the NodeCount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetNodeCountOk() (*int32, bool) {
	if o == nil || IsNil(o.NodeCount) {
		return nil, false
	}
	return o.NodeCount, true
}

// HasNodeCount returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasNodeCount() bool {
	if o != nil && !IsNil(o.NodeCount) {
		return true
	}

	return false
}

// SetNodeCount gets a reference to the given int32 and assigns it to the NodeCount field.
func (o *V0038JobResponseProperties) SetNodeCount(v int32) {
	o.NodeCount = &v
}

// GetTasks returns the Tasks field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTasks() int32 {
	if o == nil || IsNil(o.Tasks) {
		var ret int32
		return ret
	}
	return *o.Tasks
}

// GetTasksOk returns a tuple with the Tasks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTasksOk() (*int32, bool) {
	if o == nil || IsNil(o.Tasks) {
		return nil, false
	}
	return o.Tasks, true
}

// HasTasks returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTasks() bool {
	if o != nil && !IsNil(o.Tasks) {
		return true
	}

	return false
}

// SetTasks gets a reference to the given int32 and assigns it to the Tasks field.
func (o *V0038JobResponseProperties) SetTasks(v int32) {
	o.Tasks = &v
}

// GetHetJobId returns the HetJobId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetHetJobId() int32 {
	if o == nil || IsNil(o.HetJobId) {
		var ret int32
		return ret
	}
	return *o.HetJobId
}

// GetHetJobIdOk returns a tuple with the HetJobId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetHetJobIdOk() (*int32, bool) {
	if o == nil || IsNil(o.HetJobId) {
		return nil, false
	}
	return o.HetJobId, true
}

// HasHetJobId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasHetJobId() bool {
	if o != nil && !IsNil(o.HetJobId) {
		return true
	}

	return false
}

// SetHetJobId gets a reference to the given int32 and assigns it to the HetJobId field.
func (o *V0038JobResponseProperties) SetHetJobId(v int32) {
	o.HetJobId = &v
}

// GetHetJobIdSet returns the HetJobIdSet field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetHetJobIdSet() string {
	if o == nil || IsNil(o.HetJobIdSet) {
		var ret string
		return ret
	}
	return *o.HetJobIdSet
}

// GetHetJobIdSetOk returns a tuple with the HetJobIdSet field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetHetJobIdSetOk() (*string, bool) {
	if o == nil || IsNil(o.HetJobIdSet) {
		return nil, false
	}
	return o.HetJobIdSet, true
}

// HasHetJobIdSet returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasHetJobIdSet() bool {
	if o != nil && !IsNil(o.HetJobIdSet) {
		return true
	}

	return false
}

// SetHetJobIdSet gets a reference to the given string and assigns it to the HetJobIdSet field.
func (o *V0038JobResponseProperties) SetHetJobIdSet(v string) {
	o.HetJobIdSet = &v
}

// GetHetJobOffset returns the HetJobOffset field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetHetJobOffset() int32 {
	if o == nil || IsNil(o.HetJobOffset) {
		var ret int32
		return ret
	}
	return *o.HetJobOffset
}

// GetHetJobOffsetOk returns a tuple with the HetJobOffset field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetHetJobOffsetOk() (*int32, bool) {
	if o == nil || IsNil(o.HetJobOffset) {
		return nil, false
	}
	return o.HetJobOffset, true
}

// HasHetJobOffset returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasHetJobOffset() bool {
	if o != nil && !IsNil(o.HetJobOffset) {
		return true
	}

	return false
}

// SetHetJobOffset gets a reference to the given int32 and assigns it to the HetJobOffset field.
func (o *V0038JobResponseProperties) SetHetJobOffset(v int32) {
	o.HetJobOffset = &v
}

// GetPartition returns the Partition field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetPartition() string {
	if o == nil || IsNil(o.Partition) {
		var ret string
		return ret
	}
	return *o.Partition
}

// GetPartitionOk returns a tuple with the Partition field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetPartitionOk() (*string, bool) {
	if o == nil || IsNil(o.Partition) {
		return nil, false
	}
	return o.Partition, true
}

// HasPartition returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasPartition() bool {
	if o != nil && !IsNil(o.Partition) {
		return true
	}

	return false
}

// SetPartition gets a reference to the given string and assigns it to the Partition field.
func (o *V0038JobResponseProperties) SetPartition(v string) {
	o.Partition = &v
}

// GetMemoryPerNode returns the MemoryPerNode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMemoryPerNode() int32 {
	if o == nil || IsNil(o.MemoryPerNode) {
		var ret int32
		return ret
	}
	return *o.MemoryPerNode
}

// GetMemoryPerNodeOk returns a tuple with the MemoryPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMemoryPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.MemoryPerNode) {
		return nil, false
	}
	return o.MemoryPerNode, true
}

// HasMemoryPerNode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMemoryPerNode() bool {
	if o != nil && !IsNil(o.MemoryPerNode) {
		return true
	}

	return false
}

// SetMemoryPerNode gets a reference to the given int32 and assigns it to the MemoryPerNode field.
func (o *V0038JobResponseProperties) SetMemoryPerNode(v int32) {
	o.MemoryPerNode = &v
}

// GetMemoryPerCpu returns the MemoryPerCpu field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMemoryPerCpu() int32 {
	if o == nil || IsNil(o.MemoryPerCpu) {
		var ret int32
		return ret
	}
	return *o.MemoryPerCpu
}

// GetMemoryPerCpuOk returns a tuple with the MemoryPerCpu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMemoryPerCpuOk() (*int32, bool) {
	if o == nil || IsNil(o.MemoryPerCpu) {
		return nil, false
	}
	return o.MemoryPerCpu, true
}

// HasMemoryPerCpu returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMemoryPerCpu() bool {
	if o != nil && !IsNil(o.MemoryPerCpu) {
		return true
	}

	return false
}

// SetMemoryPerCpu gets a reference to the given int32 and assigns it to the MemoryPerCpu field.
func (o *V0038JobResponseProperties) SetMemoryPerCpu(v int32) {
	o.MemoryPerCpu = &v
}

// GetMinimumCpusPerNode returns the MinimumCpusPerNode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMinimumCpusPerNode() int32 {
	if o == nil || IsNil(o.MinimumCpusPerNode) {
		var ret int32
		return ret
	}
	return *o.MinimumCpusPerNode
}

// GetMinimumCpusPerNodeOk returns a tuple with the MinimumCpusPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMinimumCpusPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.MinimumCpusPerNode) {
		return nil, false
	}
	return o.MinimumCpusPerNode, true
}

// HasMinimumCpusPerNode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMinimumCpusPerNode() bool {
	if o != nil && !IsNil(o.MinimumCpusPerNode) {
		return true
	}

	return false
}

// SetMinimumCpusPerNode gets a reference to the given int32 and assigns it to the MinimumCpusPerNode field.
func (o *V0038JobResponseProperties) SetMinimumCpusPerNode(v int32) {
	o.MinimumCpusPerNode = &v
}

// GetMinimumTmpDiskPerNode returns the MinimumTmpDiskPerNode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetMinimumTmpDiskPerNode() int32 {
	if o == nil || IsNil(o.MinimumTmpDiskPerNode) {
		var ret int32
		return ret
	}
	return *o.MinimumTmpDiskPerNode
}

// GetMinimumTmpDiskPerNodeOk returns a tuple with the MinimumTmpDiskPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetMinimumTmpDiskPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.MinimumTmpDiskPerNode) {
		return nil, false
	}
	return o.MinimumTmpDiskPerNode, true
}

// HasMinimumTmpDiskPerNode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasMinimumTmpDiskPerNode() bool {
	if o != nil && !IsNil(o.MinimumTmpDiskPerNode) {
		return true
	}

	return false
}

// SetMinimumTmpDiskPerNode gets a reference to the given int32 and assigns it to the MinimumTmpDiskPerNode field.
func (o *V0038JobResponseProperties) SetMinimumTmpDiskPerNode(v int32) {
	o.MinimumTmpDiskPerNode = &v
}

// GetPreemptTime returns the PreemptTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetPreemptTime() int64 {
	if o == nil || IsNil(o.PreemptTime) {
		var ret int64
		return ret
	}
	return *o.PreemptTime
}

// GetPreemptTimeOk returns a tuple with the PreemptTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetPreemptTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.PreemptTime) {
		return nil, false
	}
	return o.PreemptTime, true
}

// HasPreemptTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasPreemptTime() bool {
	if o != nil && !IsNil(o.PreemptTime) {
		return true
	}

	return false
}

// SetPreemptTime gets a reference to the given int64 and assigns it to the PreemptTime field.
func (o *V0038JobResponseProperties) SetPreemptTime(v int64) {
	o.PreemptTime = &v
}

// GetPreSusTime returns the PreSusTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetPreSusTime() int64 {
	if o == nil || IsNil(o.PreSusTime) {
		var ret int64
		return ret
	}
	return *o.PreSusTime
}

// GetPreSusTimeOk returns a tuple with the PreSusTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetPreSusTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.PreSusTime) {
		return nil, false
	}
	return o.PreSusTime, true
}

// HasPreSusTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasPreSusTime() bool {
	if o != nil && !IsNil(o.PreSusTime) {
		return true
	}

	return false
}

// SetPreSusTime gets a reference to the given int64 and assigns it to the PreSusTime field.
func (o *V0038JobResponseProperties) SetPreSusTime(v int64) {
	o.PreSusTime = &v
}

// GetPriority returns the Priority field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetPriority() int64 {
	if o == nil || IsNil(o.Priority) {
		var ret int64
		return ret
	}
	return *o.Priority
}

// GetPriorityOk returns a tuple with the Priority field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetPriorityOk() (*int64, bool) {
	if o == nil || IsNil(o.Priority) {
		return nil, false
	}
	return o.Priority, true
}

// HasPriority returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasPriority() bool {
	if o != nil && !IsNil(o.Priority) {
		return true
	}

	return false
}

// SetPriority gets a reference to the given int64 and assigns it to the Priority field.
func (o *V0038JobResponseProperties) SetPriority(v int64) {
	o.Priority = &v
}

// GetProfile returns the Profile field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetProfile() []string {
	if o == nil || IsNil(o.Profile) {
		var ret []string
		return ret
	}
	return o.Profile
}

// GetProfileOk returns a tuple with the Profile field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetProfileOk() ([]string, bool) {
	if o == nil || IsNil(o.Profile) {
		return nil, false
	}
	return o.Profile, true
}

// HasProfile returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasProfile() bool {
	if o != nil && !IsNil(o.Profile) {
		return true
	}

	return false
}

// SetProfile gets a reference to the given []string and assigns it to the Profile field.
func (o *V0038JobResponseProperties) SetProfile(v []string) {
	o.Profile = v
}

// GetQos returns the Qos field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetQos() string {
	if o == nil || IsNil(o.Qos) {
		var ret string
		return ret
	}
	return *o.Qos
}

// GetQosOk returns a tuple with the Qos field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetQosOk() (*string, bool) {
	if o == nil || IsNil(o.Qos) {
		return nil, false
	}
	return o.Qos, true
}

// HasQos returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasQos() bool {
	if o != nil && !IsNil(o.Qos) {
		return true
	}

	return false
}

// SetQos gets a reference to the given string and assigns it to the Qos field.
func (o *V0038JobResponseProperties) SetQos(v string) {
	o.Qos = &v
}

// GetReboot returns the Reboot field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetReboot() bool {
	if o == nil || IsNil(o.Reboot) {
		var ret bool
		return ret
	}
	return *o.Reboot
}

// GetRebootOk returns a tuple with the Reboot field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetRebootOk() (*bool, bool) {
	if o == nil || IsNil(o.Reboot) {
		return nil, false
	}
	return o.Reboot, true
}

// HasReboot returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasReboot() bool {
	if o != nil && !IsNil(o.Reboot) {
		return true
	}

	return false
}

// SetReboot gets a reference to the given bool and assigns it to the Reboot field.
func (o *V0038JobResponseProperties) SetReboot(v bool) {
	o.Reboot = &v
}

// GetRequiredNodes returns the RequiredNodes field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetRequiredNodes() string {
	if o == nil || IsNil(o.RequiredNodes) {
		var ret string
		return ret
	}
	return *o.RequiredNodes
}

// GetRequiredNodesOk returns a tuple with the RequiredNodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetRequiredNodesOk() (*string, bool) {
	if o == nil || IsNil(o.RequiredNodes) {
		return nil, false
	}
	return o.RequiredNodes, true
}

// HasRequiredNodes returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasRequiredNodes() bool {
	if o != nil && !IsNil(o.RequiredNodes) {
		return true
	}

	return false
}

// SetRequiredNodes gets a reference to the given string and assigns it to the RequiredNodes field.
func (o *V0038JobResponseProperties) SetRequiredNodes(v string) {
	o.RequiredNodes = &v
}

// GetRequeue returns the Requeue field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetRequeue() bool {
	if o == nil || IsNil(o.Requeue) {
		var ret bool
		return ret
	}
	return *o.Requeue
}

// GetRequeueOk returns a tuple with the Requeue field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetRequeueOk() (*bool, bool) {
	if o == nil || IsNil(o.Requeue) {
		return nil, false
	}
	return o.Requeue, true
}

// HasRequeue returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasRequeue() bool {
	if o != nil && !IsNil(o.Requeue) {
		return true
	}

	return false
}

// SetRequeue gets a reference to the given bool and assigns it to the Requeue field.
func (o *V0038JobResponseProperties) SetRequeue(v bool) {
	o.Requeue = &v
}

// GetResizeTime returns the ResizeTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetResizeTime() int64 {
	if o == nil || IsNil(o.ResizeTime) {
		var ret int64
		return ret
	}
	return *o.ResizeTime
}

// GetResizeTimeOk returns a tuple with the ResizeTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetResizeTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.ResizeTime) {
		return nil, false
	}
	return o.ResizeTime, true
}

// HasResizeTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasResizeTime() bool {
	if o != nil && !IsNil(o.ResizeTime) {
		return true
	}

	return false
}

// SetResizeTime gets a reference to the given int64 and assigns it to the ResizeTime field.
func (o *V0038JobResponseProperties) SetResizeTime(v int64) {
	o.ResizeTime = &v
}

// GetRestartCnt returns the RestartCnt field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetRestartCnt() int32 {
	if o == nil || IsNil(o.RestartCnt) {
		var ret int32
		return ret
	}
	return *o.RestartCnt
}

// GetRestartCntOk returns a tuple with the RestartCnt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetRestartCntOk() (*int32, bool) {
	if o == nil || IsNil(o.RestartCnt) {
		return nil, false
	}
	return o.RestartCnt, true
}

// HasRestartCnt returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasRestartCnt() bool {
	if o != nil && !IsNil(o.RestartCnt) {
		return true
	}

	return false
}

// SetRestartCnt gets a reference to the given int32 and assigns it to the RestartCnt field.
func (o *V0038JobResponseProperties) SetRestartCnt(v int32) {
	o.RestartCnt = &v
}

// GetResvName returns the ResvName field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetResvName() string {
	if o == nil || IsNil(o.ResvName) {
		var ret string
		return ret
	}
	return *o.ResvName
}

// GetResvNameOk returns a tuple with the ResvName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetResvNameOk() (*string, bool) {
	if o == nil || IsNil(o.ResvName) {
		return nil, false
	}
	return o.ResvName, true
}

// HasResvName returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasResvName() bool {
	if o != nil && !IsNil(o.ResvName) {
		return true
	}

	return false
}

// SetResvName gets a reference to the given string and assigns it to the ResvName field.
func (o *V0038JobResponseProperties) SetResvName(v string) {
	o.ResvName = &v
}

// GetShared returns the Shared field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetShared() string {
	if o == nil || IsNil(o.Shared) {
		var ret string
		return ret
	}
	return *o.Shared
}

// GetSharedOk returns a tuple with the Shared field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetSharedOk() (*string, bool) {
	if o == nil || IsNil(o.Shared) {
		return nil, false
	}
	return o.Shared, true
}

// HasShared returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasShared() bool {
	if o != nil && !IsNil(o.Shared) {
		return true
	}

	return false
}

// SetShared gets a reference to the given string and assigns it to the Shared field.
func (o *V0038JobResponseProperties) SetShared(v string) {
	o.Shared = &v
}

// GetShowFlags returns the ShowFlags field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetShowFlags() []string {
	if o == nil || IsNil(o.ShowFlags) {
		var ret []string
		return ret
	}
	return o.ShowFlags
}

// GetShowFlagsOk returns a tuple with the ShowFlags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetShowFlagsOk() ([]string, bool) {
	if o == nil || IsNil(o.ShowFlags) {
		return nil, false
	}
	return o.ShowFlags, true
}

// HasShowFlags returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasShowFlags() bool {
	if o != nil && !IsNil(o.ShowFlags) {
		return true
	}

	return false
}

// SetShowFlags gets a reference to the given []string and assigns it to the ShowFlags field.
func (o *V0038JobResponseProperties) SetShowFlags(v []string) {
	o.ShowFlags = v
}

// GetSocketsPerBoard returns the SocketsPerBoard field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetSocketsPerBoard() int32 {
	if o == nil || IsNil(o.SocketsPerBoard) {
		var ret int32
		return ret
	}
	return *o.SocketsPerBoard
}

// GetSocketsPerBoardOk returns a tuple with the SocketsPerBoard field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetSocketsPerBoardOk() (*int32, bool) {
	if o == nil || IsNil(o.SocketsPerBoard) {
		return nil, false
	}
	return o.SocketsPerBoard, true
}

// HasSocketsPerBoard returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasSocketsPerBoard() bool {
	if o != nil && !IsNil(o.SocketsPerBoard) {
		return true
	}

	return false
}

// SetSocketsPerBoard gets a reference to the given int32 and assigns it to the SocketsPerBoard field.
func (o *V0038JobResponseProperties) SetSocketsPerBoard(v int32) {
	o.SocketsPerBoard = &v
}

// GetSocketsPerNode returns the SocketsPerNode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetSocketsPerNode() int32 {
	if o == nil || IsNil(o.SocketsPerNode) {
		var ret int32
		return ret
	}
	return *o.SocketsPerNode
}

// GetSocketsPerNodeOk returns a tuple with the SocketsPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetSocketsPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.SocketsPerNode) {
		return nil, false
	}
	return o.SocketsPerNode, true
}

// HasSocketsPerNode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasSocketsPerNode() bool {
	if o != nil && !IsNil(o.SocketsPerNode) {
		return true
	}

	return false
}

// SetSocketsPerNode gets a reference to the given int32 and assigns it to the SocketsPerNode field.
func (o *V0038JobResponseProperties) SetSocketsPerNode(v int32) {
	o.SocketsPerNode = &v
}

// GetStartTime returns the StartTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetStartTime() int64 {
	if o == nil || IsNil(o.StartTime) {
		var ret int64
		return ret
	}
	return *o.StartTime
}

// GetStartTimeOk returns a tuple with the StartTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetStartTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.StartTime) {
		return nil, false
	}
	return o.StartTime, true
}

// HasStartTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasStartTime() bool {
	if o != nil && !IsNil(o.StartTime) {
		return true
	}

	return false
}

// SetStartTime gets a reference to the given int64 and assigns it to the StartTime field.
func (o *V0038JobResponseProperties) SetStartTime(v int64) {
	o.StartTime = &v
}

// GetStateDescription returns the StateDescription field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetStateDescription() string {
	if o == nil || IsNil(o.StateDescription) {
		var ret string
		return ret
	}
	return *o.StateDescription
}

// GetStateDescriptionOk returns a tuple with the StateDescription field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetStateDescriptionOk() (*string, bool) {
	if o == nil || IsNil(o.StateDescription) {
		return nil, false
	}
	return o.StateDescription, true
}

// HasStateDescription returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasStateDescription() bool {
	if o != nil && !IsNil(o.StateDescription) {
		return true
	}

	return false
}

// SetStateDescription gets a reference to the given string and assigns it to the StateDescription field.
func (o *V0038JobResponseProperties) SetStateDescription(v string) {
	o.StateDescription = &v
}

// GetStateReason returns the StateReason field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetStateReason() string {
	if o == nil || IsNil(o.StateReason) {
		var ret string
		return ret
	}
	return *o.StateReason
}

// GetStateReasonOk returns a tuple with the StateReason field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetStateReasonOk() (*string, bool) {
	if o == nil || IsNil(o.StateReason) {
		return nil, false
	}
	return o.StateReason, true
}

// HasStateReason returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasStateReason() bool {
	if o != nil && !IsNil(o.StateReason) {
		return true
	}

	return false
}

// SetStateReason gets a reference to the given string and assigns it to the StateReason field.
func (o *V0038JobResponseProperties) SetStateReason(v string) {
	o.StateReason = &v
}

// GetStandardError returns the StandardError field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetStandardError() string {
	if o == nil || IsNil(o.StandardError) {
		var ret string
		return ret
	}
	return *o.StandardError
}

// GetStandardErrorOk returns a tuple with the StandardError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetStandardErrorOk() (*string, bool) {
	if o == nil || IsNil(o.StandardError) {
		return nil, false
	}
	return o.StandardError, true
}

// HasStandardError returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasStandardError() bool {
	if o != nil && !IsNil(o.StandardError) {
		return true
	}

	return false
}

// SetStandardError gets a reference to the given string and assigns it to the StandardError field.
func (o *V0038JobResponseProperties) SetStandardError(v string) {
	o.StandardError = &v
}

// GetStandardInput returns the StandardInput field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetStandardInput() string {
	if o == nil || IsNil(o.StandardInput) {
		var ret string
		return ret
	}
	return *o.StandardInput
}

// GetStandardInputOk returns a tuple with the StandardInput field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetStandardInputOk() (*string, bool) {
	if o == nil || IsNil(o.StandardInput) {
		return nil, false
	}
	return o.StandardInput, true
}

// HasStandardInput returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasStandardInput() bool {
	if o != nil && !IsNil(o.StandardInput) {
		return true
	}

	return false
}

// SetStandardInput gets a reference to the given string and assigns it to the StandardInput field.
func (o *V0038JobResponseProperties) SetStandardInput(v string) {
	o.StandardInput = &v
}

// GetStandardOutput returns the StandardOutput field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetStandardOutput() string {
	if o == nil || IsNil(o.StandardOutput) {
		var ret string
		return ret
	}
	return *o.StandardOutput
}

// GetStandardOutputOk returns a tuple with the StandardOutput field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetStandardOutputOk() (*string, bool) {
	if o == nil || IsNil(o.StandardOutput) {
		return nil, false
	}
	return o.StandardOutput, true
}

// HasStandardOutput returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasStandardOutput() bool {
	if o != nil && !IsNil(o.StandardOutput) {
		return true
	}

	return false
}

// SetStandardOutput gets a reference to the given string and assigns it to the StandardOutput field.
func (o *V0038JobResponseProperties) SetStandardOutput(v string) {
	o.StandardOutput = &v
}

// GetSubmitTime returns the SubmitTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetSubmitTime() int64 {
	if o == nil || IsNil(o.SubmitTime) {
		var ret int64
		return ret
	}
	return *o.SubmitTime
}

// GetSubmitTimeOk returns a tuple with the SubmitTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetSubmitTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.SubmitTime) {
		return nil, false
	}
	return o.SubmitTime, true
}

// HasSubmitTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasSubmitTime() bool {
	if o != nil && !IsNil(o.SubmitTime) {
		return true
	}

	return false
}

// SetSubmitTime gets a reference to the given int64 and assigns it to the SubmitTime field.
func (o *V0038JobResponseProperties) SetSubmitTime(v int64) {
	o.SubmitTime = &v
}

// GetSuspendTime returns the SuspendTime field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetSuspendTime() int64 {
	if o == nil || IsNil(o.SuspendTime) {
		var ret int64
		return ret
	}
	return *o.SuspendTime
}

// GetSuspendTimeOk returns a tuple with the SuspendTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetSuspendTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.SuspendTime) {
		return nil, false
	}
	return o.SuspendTime, true
}

// HasSuspendTime returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasSuspendTime() bool {
	if o != nil && !IsNil(o.SuspendTime) {
		return true
	}

	return false
}

// SetSuspendTime gets a reference to the given int64 and assigns it to the SuspendTime field.
func (o *V0038JobResponseProperties) SetSuspendTime(v int64) {
	o.SuspendTime = &v
}

// GetSystemComment returns the SystemComment field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetSystemComment() string {
	if o == nil || IsNil(o.SystemComment) {
		var ret string
		return ret
	}
	return *o.SystemComment
}

// GetSystemCommentOk returns a tuple with the SystemComment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetSystemCommentOk() (*string, bool) {
	if o == nil || IsNil(o.SystemComment) {
		return nil, false
	}
	return o.SystemComment, true
}

// HasSystemComment returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasSystemComment() bool {
	if o != nil && !IsNil(o.SystemComment) {
		return true
	}

	return false
}

// SetSystemComment gets a reference to the given string and assigns it to the SystemComment field.
func (o *V0038JobResponseProperties) SetSystemComment(v string) {
	o.SystemComment = &v
}

// GetTimeLimit returns the TimeLimit field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTimeLimit() int64 {
	if o == nil || IsNil(o.TimeLimit) {
		var ret int64
		return ret
	}
	return *o.TimeLimit
}

// GetTimeLimitOk returns a tuple with the TimeLimit field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTimeLimitOk() (*int64, bool) {
	if o == nil || IsNil(o.TimeLimit) {
		return nil, false
	}
	return o.TimeLimit, true
}

// HasTimeLimit returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTimeLimit() bool {
	if o != nil && !IsNil(o.TimeLimit) {
		return true
	}

	return false
}

// SetTimeLimit gets a reference to the given int64 and assigns it to the TimeLimit field.
func (o *V0038JobResponseProperties) SetTimeLimit(v int64) {
	o.TimeLimit = &v
}

// GetTimeMinimum returns the TimeMinimum field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTimeMinimum() int64 {
	if o == nil || IsNil(o.TimeMinimum) {
		var ret int64
		return ret
	}
	return *o.TimeMinimum
}

// GetTimeMinimumOk returns a tuple with the TimeMinimum field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTimeMinimumOk() (*int64, bool) {
	if o == nil || IsNil(o.TimeMinimum) {
		return nil, false
	}
	return o.TimeMinimum, true
}

// HasTimeMinimum returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTimeMinimum() bool {
	if o != nil && !IsNil(o.TimeMinimum) {
		return true
	}

	return false
}

// SetTimeMinimum gets a reference to the given int64 and assigns it to the TimeMinimum field.
func (o *V0038JobResponseProperties) SetTimeMinimum(v int64) {
	o.TimeMinimum = &v
}

// GetThreadsPerCore returns the ThreadsPerCore field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetThreadsPerCore() int32 {
	if o == nil || IsNil(o.ThreadsPerCore) {
		var ret int32
		return ret
	}
	return *o.ThreadsPerCore
}

// GetThreadsPerCoreOk returns a tuple with the ThreadsPerCore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetThreadsPerCoreOk() (*int32, bool) {
	if o == nil || IsNil(o.ThreadsPerCore) {
		return nil, false
	}
	return o.ThreadsPerCore, true
}

// HasThreadsPerCore returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasThreadsPerCore() bool {
	if o != nil && !IsNil(o.ThreadsPerCore) {
		return true
	}

	return false
}

// SetThreadsPerCore gets a reference to the given int32 and assigns it to the ThreadsPerCore field.
func (o *V0038JobResponseProperties) SetThreadsPerCore(v int32) {
	o.ThreadsPerCore = &v
}

// GetTresBind returns the TresBind field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresBind() string {
	if o == nil || IsNil(o.TresBind) {
		var ret string
		return ret
	}
	return *o.TresBind
}

// GetTresBindOk returns a tuple with the TresBind field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresBindOk() (*string, bool) {
	if o == nil || IsNil(o.TresBind) {
		return nil, false
	}
	return o.TresBind, true
}

// HasTresBind returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresBind() bool {
	if o != nil && !IsNil(o.TresBind) {
		return true
	}

	return false
}

// SetTresBind gets a reference to the given string and assigns it to the TresBind field.
func (o *V0038JobResponseProperties) SetTresBind(v string) {
	o.TresBind = &v
}

// GetTresFreq returns the TresFreq field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresFreq() string {
	if o == nil || IsNil(o.TresFreq) {
		var ret string
		return ret
	}
	return *o.TresFreq
}

// GetTresFreqOk returns a tuple with the TresFreq field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresFreqOk() (*string, bool) {
	if o == nil || IsNil(o.TresFreq) {
		return nil, false
	}
	return o.TresFreq, true
}

// HasTresFreq returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresFreq() bool {
	if o != nil && !IsNil(o.TresFreq) {
		return true
	}

	return false
}

// SetTresFreq gets a reference to the given string and assigns it to the TresFreq field.
func (o *V0038JobResponseProperties) SetTresFreq(v string) {
	o.TresFreq = &v
}

// GetTresPerJob returns the TresPerJob field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresPerJob() string {
	if o == nil || IsNil(o.TresPerJob) {
		var ret string
		return ret
	}
	return *o.TresPerJob
}

// GetTresPerJobOk returns a tuple with the TresPerJob field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresPerJobOk() (*string, bool) {
	if o == nil || IsNil(o.TresPerJob) {
		return nil, false
	}
	return o.TresPerJob, true
}

// HasTresPerJob returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresPerJob() bool {
	if o != nil && !IsNil(o.TresPerJob) {
		return true
	}

	return false
}

// SetTresPerJob gets a reference to the given string and assigns it to the TresPerJob field.
func (o *V0038JobResponseProperties) SetTresPerJob(v string) {
	o.TresPerJob = &v
}

// GetTresPerNode returns the TresPerNode field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresPerNode() string {
	if o == nil || IsNil(o.TresPerNode) {
		var ret string
		return ret
	}
	return *o.TresPerNode
}

// GetTresPerNodeOk returns a tuple with the TresPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresPerNodeOk() (*string, bool) {
	if o == nil || IsNil(o.TresPerNode) {
		return nil, false
	}
	return o.TresPerNode, true
}

// HasTresPerNode returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresPerNode() bool {
	if o != nil && !IsNil(o.TresPerNode) {
		return true
	}

	return false
}

// SetTresPerNode gets a reference to the given string and assigns it to the TresPerNode field.
func (o *V0038JobResponseProperties) SetTresPerNode(v string) {
	o.TresPerNode = &v
}

// GetTresPerSocket returns the TresPerSocket field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresPerSocket() string {
	if o == nil || IsNil(o.TresPerSocket) {
		var ret string
		return ret
	}
	return *o.TresPerSocket
}

// GetTresPerSocketOk returns a tuple with the TresPerSocket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresPerSocketOk() (*string, bool) {
	if o == nil || IsNil(o.TresPerSocket) {
		return nil, false
	}
	return o.TresPerSocket, true
}

// HasTresPerSocket returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresPerSocket() bool {
	if o != nil && !IsNil(o.TresPerSocket) {
		return true
	}

	return false
}

// SetTresPerSocket gets a reference to the given string and assigns it to the TresPerSocket field.
func (o *V0038JobResponseProperties) SetTresPerSocket(v string) {
	o.TresPerSocket = &v
}

// GetTresPerTask returns the TresPerTask field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresPerTask() string {
	if o == nil || IsNil(o.TresPerTask) {
		var ret string
		return ret
	}
	return *o.TresPerTask
}

// GetTresPerTaskOk returns a tuple with the TresPerTask field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresPerTaskOk() (*string, bool) {
	if o == nil || IsNil(o.TresPerTask) {
		return nil, false
	}
	return o.TresPerTask, true
}

// HasTresPerTask returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresPerTask() bool {
	if o != nil && !IsNil(o.TresPerTask) {
		return true
	}

	return false
}

// SetTresPerTask gets a reference to the given string and assigns it to the TresPerTask field.
func (o *V0038JobResponseProperties) SetTresPerTask(v string) {
	o.TresPerTask = &v
}

// GetTresReqStr returns the TresReqStr field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresReqStr() string {
	if o == nil || IsNil(o.TresReqStr) {
		var ret string
		return ret
	}
	return *o.TresReqStr
}

// GetTresReqStrOk returns a tuple with the TresReqStr field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresReqStrOk() (*string, bool) {
	if o == nil || IsNil(o.TresReqStr) {
		return nil, false
	}
	return o.TresReqStr, true
}

// HasTresReqStr returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresReqStr() bool {
	if o != nil && !IsNil(o.TresReqStr) {
		return true
	}

	return false
}

// SetTresReqStr gets a reference to the given string and assigns it to the TresReqStr field.
func (o *V0038JobResponseProperties) SetTresReqStr(v string) {
	o.TresReqStr = &v
}

// GetTresAllocStr returns the TresAllocStr field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetTresAllocStr() string {
	if o == nil || IsNil(o.TresAllocStr) {
		var ret string
		return ret
	}
	return *o.TresAllocStr
}

// GetTresAllocStrOk returns a tuple with the TresAllocStr field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetTresAllocStrOk() (*string, bool) {
	if o == nil || IsNil(o.TresAllocStr) {
		return nil, false
	}
	return o.TresAllocStr, true
}

// HasTresAllocStr returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasTresAllocStr() bool {
	if o != nil && !IsNil(o.TresAllocStr) {
		return true
	}

	return false
}

// SetTresAllocStr gets a reference to the given string and assigns it to the TresAllocStr field.
func (o *V0038JobResponseProperties) SetTresAllocStr(v string) {
	o.TresAllocStr = &v
}

// GetUserId returns the UserId field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetUserId() int64 {
	if o == nil || IsNil(o.UserId) {
		var ret int64
		return ret
	}
	return *o.UserId
}

// GetUserIdOk returns a tuple with the UserId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetUserIdOk() (*int64, bool) {
	if o == nil || IsNil(o.UserId) {
		return nil, false
	}
	return o.UserId, true
}

// HasUserId returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasUserId() bool {
	if o != nil && !IsNil(o.UserId) {
		return true
	}

	return false
}

// SetUserId gets a reference to the given int64 and assigns it to the UserId field.
func (o *V0038JobResponseProperties) SetUserId(v int64) {
	o.UserId = &v
}

// GetUserName returns the UserName field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetUserName() string {
	if o == nil || IsNil(o.UserName) {
		var ret string
		return ret
	}
	return *o.UserName
}

// GetUserNameOk returns a tuple with the UserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetUserNameOk() (*string, bool) {
	if o == nil || IsNil(o.UserName) {
		return nil, false
	}
	return o.UserName, true
}

// HasUserName returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasUserName() bool {
	if o != nil && !IsNil(o.UserName) {
		return true
	}

	return false
}

// SetUserName gets a reference to the given string and assigns it to the UserName field.
func (o *V0038JobResponseProperties) SetUserName(v string) {
	o.UserName = &v
}

// GetWckey returns the Wckey field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetWckey() string {
	if o == nil || IsNil(o.Wckey) {
		var ret string
		return ret
	}
	return *o.Wckey
}

// GetWckeyOk returns a tuple with the Wckey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetWckeyOk() (*string, bool) {
	if o == nil || IsNil(o.Wckey) {
		return nil, false
	}
	return o.Wckey, true
}

// HasWckey returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasWckey() bool {
	if o != nil && !IsNil(o.Wckey) {
		return true
	}

	return false
}

// SetWckey gets a reference to the given string and assigns it to the Wckey field.
func (o *V0038JobResponseProperties) SetWckey(v string) {
	o.Wckey = &v
}

// GetCurrentWorkingDirectory returns the CurrentWorkingDirectory field value if set, zero value otherwise.
func (o *V0038JobResponseProperties) GetCurrentWorkingDirectory() string {
	if o == nil || IsNil(o.CurrentWorkingDirectory) {
		var ret string
		return ret
	}
	return *o.CurrentWorkingDirectory
}

// GetCurrentWorkingDirectoryOk returns a tuple with the CurrentWorkingDirectory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobResponseProperties) GetCurrentWorkingDirectoryOk() (*string, bool) {
	if o == nil || IsNil(o.CurrentWorkingDirectory) {
		return nil, false
	}
	return o.CurrentWorkingDirectory, true
}

// HasCurrentWorkingDirectory returns a boolean if a field has been set.
func (o *V0038JobResponseProperties) HasCurrentWorkingDirectory() bool {
	if o != nil && !IsNil(o.CurrentWorkingDirectory) {
		return true
	}

	return false
}

// SetCurrentWorkingDirectory gets a reference to the given string and assigns it to the CurrentWorkingDirectory field.
func (o *V0038JobResponseProperties) SetCurrentWorkingDirectory(v string) {
	o.CurrentWorkingDirectory = &v
}

func (o V0038JobResponseProperties) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o V0038JobResponseProperties) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Account) {
		toSerialize["account"] = o.Account
	}
	if !IsNil(o.AccrueTime) {
		toSerialize["accrue_time"] = o.AccrueTime
	}
	if !IsNil(o.AdminComment) {
		toSerialize["admin_comment"] = o.AdminComment
	}
	if !IsNil(o.ArrayJobId) {
		toSerialize["array_job_id"] = o.ArrayJobId
	}
	if !IsNil(o.ArrayTaskId) {
		toSerialize["array_task_id"] = o.ArrayTaskId
	}
	if !IsNil(o.ArrayMaxTasks) {
		toSerialize["array_max_tasks"] = o.ArrayMaxTasks
	}
	if !IsNil(o.ArrayTaskString) {
		toSerialize["array_task_string"] = o.ArrayTaskString
	}
	if !IsNil(o.AssociationId) {
		toSerialize["association_id"] = o.AssociationId
	}
	if !IsNil(o.BatchFeatures) {
		toSerialize["batch_features"] = o.BatchFeatures
	}
	if !IsNil(o.BatchFlag) {
		toSerialize["batch_flag"] = o.BatchFlag
	}
	if !IsNil(o.BatchHost) {
		toSerialize["batch_host"] = o.BatchHost
	}
	if !IsNil(o.Flags) {
		toSerialize["flags"] = o.Flags
	}
	if !IsNil(o.BurstBuffer) {
		toSerialize["burst_buffer"] = o.BurstBuffer
	}
	if !IsNil(o.BurstBufferState) {
		toSerialize["burst_buffer_state"] = o.BurstBufferState
	}
	if !IsNil(o.Cluster) {
		toSerialize["cluster"] = o.Cluster
	}
	if !IsNil(o.ClusterFeatures) {
		toSerialize["cluster_features"] = o.ClusterFeatures
	}
	if !IsNil(o.Command) {
		toSerialize["command"] = o.Command
	}
	if !IsNil(o.Comment) {
		toSerialize["comment"] = o.Comment
	}
	if !IsNil(o.Container) {
		toSerialize["container"] = o.Container
	}
	if !IsNil(o.Contiguous) {
		toSerialize["contiguous"] = o.Contiguous
	}
	if !IsNil(o.CoreSpec) {
		toSerialize["core_spec"] = o.CoreSpec
	}
	if !IsNil(o.ThreadSpec) {
		toSerialize["thread_spec"] = o.ThreadSpec
	}
	if !IsNil(o.CoresPerSocket) {
		toSerialize["cores_per_socket"] = o.CoresPerSocket
	}
	if !IsNil(o.BillableTres) {
		toSerialize["billable_tres"] = o.BillableTres
	}
	if !IsNil(o.CpusPerTask) {
		toSerialize["cpus_per_task"] = o.CpusPerTask
	}
	if !IsNil(o.CpuFrequencyMinimum) {
		toSerialize["cpu_frequency_minimum"] = o.CpuFrequencyMinimum
	}
	if !IsNil(o.CpuFrequencyMaximum) {
		toSerialize["cpu_frequency_maximum"] = o.CpuFrequencyMaximum
	}
	if !IsNil(o.CpuFrequencyGovernor) {
		toSerialize["cpu_frequency_governor"] = o.CpuFrequencyGovernor
	}
	if !IsNil(o.CpusPerTres) {
		toSerialize["cpus_per_tres"] = o.CpusPerTres
	}
	if !IsNil(o.Deadline) {
		toSerialize["deadline"] = o.Deadline
	}
	if !IsNil(o.DelayBoot) {
		toSerialize["delay_boot"] = o.DelayBoot
	}
	if !IsNil(o.Dependency) {
		toSerialize["dependency"] = o.Dependency
	}
	if !IsNil(o.DerivedExitCode) {
		toSerialize["derived_exit_code"] = o.DerivedExitCode
	}
	if !IsNil(o.EligibleTime) {
		toSerialize["eligible_time"] = o.EligibleTime
	}
	if !IsNil(o.EndTime) {
		toSerialize["end_time"] = o.EndTime
	}
	if !IsNil(o.ExcludedNodes) {
		toSerialize["excluded_nodes"] = o.ExcludedNodes
	}
	if !IsNil(o.ExitCode) {
		toSerialize["exit_code"] = o.ExitCode
	}
	if !IsNil(o.Features) {
		toSerialize["features"] = o.Features
	}
	if !IsNil(o.FederationOrigin) {
		toSerialize["federation_origin"] = o.FederationOrigin
	}
	if !IsNil(o.FederationSiblingsActive) {
		toSerialize["federation_siblings_active"] = o.FederationSiblingsActive
	}
	if !IsNil(o.FederationSiblingsViable) {
		toSerialize["federation_siblings_viable"] = o.FederationSiblingsViable
	}
	if !IsNil(o.GresDetail) {
		toSerialize["gres_detail"] = o.GresDetail
	}
	if !IsNil(o.GroupId) {
		toSerialize["group_id"] = o.GroupId
	}
	if !IsNil(o.JobId) {
		toSerialize["job_id"] = o.JobId
	}
	if !IsNil(o.JobResources) {
		toSerialize["job_resources"] = o.JobResources
	}
	if !IsNil(o.JobState) {
		toSerialize["job_state"] = o.JobState
	}
	if !IsNil(o.LastSchedEvaluation) {
		toSerialize["last_sched_evaluation"] = o.LastSchedEvaluation
	}
	if !IsNil(o.Licenses) {
		toSerialize["licenses"] = o.Licenses
	}
	if !IsNil(o.MaxCpus) {
		toSerialize["max_cpus"] = o.MaxCpus
	}
	if !IsNil(o.MaxNodes) {
		toSerialize["max_nodes"] = o.MaxNodes
	}
	if !IsNil(o.McsLabel) {
		toSerialize["mcs_label"] = o.McsLabel
	}
	if !IsNil(o.MemoryPerTres) {
		toSerialize["memory_per_tres"] = o.MemoryPerTres
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Nodes) {
		toSerialize["nodes"] = o.Nodes
	}
	if !IsNil(o.Nice) {
		toSerialize["nice"] = o.Nice
	}
	if !IsNil(o.TasksPerCore) {
		toSerialize["tasks_per_core"] = o.TasksPerCore
	}
	if !IsNil(o.TasksPerSocket) {
		toSerialize["tasks_per_socket"] = o.TasksPerSocket
	}
	if !IsNil(o.TasksPerBoard) {
		toSerialize["tasks_per_board"] = o.TasksPerBoard
	}
	if !IsNil(o.Cpus) {
		toSerialize["cpus"] = o.Cpus
	}
	if !IsNil(o.NodeCount) {
		toSerialize["node_count"] = o.NodeCount
	}
	if !IsNil(o.Tasks) {
		toSerialize["tasks"] = o.Tasks
	}
	if !IsNil(o.HetJobId) {
		toSerialize["het_job_id"] = o.HetJobId
	}
	if !IsNil(o.HetJobIdSet) {
		toSerialize["het_job_id_set"] = o.HetJobIdSet
	}
	if !IsNil(o.HetJobOffset) {
		toSerialize["het_job_offset"] = o.HetJobOffset
	}
	if !IsNil(o.Partition) {
		toSerialize["partition"] = o.Partition
	}
	if !IsNil(o.MemoryPerNode) {
		toSerialize["memory_per_node"] = o.MemoryPerNode
	}
	if !IsNil(o.MemoryPerCpu) {
		toSerialize["memory_per_cpu"] = o.MemoryPerCpu
	}
	if !IsNil(o.MinimumCpusPerNode) {
		toSerialize["minimum_cpus_per_node"] = o.MinimumCpusPerNode
	}
	if !IsNil(o.MinimumTmpDiskPerNode) {
		toSerialize["minimum_tmp_disk_per_node"] = o.MinimumTmpDiskPerNode
	}
	if !IsNil(o.PreemptTime) {
		toSerialize["preempt_time"] = o.PreemptTime
	}
	if !IsNil(o.PreSusTime) {
		toSerialize["pre_sus_time"] = o.PreSusTime
	}
	if !IsNil(o.Priority) {
		toSerialize["priority"] = o.Priority
	}
	if !IsNil(o.Profile) {
		toSerialize["profile"] = o.Profile
	}
	if !IsNil(o.Qos) {
		toSerialize["qos"] = o.Qos
	}
	if !IsNil(o.Reboot) {
		toSerialize["reboot"] = o.Reboot
	}
	if !IsNil(o.RequiredNodes) {
		toSerialize["required_nodes"] = o.RequiredNodes
	}
	if !IsNil(o.Requeue) {
		toSerialize["requeue"] = o.Requeue
	}
	if !IsNil(o.ResizeTime) {
		toSerialize["resize_time"] = o.ResizeTime
	}
	if !IsNil(o.RestartCnt) {
		toSerialize["restart_cnt"] = o.RestartCnt
	}
	if !IsNil(o.ResvName) {
		toSerialize["resv_name"] = o.ResvName
	}
	if !IsNil(o.Shared) {
		toSerialize["shared"] = o.Shared
	}
	if !IsNil(o.ShowFlags) {
		toSerialize["show_flags"] = o.ShowFlags
	}
	if !IsNil(o.SocketsPerBoard) {
		toSerialize["sockets_per_board"] = o.SocketsPerBoard
	}
	if !IsNil(o.SocketsPerNode) {
		toSerialize["sockets_per_node"] = o.SocketsPerNode
	}
	if !IsNil(o.StartTime) {
		toSerialize["start_time"] = o.StartTime
	}
	if !IsNil(o.StateDescription) {
		toSerialize["state_description"] = o.StateDescription
	}
	if !IsNil(o.StateReason) {
		toSerialize["state_reason"] = o.StateReason
	}
	if !IsNil(o.StandardError) {
		toSerialize["standard_error"] = o.StandardError
	}
	if !IsNil(o.StandardInput) {
		toSerialize["standard_input"] = o.StandardInput
	}
	if !IsNil(o.StandardOutput) {
		toSerialize["standard_output"] = o.StandardOutput
	}
	if !IsNil(o.SubmitTime) {
		toSerialize["submit_time"] = o.SubmitTime
	}
	if !IsNil(o.SuspendTime) {
		toSerialize["suspend_time"] = o.SuspendTime
	}
	if !IsNil(o.SystemComment) {
		toSerialize["system_comment"] = o.SystemComment
	}
	if !IsNil(o.TimeLimit) {
		toSerialize["time_limit"] = o.TimeLimit
	}
	if !IsNil(o.TimeMinimum) {
		toSerialize["time_minimum"] = o.TimeMinimum
	}
	if !IsNil(o.ThreadsPerCore) {
		toSerialize["threads_per_core"] = o.ThreadsPerCore
	}
	if !IsNil(o.TresBind) {
		toSerialize["tres_bind"] = o.TresBind
	}
	if !IsNil(o.TresFreq) {
		toSerialize["tres_freq"] = o.TresFreq
	}
	if !IsNil(o.TresPerJob) {
		toSerialize["tres_per_job"] = o.TresPerJob
	}
	if !IsNil(o.TresPerNode) {
		toSerialize["tres_per_node"] = o.TresPerNode
	}
	if !IsNil(o.TresPerSocket) {
		toSerialize["tres_per_socket"] = o.TresPerSocket
	}
	if !IsNil(o.TresPerTask) {
		toSerialize["tres_per_task"] = o.TresPerTask
	}
	if !IsNil(o.TresReqStr) {
		toSerialize["tres_req_str"] = o.TresReqStr
	}
	if !IsNil(o.TresAllocStr) {
		toSerialize["tres_alloc_str"] = o.TresAllocStr
	}
	if !IsNil(o.UserId) {
		toSerialize["user_id"] = o.UserId
	}
	if !IsNil(o.UserName) {
		toSerialize["user_name"] = o.UserName
	}
	if !IsNil(o.Wckey) {
		toSerialize["wckey"] = o.Wckey
	}
	if !IsNil(o.CurrentWorkingDirectory) {
		toSerialize["current_working_directory"] = o.CurrentWorkingDirectory
	}
	return toSerialize, nil
}

type NullableV0038JobResponseProperties struct {
	value *V0038JobResponseProperties
	isSet bool
}

func (v NullableV0038JobResponseProperties) Get() *V0038JobResponseProperties {
	return v.value
}

func (v *NullableV0038JobResponseProperties) Set(val *V0038JobResponseProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableV0038JobResponseProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableV0038JobResponseProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableV0038JobResponseProperties(val *V0038JobResponseProperties) *NullableV0038JobResponseProperties {
	return &NullableV0038JobResponseProperties{value: val, isSet: true}
}

func (v NullableV0038JobResponseProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableV0038JobResponseProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


