/*
Slurm Rest API RO

Testing OpenapiAPIService

*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech);

package v0038

import (
	"context"
	"os"
	"testing"

	openapiclient "github.com/pcolladosoto/goslurm/v0038"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func Test_oapigen_OpenapiAPIService(t *testing.T) {

	configuration := openapiclient.NewConfiguration()
	configuration.Host = "arc.ft.uam.es:6820"
	configuration.Scheme = "http"

	envUser, ok := os.LookupEnv("SLURM_USER")
	if !ok {
		t.Fatalf("couldn't find user on the SLURM_USER environment variable... is it defined?")
	}

	envToken, ok := os.LookupEnv("SLURM_JWT")
	if !ok {
		t.Fatalf("couldn't find token on the SLURM_JWT environment variable... is it defined?")
	}

	auth := context.WithValue(
		context.Background(),
		openapiclient.ContextAPIKeys,
		map[string]openapiclient.APIKey{
			"user":  {Key: envUser},
			"token": {Key: envToken},
		},
	)

	apiClient := openapiclient.NewAPIClient(configuration)

	t.Run("Test OpenapiAPIService OpenapiGet", func(t *testing.T) {

		// t.Skip("skip test") // remove to run test

		httpRes, err := apiClient.OpenapiAPI.OpenapiGet(auth).Execute()

		require.Nil(t, err)
		assert.Equal(t, 200, httpRes.StatusCode)

	})

	t.Run("Test OpenapiAPIService OpenapiJsonGet", func(t *testing.T) {

		// t.Skip("skip test") // remove to run test

		httpRes, err := apiClient.OpenapiAPI.OpenapiJsonGet(auth).Execute()

		require.Nil(t, err)
		assert.Equal(t, 200, httpRes.StatusCode)

	})

	t.Run("Test OpenapiAPIService OpenapiV3Get", func(t *testing.T) {

		// t.Skip("skip test") // remove to run test

		httpRes, err := apiClient.OpenapiAPI.OpenapiV3Get(auth).Execute()

		require.Nil(t, err)
		assert.Equal(t, 200, httpRes.StatusCode)

	})

	t.Run("Test OpenapiAPIService OpenapiYamlGet", func(t *testing.T) {

		// t.Skip("skip test") // remove to run test

		httpRes, err := apiClient.OpenapiAPI.OpenapiYamlGet(auth).Execute()

		require.Nil(t, err)
		assert.Equal(t, 200, httpRes.StatusCode)

	})

}
