// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/maps/places/v1/content_block.proto

package placespb

import (
	reflect "reflect"
	sync "sync"

	localized_text "google.golang.org/genproto/googleapis/type/localized_text"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A block of content that can be served individually.
type ContentBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The topic of the content, for example "overview" or "restaurant".
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Content related to the topic.
	Content *localized_text.LocalizedText `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details.
	//
	// References that are related to this block of content.
	References *References `protobuf:"bytes,3,opt,name=references,proto3" json:"references,omitempty"`
}

func (x *ContentBlock) Reset() {
	*x = ContentBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_content_block_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentBlock) ProtoMessage() {}

func (x *ContentBlock) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_content_block_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentBlock.ProtoReflect.Descriptor instead.
func (*ContentBlock) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_content_block_proto_rawDescGZIP(), []int{0}
}

func (x *ContentBlock) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *ContentBlock) GetContent() *localized_text.LocalizedText {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *ContentBlock) GetReferences() *References {
	if x != nil {
		return x.References
	}
	return nil
}

var File_google_maps_places_v1_content_block_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_content_block_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9d, 0x01, 0x0a, 0x0c,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x12, 0x34, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x0a, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0xa5, 0x01, 0x0a, 0x19,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x06, 0x47, 0x4d, 0x50,
	0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70,
	0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_content_block_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_content_block_proto_rawDescData = file_google_maps_places_v1_content_block_proto_rawDesc
)

func file_google_maps_places_v1_content_block_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_content_block_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_content_block_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_content_block_proto_rawDescData)
	})
	return file_google_maps_places_v1_content_block_proto_rawDescData
}

var file_google_maps_places_v1_content_block_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_maps_places_v1_content_block_proto_goTypes = []interface{}{
	(*ContentBlock)(nil),                 // 0: google.maps.places.v1.ContentBlock
	(*localized_text.LocalizedText)(nil), // 1: google.type.LocalizedText
	(*References)(nil),                   // 2: google.maps.places.v1.References
}
var file_google_maps_places_v1_content_block_proto_depIdxs = []int32{
	1, // 0: google.maps.places.v1.ContentBlock.content:type_name -> google.type.LocalizedText
	2, // 1: google.maps.places.v1.ContentBlock.references:type_name -> google.maps.places.v1.References
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_content_block_proto_init() }
func file_google_maps_places_v1_content_block_proto_init() {
	if File_google_maps_places_v1_content_block_proto != nil {
		return
	}
	file_google_maps_places_v1_reference_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_places_v1_content_block_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_content_block_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_places_v1_content_block_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_content_block_proto_depIdxs,
		MessageInfos:      file_google_maps_places_v1_content_block_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_content_block_proto = out.File
	file_google_maps_places_v1_content_block_proto_rawDesc = nil
	file_google_maps_places_v1_content_block_proto_goTypes = nil
	file_google_maps_places_v1_content_block_proto_depIdxs = nil
}
