// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/healthcare/logging/dicom.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A log entry for a DICOM import long-running operation.
type ImportDicomLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source file, in the format `gs://{bucket-id}/{path/to/file}`.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ImportDicomLogEntry) Reset() {
	*x = ImportDicomLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDicomLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDicomLogEntry) ProtoMessage() {}

func (x *ImportDicomLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDicomLogEntry.ProtoReflect.Descriptor instead.
func (*ImportDicomLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_dicom_proto_rawDescGZIP(), []int{0}
}

func (x *ImportDicomLogEntry) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *ImportDicomLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a DICOM export long-running operation.
type ExportDicomLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DICOM resource being exported.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ExportDicomLogEntry) Reset() {
	*x = ExportDicomLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDicomLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDicomLogEntry) ProtoMessage() {}

func (x *ExportDicomLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDicomLogEntry.ProtoReflect.Descriptor instead.
func (*ExportDicomLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_dicom_proto_rawDescGZIP(), []int{1}
}

func (x *ExportDicomLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ExportDicomLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a DICOM store Pub/Sub notification.
type DicomNotificationLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DICOM resource being created.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The Pub/Sub topic that the notification is published on.
	PubsubTopic string `protobuf:"bytes,2,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DicomNotificationLogEntry) Reset() {
	*x = DicomNotificationLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DicomNotificationLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DicomNotificationLogEntry) ProtoMessage() {}

func (x *DicomNotificationLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DicomNotificationLogEntry.ProtoReflect.Descriptor instead.
func (*DicomNotificationLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_dicom_proto_rawDescGZIP(), []int{2}
}

func (x *DicomNotificationLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *DicomNotificationLogEntry) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *DicomNotificationLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a DICOM streaming export notification.
type DicomStreamLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DICOM resource being exported.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The destination in BigQuery, in the format
	// `bq://{projectId}.{bqDatasetId}.{bqTableId}`.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DicomStreamLogEntry) Reset() {
	*x = DicomStreamLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DicomStreamLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DicomStreamLogEntry) ProtoMessage() {}

func (x *DicomStreamLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_dicom_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DicomStreamLogEntry.ProtoReflect.Descriptor instead.
func (*DicomStreamLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_dicom_proto_rawDescGZIP(), []int{3}
}

func (x *DicomStreamLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *DicomStreamLogEntry) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DicomStreamLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

var File_google_cloud_healthcare_logging_dicom_proto protoreflect.FileDescriptor

var file_google_cloud_healthcare_logging_dicom_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2f, 0x64, 0x69, 0x63, 0x6f, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x57, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x69, 0x63, 0x6f, 0x6d, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0x64, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x69, 0x63, 0x6f, 0x6d, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x8d, 0x01, 0x0a, 0x19, 0x44, 0x69, 0x63, 0x6f, 0x6d,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x28, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x44, 0x69, 0x63, 0x6f, 0x6d,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42,
	0x6d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_healthcare_logging_dicom_proto_rawDescOnce sync.Once
	file_google_cloud_healthcare_logging_dicom_proto_rawDescData = file_google_cloud_healthcare_logging_dicom_proto_rawDesc
)

func file_google_cloud_healthcare_logging_dicom_proto_rawDescGZIP() []byte {
	file_google_cloud_healthcare_logging_dicom_proto_rawDescOnce.Do(func() {
		file_google_cloud_healthcare_logging_dicom_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_healthcare_logging_dicom_proto_rawDescData)
	})
	return file_google_cloud_healthcare_logging_dicom_proto_rawDescData
}

var file_google_cloud_healthcare_logging_dicom_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_healthcare_logging_dicom_proto_goTypes = []interface{}{
	(*ImportDicomLogEntry)(nil),       // 0: google.cloud.healthcare.logging.ImportDicomLogEntry
	(*ExportDicomLogEntry)(nil),       // 1: google.cloud.healthcare.logging.ExportDicomLogEntry
	(*DicomNotificationLogEntry)(nil), // 2: google.cloud.healthcare.logging.DicomNotificationLogEntry
	(*DicomStreamLogEntry)(nil),       // 3: google.cloud.healthcare.logging.DicomStreamLogEntry
	(*status.Status)(nil),             // 4: google.rpc.Status
}
var file_google_cloud_healthcare_logging_dicom_proto_depIdxs = []int32{
	4, // 0: google.cloud.healthcare.logging.ImportDicomLogEntry.error:type_name -> google.rpc.Status
	4, // 1: google.cloud.healthcare.logging.ExportDicomLogEntry.error:type_name -> google.rpc.Status
	4, // 2: google.cloud.healthcare.logging.DicomNotificationLogEntry.error:type_name -> google.rpc.Status
	4, // 3: google.cloud.healthcare.logging.DicomStreamLogEntry.error:type_name -> google.rpc.Status
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_healthcare_logging_dicom_proto_init() }
func file_google_cloud_healthcare_logging_dicom_proto_init() {
	if File_google_cloud_healthcare_logging_dicom_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_healthcare_logging_dicom_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDicomLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_dicom_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDicomLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_dicom_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DicomNotificationLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_dicom_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DicomStreamLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_healthcare_logging_dicom_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_healthcare_logging_dicom_proto_goTypes,
		DependencyIndexes: file_google_cloud_healthcare_logging_dicom_proto_depIdxs,
		MessageInfos:      file_google_cloud_healthcare_logging_dicom_proto_msgTypes,
	}.Build()
	File_google_cloud_healthcare_logging_dicom_proto = out.File
	file_google_cloud_healthcare_logging_dicom_proto_rawDesc = nil
	file_google_cloud_healthcare_logging_dicom_proto_goTypes = nil
	file_google_cloud_healthcare_logging_dicom_proto_depIdxs = nil
}
