// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package admin provides access to the Admin SDK API.
//
// For product documentation, see: https://developers.google.com/workspace/admin/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/admin/reports/v1"
//	...
//	ctx := context.Background()
//	adminService, err := admin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	adminService, err := admin.NewService(ctx, option.WithScopes(admin.AdminReportsUsageReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	adminService, err := admin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	adminService, err := admin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package admin // import "google.golang.org/api/admin/reports/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "admin:reports_v1"
const apiName = "admin"
const apiVersion = "reports_v1"
const basePath = "https://admin.googleapis.com/"
const basePathTemplate = "https://admin.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://admin.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View audit reports for your Google Workspace domain
	AdminReportsAuditReadonlyScope = "https://www.googleapis.com/auth/admin.reports.audit.readonly"

	// View usage reports for your Google Workspace domain
	AdminReportsUsageReadonlyScope = "https://www.googleapis.com/auth/admin.reports.usage.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/admin.reports.audit.readonly",
		"https://www.googleapis.com/auth/admin.reports.usage.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Activities = NewActivitiesService(s)
	s.Channels = NewChannelsService(s)
	s.CustomerUsageReports = NewCustomerUsageReportsService(s)
	s.EntityUsageReports = NewEntityUsageReportsService(s)
	s.UserUsageReport = NewUserUsageReportService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Activities *ActivitiesService

	Channels *ChannelsService

	CustomerUsageReports *CustomerUsageReportsService

	EntityUsageReports *EntityUsageReportsService

	UserUsageReport *UserUsageReportService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewActivitiesService(s *Service) *ActivitiesService {
	rs := &ActivitiesService{s: s}
	return rs
}

type ActivitiesService struct {
	s *Service
}

func NewChannelsService(s *Service) *ChannelsService {
	rs := &ChannelsService{s: s}
	return rs
}

type ChannelsService struct {
	s *Service
}

func NewCustomerUsageReportsService(s *Service) *CustomerUsageReportsService {
	rs := &CustomerUsageReportsService{s: s}
	return rs
}

type CustomerUsageReportsService struct {
	s *Service
}

func NewEntityUsageReportsService(s *Service) *EntityUsageReportsService {
	rs := &EntityUsageReportsService{s: s}
	return rs
}

type EntityUsageReportsService struct {
	s *Service
}

func NewUserUsageReportService(s *Service) *UserUsageReportService {
	rs := &UserUsageReportService{s: s}
	return rs
}

type UserUsageReportService struct {
	s *Service
}

// Activities: JSON template for a collection of activities.
type Activities struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Items: Each activity record in the response.
	Items []*Activity `json:"items,omitempty"`
	// Kind: The type of API resource. For an activity report, the value is
	// `reports#activities`.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Token for retrieving the follow-on next page of the report.
	// The `nextPageToken` value is used in the request's `pageToken` query string.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Activities) MarshalJSON() ([]byte, error) {
	type NoMethod Activities
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Activity: JSON template for the activity resource.
type Activity struct {
	// Actor: User doing the action.
	Actor *ActivityActor `json:"actor,omitempty"`
	// Etag: ETag of the entry.
	Etag string `json:"etag,omitempty"`
	// Events: Activity events in the report.
	Events []*ActivityEvents `json:"events,omitempty"`
	// Id: Unique identifier for each activity record.
	Id *ActivityId `json:"id,omitempty"`
	// IpAddress: IP address of the user doing the action. This is the Internet
	// Protocol (IP) address of the user when logging into Google Workspace, which
	// may or may not reflect the user's physical location. For example, the IP
	// address can be the user's proxy server's address or a virtual private
	// network (VPN) address. The API supports IPv4 and IPv6.
	IpAddress string `json:"ipAddress,omitempty"`
	// Kind: The type of API resource. For an activity report, the value is
	// `audit#activity`.
	Kind string `json:"kind,omitempty"`
	// NetworkInfo: Network information of the user doing the action.
	NetworkInfo *ActivityNetworkInfo `json:"networkInfo,omitempty"`
	// OwnerDomain: This is the domain that is affected by the report's event. For
	// example domain of Admin console or the Drive application's document owner.
	OwnerDomain string `json:"ownerDomain,omitempty"`
	// ResourceDetails: Details of the resource on which the action was performed.
	ResourceDetails []*ResourceDetails `json:"resourceDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Activity) MarshalJSON() ([]byte, error) {
	type NoMethod Activity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivityActor: User doing the action.
type ActivityActor struct {
	// ApplicationInfo: Details of the application that was the actor for the
	// activity.
	ApplicationInfo *ActivityActorApplicationInfo `json:"applicationInfo,omitempty"`
	// CallerType: The type of actor.
	CallerType string `json:"callerType,omitempty"`
	// Email: The primary email address of the actor. May be absent if there is no
	// email address associated with the actor.
	Email string `json:"email,omitempty"`
	// Key: Only present when `callerType` is `KEY`. Can be the `consumer_key` of
	// the requestor for OAuth 2LO API requests or an identifier for robot
	// accounts.
	Key string `json:"key,omitempty"`
	// ProfileId: The unique Google Workspace profile ID of the actor. This value
	// might be absent if the actor is not a Google Workspace user, or may be the
	// number 105250506097979753968 which acts as a placeholder ID.
	ProfileId string `json:"profileId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityActor) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityActor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivityActorApplicationInfo: Details of the application that was the actor
// for the activity.
type ActivityActorApplicationInfo struct {
	// ApplicationName: Name of the application used to perform the action.
	ApplicationName string `json:"applicationName,omitempty"`
	// Impersonation: Whether the application was impersonating a user.
	Impersonation bool `json:"impersonation,omitempty"`
	// OauthClientId: OAuth client id of the third party application used to
	// perform the action.
	OauthClientId string `json:"oauthClientId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityActorApplicationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityActorApplicationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ActivityEvents struct {
	// Name: Name of the event. This is the specific name of the activity reported
	// by the API. And each `eventName` is related to a specific Google Workspace
	// service or feature which the API organizes into types of events. For
	// `eventName` request parameters in general: - If no `eventName` is given, the
	// report returns all possible instances of an `eventName`. - When you request
	// an `eventName`, the API's response returns all activities which contain that
	// `eventName`. For more information about `eventName` properties, see the list
	// of event names for various applications above in `applicationName`.
	Name string `json:"name,omitempty"`
	// Parameters: Parameter value pairs for various applications. For more
	// information about `eventName` parameters, see the list of event names for
	// various applications above in `applicationName`.
	Parameters []*ActivityEventsParameters `json:"parameters,omitempty"`
	// ResourceIds: Resource ids associated with the event.
	ResourceIds []string `json:"resourceIds,omitempty"`
	// Type: Type of event. The Google Workspace service or feature that an
	// administrator changes is identified in the `type` property which identifies
	// an event using the `eventName` property. For a full list of the API's `type`
	// categories, see the list of event names for various applications above in
	// `applicationName`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityEvents) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityEvents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ActivityEventsParameters struct {
	// BoolValue: Boolean value of the parameter.
	BoolValue bool `json:"boolValue,omitempty"`
	// IntValue: Integer value of the parameter.
	IntValue int64 `json:"intValue,omitempty,string"`
	// MessageValue: Nested parameter value pairs associated with this parameter.
	// Complex value type for a parameter are returned as a list of parameter
	// values. For example, the address parameter may have a value as `[{parameter:
	// [{name: city, value: abc}]}]`
	MessageValue *ActivityEventsParametersMessageValue `json:"messageValue,omitempty"`
	// MultiIntValue: Integer values of the parameter.
	MultiIntValue googleapi.Int64s `json:"multiIntValue,omitempty"`
	// MultiMessageValue: List of `messageValue` objects.
	MultiMessageValue []*ActivityEventsParametersMultiMessageValue `json:"multiMessageValue,omitempty"`
	// MultiValue: String values of the parameter.
	MultiValue []string `json:"multiValue,omitempty"`
	// Name: The name of the parameter.
	Name string `json:"name,omitempty"`
	// Value: String value of the parameter.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityEventsParameters) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityEventsParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivityEventsParametersMessageValue: Nested parameter value pairs
// associated with this parameter. Complex value type for a parameter are
// returned as a list of parameter values. For example, the address parameter
// may have a value as `[{parameter: [{name: city, value: abc}]}]`
type ActivityEventsParametersMessageValue struct {
	// Parameter: Parameter values
	Parameter []*NestedParameter `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityEventsParametersMessageValue) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityEventsParametersMessageValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ActivityEventsParametersMultiMessageValue struct {
	// Parameter: Parameter values
	Parameter []*NestedParameter `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityEventsParametersMultiMessageValue) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityEventsParametersMultiMessageValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivityId: Unique identifier for each activity record.
type ActivityId struct {
	// ApplicationName: Application name to which the event belongs. For possible
	// values see the list of applications above in `applicationName`.
	ApplicationName string `json:"applicationName,omitempty"`
	// CustomerId: The unique identifier for a Google Workspace account.
	CustomerId string `json:"customerId,omitempty"`
	// Time: Time of occurrence of the activity. This is in UNIX epoch time in
	// seconds.
	Time string `json:"time,omitempty"`
	// UniqueQualifier: Unique qualifier if multiple events have the same time.
	UniqueQualifier int64 `json:"uniqueQualifier,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ApplicationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityId) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ActivityNetworkInfo: Network information of the user doing the action.
type ActivityNetworkInfo struct {
	// IpAsn: IP Address of the user doing the action.
	IpAsn []int64 `json:"ipAsn,omitempty"`
	// RegionCode: ISO 3166-1 alpha-2 region code of the user doing the action.
	RegionCode string `json:"regionCode,omitempty"`
	// SubdivisionCode: ISO 3166-2 region code (states and provinces) for countries
	// of the user doing the action.
	SubdivisionCode string `json:"subdivisionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpAsn") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpAsn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ActivityNetworkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ActivityNetworkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppliedLabel: Details of the label applied on the resource.
type AppliedLabel struct {
	// FieldValues: List of fields which are part of the label and have been set by
	// the user. If label has a field which was not set by the user, it would not
	// be present in this list.
	FieldValues []*FieldValue `json:"fieldValues,omitempty"`
	// Id: Identifier of the label - Only the label id, not the full OnePlatform
	// resource name.
	Id string `json:"id,omitempty"`
	// Reason: The reason why the label was applied on the resource.
	Reason *Reason `json:"reason,omitempty"`
	// Title: Title of the label
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppliedLabel) MarshalJSON() ([]byte, error) {
	type NoMethod AppliedLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Channel: A notification channel used to watch for resource changes.
type Channel struct {
	// Address: The address where notifications are delivered for this channel.
	Address string `json:"address,omitempty"`
	// Expiration: Date and time of notification channel expiration, expressed as a
	// Unix timestamp, in milliseconds. Optional.
	Expiration int64 `json:"expiration,omitempty,string"`
	// Id: A UUID or similar unique string that identifies this channel.
	Id string `json:"id,omitempty"`
	// Kind: Identifies this as a notification channel used to watch for changes to
	// a resource, which is "api#channel".
	Kind string `json:"kind,omitempty"`
	// Params: Additional parameters controlling delivery channel behavior.
	// Optional.
	Params map[string]string `json:"params,omitempty"`
	// Payload: A Boolean value to indicate whether payload is wanted. A payload is
	// data that is sent in the body of an HTTP POST, PUT, or PATCH message and
	// contains important information about the request. Optional.
	Payload bool `json:"payload,omitempty"`
	// ResourceId: An opaque ID that identifies the resource being watched on this
	// channel. Stable across different API versions.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceUri: A version-specific identifier for the watched resource.
	ResourceUri string `json:"resourceUri,omitempty"`
	// Token: An arbitrary string delivered to the target address with each
	// notification delivered over this channel. Optional.
	Token string `json:"token,omitempty"`
	// Type: The type of delivery mechanism used for this channel. The value should
	// be set to "web_hook".
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Channel) MarshalJSON() ([]byte, error) {
	type NoMethod Channel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldValue: Details of the field value set by the user for the particular
// label.
type FieldValue struct {
	// DateValue: Setting a date value.
	DateValue *Date `json:"dateValue,omitempty"`
	// DisplayName: Display name of the field
	DisplayName string `json:"displayName,omitempty"`
	// Id: Identifier of the field
	Id string `json:"id,omitempty"`
	// IntegerValue: Setting an integer value.
	IntegerValue int64 `json:"integerValue,omitempty,string"`
	// LongTextValue: Setting a long text value.
	LongTextValue string `json:"longTextValue,omitempty"`
	// Reason: The reason why the field was applied to the label.
	Reason *Reason `json:"reason,omitempty"`
	// SelectionListValue: Setting a selection list value by selecting multiple
	// values from a dropdown.
	SelectionListValue *FieldValueSelectionListValue `json:"selectionListValue,omitempty"`
	// SelectionValue: Setting a selection value by selecting a single value from a
	// dropdown.
	SelectionValue *FieldValueSelectionValue `json:"selectionValue,omitempty"`
	// TextListValue: Setting a text list value.
	TextListValue *FieldValueTextListValue `json:"textListValue,omitempty"`
	// TextValue: Setting a text value.
	TextValue string `json:"textValue,omitempty"`
	// Type: Type of the field
	Type string `json:"type,omitempty"`
	// UnsetValue: If the field is unset, this will be true.
	UnsetValue bool `json:"unsetValue,omitempty"`
	// UserListValue: Setting a user list value by selecting multiple users.
	UserListValue *FieldValueUserListValue `json:"userListValue,omitempty"`
	// UserValue: Setting a user value by selecting a single user.
	UserValue *FieldValueUserValue `json:"userValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DateValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DateValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldValue) MarshalJSON() ([]byte, error) {
	type NoMethod FieldValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldValueSelectionListValue: Setting a selection list value by selecting
// multiple values from a dropdown.
type FieldValueSelectionListValue struct {
	// Values: List of selections.
	Values []*FieldValueSelectionValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldValueSelectionListValue) MarshalJSON() ([]byte, error) {
	type NoMethod FieldValueSelectionListValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldValueSelectionValue: Setting a selection value by selecting a single
// value from a dropdown.
type FieldValueSelectionValue struct {
	// Badged: Whether the selection is badged.
	Badged bool `json:"badged,omitempty"`
	// DisplayName: Display name of the selection.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Identifier of the selection.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Badged") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Badged") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldValueSelectionValue) MarshalJSON() ([]byte, error) {
	type NoMethod FieldValueSelectionValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldValueTextListValue: Setting a text list value.
type FieldValueTextListValue struct {
	// Values: List of text values.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldValueTextListValue) MarshalJSON() ([]byte, error) {
	type NoMethod FieldValueTextListValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldValueUserListValue: Setting a user list value by selecting multiple
// users.
type FieldValueUserListValue struct {
	// Values: List of users.
	Values []*FieldValueUserValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldValueUserListValue) MarshalJSON() ([]byte, error) {
	type NoMethod FieldValueUserListValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FieldValueUserValue: Setting a user value by selecting a single user.
type FieldValueUserValue struct {
	// Email: Email of the user.
	Email string `json:"email,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FieldValueUserValue) MarshalJSON() ([]byte, error) {
	type NoMethod FieldValueUserValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NestedParameter: JSON template for a parameter used in various reports.
type NestedParameter struct {
	// BoolValue: Boolean value of the parameter.
	BoolValue bool `json:"boolValue,omitempty"`
	// IntValue: Integer value of the parameter.
	IntValue int64 `json:"intValue,omitempty,string"`
	// MultiBoolValue: Multiple boolean values of the parameter.
	MultiBoolValue []bool `json:"multiBoolValue,omitempty"`
	// MultiIntValue: Multiple integer values of the parameter.
	MultiIntValue googleapi.Int64s `json:"multiIntValue,omitempty"`
	// MultiValue: Multiple string values of the parameter.
	MultiValue []string `json:"multiValue,omitempty"`
	// Name: The name of the parameter.
	Name string `json:"name,omitempty"`
	// Value: String value of the parameter.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NestedParameter) MarshalJSON() ([]byte, error) {
	type NoMethod NestedParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Reason: The reason why the label/field was applied.
type Reason struct {
	// ReasonType: The type of the reason.
	ReasonType string `json:"reasonType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReasonType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReasonType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reason) MarshalJSON() ([]byte, error) {
	type NoMethod Reason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceDetails: Details of the resource on which the action was performed.
type ResourceDetails struct {
	// AppliedLabels: List of labels applied on the resource
	AppliedLabels []*AppliedLabel `json:"appliedLabels,omitempty"`
	// Id: Identifier of the resource.
	Id string `json:"id,omitempty"`
	// Relation: Defines relationship of the resource to the events
	Relation string `json:"relation,omitempty"`
	// Title: Title of the resource. For instance, in case of a drive document,
	// this would be the title of the document. In case of an email, this would be
	// the subject.
	Title string `json:"title,omitempty"`
	// Type: Type of the resource - document, email, chat message
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppliedLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppliedLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceDetails) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageReport: JSON template for a usage report.
type UsageReport struct {
	// Date: Output only. The date of the report request.
	Date string `json:"date,omitempty"`
	// Entity: Output only. Information about the type of the item.
	Entity *UsageReportEntity `json:"entity,omitempty"`
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of API resource. For a usage report, the value is
	// `admin#reports#usageReport`.
	Kind string `json:"kind,omitempty"`
	// Parameters: Output only. Parameter value pairs for various applications. For
	// the Entity Usage Report parameters and values, see the Entity Usage
	// parameters reference
	// (https://developers.google.com/workspace/admin/reports/v1/reference/usage-ref-appendix-a/entities).
	Parameters []*UsageReportParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Date") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Date") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageReport) MarshalJSON() ([]byte, error) {
	type NoMethod UsageReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageReportEntity: Output only. Information about the type of the item.
type UsageReportEntity struct {
	// CustomerId: Output only. The unique identifier of the customer's account.
	CustomerId string `json:"customerId,omitempty"`
	// EntityId: Output only. Object key. Only relevant if entity.type = "OBJECT"
	// Note: external-facing name of report is "Entities" rather than "Objects".
	EntityId string `json:"entityId,omitempty"`
	// ProfileId: Output only. The user's immutable Google Workspace profile
	// identifier.
	ProfileId string `json:"profileId,omitempty"`
	// Type: Output only. The type of item. The value is `user`.
	Type string `json:"type,omitempty"`
	// UserEmail: Output only. The user's email address. Only relevant if
	// entity.type = "USER"
	UserEmail string `json:"userEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomerId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageReportEntity) MarshalJSON() ([]byte, error) {
	type NoMethod UsageReportEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UsageReportParameters struct {
	// BoolValue: Output only. Boolean value of the parameter.
	BoolValue bool `json:"boolValue,omitempty"`
	// DatetimeValue: The RFC 3339 formatted value of the parameter, for example
	// 2010-10-28T10:26:35.000Z.
	DatetimeValue string `json:"datetimeValue,omitempty"`
	// IntValue: Output only. Integer value of the parameter.
	IntValue int64 `json:"intValue,omitempty,string"`
	// MsgValue: Output only. Nested message value of the parameter.
	MsgValue []googleapi.RawMessage `json:"msgValue,omitempty"`
	// Name: The name of the parameter. For the User Usage Report parameter names,
	// see the User Usage parameters reference.
	Name string `json:"name,omitempty"`
	// StringValue: Output only. String value of the parameter.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageReportParameters) MarshalJSON() ([]byte, error) {
	type NoMethod UsageReportParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UsageReports struct {
	// Etag: ETag of the resource.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of API resource. For a usage report, the value is
	// `admin#reports#usageReports`.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Token to specify next page. A report with multiple pages has
	// a `nextPageToken` property in the response. For your follow-on requests
	// getting all of the report's pages, enter the `nextPageToken` value in the
	// `pageToken` query string.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UsageReports: Various application parameter records.
	UsageReports []*UsageReport `json:"usageReports,omitempty"`
	// Warnings: Warnings, if any.
	Warnings []*UsageReportsWarnings `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageReports) MarshalJSON() ([]byte, error) {
	type NoMethod UsageReports
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UsageReportsWarnings struct {
	// Code: Machine readable code or warning type. The warning code value is
	// `200`.
	Code string `json:"code,omitempty"`
	// Data: Key-value pairs to give detailed information on the warning.
	Data []*UsageReportsWarningsData `json:"data,omitempty"`
	// Message: The human readable messages for a warning are: - Data is not
	// available warning - Sorry, data for date yyyy-mm-dd for application
	// "application name" is not available. - Partial data is available warning -
	// Data for date yyyy-mm-dd for application "application name" is not
	// available right now, please try again after a few hours.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageReportsWarnings) MarshalJSON() ([]byte, error) {
	type NoMethod UsageReportsWarnings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type UsageReportsWarningsData struct {
	// Key: Key associated with a key-value pair to give detailed information on
	// the warning.
	Key string `json:"key,omitempty"`
	// Value: Value associated with a key-value pair to give detailed information
	// on the warning.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageReportsWarningsData) MarshalJSON() ([]byte, error) {
	type NoMethod UsageReportsWarningsData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ActivitiesListCall struct {
	s               *Service
	userKey         string
	applicationName string
	urlParams_      gensupport.URLParams
	ifNoneMatch_    string
	ctx_            context.Context
	header_         http.Header
}

// List: Retrieves a list of activities for a specific customer's account and
// application such as the Admin console application or the Google Drive
// application. For more information, see the guides for administrator and
// Google Drive activity reports. For more information about the activity
// report's parameters, see the activity parameters reference guides.
//
//   - applicationName: Application name for which the events are to be
//     retrieved.
//   - userKey: Represents the profile ID or the user email for which the data
//     should be filtered. Can be `all` for all information, or `userKey` for a
//     user's unique Google Workspace profile ID or their primary email address.
//     Must not be a deleted user. For a deleted user, call `users.list` in
//     Directory API with `showDeleted=true`, then use the returned `ID` as the
//     `userKey`.
func (r *ActivitiesService) List(userKey string, applicationName string) *ActivitiesListCall {
	c := &ActivitiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.applicationName = applicationName
	return c
}

// ActorIpAddress sets the optional parameter "actorIpAddress": The Internet
// Protocol (IP) Address of host where the event was performed. This is an
// additional way to filter a report's summary using the IP address of the user
// whose activity is being reported. This IP address may or may not reflect the
// user's physical location. For example, the IP address can be the user's
// proxy server's address or a virtual private network (VPN) address. This
// parameter supports both IPv4 and IPv6 address versions.
func (c *ActivitiesListCall) ActorIpAddress(actorIpAddress string) *ActivitiesListCall {
	c.urlParams_.Set("actorIpAddress", actorIpAddress)
	return c
}

// CustomerId sets the optional parameter "customerId": The unique ID of the
// customer to retrieve data for.
func (c *ActivitiesListCall) CustomerId(customerId string) *ActivitiesListCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// EndTime sets the optional parameter "endTime": Sets the end of the range of
// time shown in the report. The date is in the RFC 3339 format, for example
// 2010-10-28T10:26:35.000Z. The default value is the approximate time of the
// API request. An API report has three basic time concepts: - *Date of the
// API's request for a report*: When the API created and retrieved the report.
// - *Report's start time*: The beginning of the timespan shown in the report.
// The `startTime` must be before the `endTime` (if specified) and the current
// time when the request is made, or the API returns an error. - *Report's end
// time*: The end of the timespan shown in the report. For example, the
// timespan of events summarized in a report can start in April and end in May.
// The report itself can be requested in August. If the `endTime` is not
// specified, the report returns all activities from the `startTime` until the
// current time or the most recent 180 days if the `startTime` is more than 180
// days in the past. For Gmail requests, `startTime` and `endTime` must be
// provided and the difference must not be greater than 30 days.
func (c *ActivitiesListCall) EndTime(endTime string) *ActivitiesListCall {
	c.urlParams_.Set("endTime", endTime)
	return c
}

// EventName sets the optional parameter "eventName": The name of the event
// being queried by the API. Each `eventName` is related to a specific Google
// Workspace service or feature which the API organizes into types of events.
// An example is the Google Calendar events in the Admin console application's
// reports. The Calendar Settings `type` structure has all of the Calendar
// `eventName` activities reported by the API. When an administrator changes a
// Calendar setting, the API reports this activity in the Calendar Settings
// `type` and `eventName` parameters. For more information about `eventName`
// query strings and parameters, see the list of event names for various
// applications above in `applicationName`.
func (c *ActivitiesListCall) EventName(eventName string) *ActivitiesListCall {
	c.urlParams_.Set("eventName", eventName)
	return c
}

// Filters sets the optional parameter "filters": The `filters` query string is
// a comma-separated list composed of event parameters manipulated by
// relational operators. Event parameters are in the form `{parameter1
// name}{relational operator}{parameter1 value},{parameter2 name}{relational
// operator}{parameter2 value},...` These event parameters are associated with
// a specific `eventName`. An empty report is returned if the request's
// parameter doesn't belong to the `eventName`. For more information about the
// available `eventName` fields for each application and their associated
// parameters, go to the ApplicationName (#applicationname) table, then click
// through to the Activity Events page in the Appendix for the application you
// want. In the following Drive activity examples, the returned list consists
// of all `edit` events where the `doc_id` parameter value matches the
// conditions defined by the relational operator. In the first example, the
// request returns all edited documents with a `doc_id` value equal to `12345`.
// In the second example, the report returns any edited documents where the
// `doc_id` value is not equal to `98765`. The `<>` operator is URL-encoded in
// the request's query string (`%3C%3E`): ```
// GET...&eventName=edit&filters=doc_id==12345
// GET...&eventName=edit&filters=doc_id%3C%3E98765 ``` A `filters` query
// supports these relational operators: * `==`—'equal to'. * `<>`—'not
// equal to'. Must be URL-encoded (%3C%3E). * `<`—'less than'. Must be
// URL-encoded (%3C). * `<=`—'less than or equal to'. Must be URL-encoded
// (%3C=). * `>`—'greater than'. Must be URL-encoded (%3E). * `>=`—'greater
// than or equal to'. Must be URL-encoded (%3E=). **Note:** The API doesn't
// accept multiple values of the same parameter. If a parameter is supplied
// more than once in the API request, the API only accepts the last value of
// that parameter. In addition, if an invalid parameter is supplied in the API
// request, the API ignores that parameter and returns the response
// corresponding to the remaining valid parameters. If no parameters are
// requested, all parameters are returned.
func (c *ActivitiesListCall) Filters(filters string) *ActivitiesListCall {
	c.urlParams_.Set("filters", filters)
	return c
}

// GroupIdFilter sets the optional parameter "groupIdFilter": Comma separated
// group ids (obfuscated) on which user activities are filtered, i.e. the
// response will contain activities for only those users that are a part of at
// least one of the group ids mentioned here. Format: "id:abc123,id:xyz456"
// *Important:* To filter by groups, you must explicitly add the groups to your
// filtering groups allowlist. For more information about adding groups to
// filtering groups allowlist, see Filter results by Google Group
// (https://support.google.com/a/answer/11482175)
func (c *ActivitiesListCall) GroupIdFilter(groupIdFilter string) *ActivitiesListCall {
	c.urlParams_.Set("groupIdFilter", groupIdFilter)
	return c
}

// MaxResults sets the optional parameter "maxResults": Determines how many
// activity records are shown on each response page. For example, if the
// request sets `maxResults=1` and the report has two activities, the report
// has two pages. The response's `nextPageToken` property has the token to the
// second page. The `maxResults` query string is optional in the request. The
// default value is 1000.
func (c *ActivitiesListCall) MaxResults(maxResults int64) *ActivitiesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrgUnitID sets the optional parameter "orgUnitID": ID of the organizational
// unit to report on. Activity records will be shown only for users who belong
// to the specified organizational unit. Data before Dec 17, 2018 doesn't
// appear in the filtered results.
func (c *ActivitiesListCall) OrgUnitID(orgUnitID string) *ActivitiesListCall {
	c.urlParams_.Set("orgUnitID", orgUnitID)
	return c
}

// PageToken sets the optional parameter "pageToken": The token to specify next
// page. A report with multiple pages has a `nextPageToken` property in the
// response. In your follow-on request getting the next page of the report,
// enter the `nextPageToken` value in the `pageToken` query string.
func (c *ActivitiesListCall) PageToken(pageToken string) *ActivitiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceDetailsFilter sets the optional parameter "resourceDetailsFilter":
// The `resourceDetailsFilter` query string is an AND separated list composed
// of Resource Details (#resourcedetails) fields manipulated by relational
// operators. Resource Details Filters are in the form
// `{resourceDetails.field1}{relational operator}{field1 value} AND
// {resourceDetails.field2}{relational operator}{field2 value}...` All the
// inner fields are traversed using the `.` operator, as shown in the following
// example: ``` resourceDetails.id = "resourceId" AND
// resourceDetails.appliedLabels.id = "appliedLabelId" AND
// resourceDetails.appliedLabels.fieldValue.id = "fieldValueId" ```
// `resourceDetailsFilter` query supports these relational operators: *
// `=`—'equal to'. * `!=`—'not equal to'. * `:`—'exists'. This is used
// for filtering on repeated fields. `FieldValue` (#fieldvalue) types that are
// repeated in nature uses `exists` operator for filtering. The following
// `FieldValue` (#fieldvalue) types are repeated: * `TextListValue`
// (#textlistvalue) * `SelectionListValue` (#selectionlistvalue) *
// `UserListValue` (#userlistvalue) For example, in the following filter,
// `SelectionListValue` (#selectionlistvalue), is a repeated field. The filter
// checks whether `SelectionListValue` (#selectionlistvalue) contains
// `selection_id`: ``` resourceDetails.id = "resourceId" AND
// resourceDetails.appliedLabels.id = "appliedLabelId" AND
// resourceDetails.appliedLabels.fieldValue.id = "fieldValueId" AND
// resourceDetails.appliedLabels.fieldValue.type = "SELECTION_LIST_VALUE" AND
// resourceDetails.appliedLabels.fieldValue.selectionListValue.id: "id" ```
// **Usage** ``` GET...&resourceDetailsFilter=resourceDetails.id = "resourceId"
// AND resourceDetails.appliedLabels.id = "appliedLabelId"
// GET...&resourceDetailsFilter=resourceDetails.id=%22resourceId%22%20AND%20reso
// urceDetails.appliedLabels.id=%22appliedLabelId%22 ``` **Note the
// following**: * You must URL encode the query string before sending the
// request. * The API supports a maximum of 5 fields separated by the AND
// operator. - When filtering on deeper levels (e.g., `AppliedLabel`
// (#appliedlabel), `FieldValue` (#fieldvalue)), the IDs of all preceding
// levels in the hierarchy must be included in the filter. For example:
// Filtering on `FieldValue` (#fieldvalue) requires `AppliedLabel`
// (#appliedlabel) ID and resourceDetails ID to be present. *Sample Query*: ```
// resourceDetails.id = "resourceId" AND resourceDetails.appliedLabels.id =
// "appliedLabelId" AND resourceDetails.appliedLabels.fieldValue.id =
// "fieldValueId" ``` * Filtering on inner `FieldValue` (#fieldvalue) types
// like `longTextValue` and `textValue` requires
// `resourceDetails.appliedLabels.fieldValue.type` to be present. * Only
// Filtering on a single `AppliedLabel` (#appliedlabel) id and `FieldValue`
// (#fieldvalue) id is supported.
func (c *ActivitiesListCall) ResourceDetailsFilter(resourceDetailsFilter string) *ActivitiesListCall {
	c.urlParams_.Set("resourceDetailsFilter", resourceDetailsFilter)
	return c
}

// StartTime sets the optional parameter "startTime": Sets the beginning of the
// range of time shown in the report. The date is in the RFC 3339 format, for
// example 2010-10-28T10:26:35.000Z. The report returns all activities from
// `startTime` until `endTime`. The `startTime` must be before the `endTime`
// (if specified) and the current time when the request is made, or the API
// returns an error. For Gmail requests, `startTime` and `endTime` must be
// provided and the difference must not be greater than 30 days.
func (c *ActivitiesListCall) StartTime(startTime string) *ActivitiesListCall {
	c.urlParams_.Set("startTime", startTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ActivitiesListCall) Fields(s ...googleapi.Field) *ActivitiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ActivitiesListCall) IfNoneMatch(entityTag string) *ActivitiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ActivitiesListCall) Context(ctx context.Context) *ActivitiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ActivitiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ActivitiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/reports/v1/activity/users/{userKey}/applications/{applicationName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey":         c.userKey,
		"applicationName": c.applicationName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "reports.activities.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "reports.activities.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *Activities.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ActivitiesListCall) Do(opts ...googleapi.CallOption) (*Activities, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Activities{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "reports.activities.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ActivitiesListCall) Pages(ctx context.Context, f func(*Activities) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ActivitiesWatchCall struct {
	s               *Service
	userKey         string
	applicationName string
	channel         *Channel
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Watch: Start receiving notifications for account activities. For more
// information, see Receiving Push Notifications.
//
//   - applicationName: Application name for which the events are to be
//     retrieved.
//   - userKey: Represents the profile ID or the user email for which the data
//     should be filtered. Can be `all` for all information, or `userKey` for a
//     user's unique Google Workspace profile ID or their primary email address.
//     Must not be a deleted user. For a deleted user, call `users.list` in
//     Directory API with `showDeleted=true`, then use the returned `ID` as the
//     `userKey`.
func (r *ActivitiesService) Watch(userKey string, applicationName string, channel *Channel) *ActivitiesWatchCall {
	c := &ActivitiesWatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.applicationName = applicationName
	c.channel = channel
	return c
}

// ActorIpAddress sets the optional parameter "actorIpAddress": The Internet
// Protocol (IP) Address of host where the event was performed. This is an
// additional way to filter a report's summary using the IP address of the user
// whose activity is being reported. This IP address may or may not reflect the
// user's physical location. For example, the IP address can be the user's
// proxy server's address or a virtual private network (VPN) address. This
// parameter supports both IPv4 and IPv6 address versions.
func (c *ActivitiesWatchCall) ActorIpAddress(actorIpAddress string) *ActivitiesWatchCall {
	c.urlParams_.Set("actorIpAddress", actorIpAddress)
	return c
}

// CustomerId sets the optional parameter "customerId": The unique ID of the
// customer to retrieve data for.
func (c *ActivitiesWatchCall) CustomerId(customerId string) *ActivitiesWatchCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// EndTime sets the optional parameter "endTime": Sets the end of the range of
// time shown in the report. The date is in the RFC 3339 format, for example
// 2010-10-28T10:26:35.000Z. The default value is the approximate time of the
// API request. An API report has three basic time concepts: - *Date of the
// API's request for a report*: When the API created and retrieved the report.
// - *Report's start time*: The beginning of the timespan shown in the report.
// The `startTime` must be before the `endTime` (if specified) and the current
// time when the request is made, or the API returns an error. - *Report's end
// time*: The end of the timespan shown in the report. For example, the
// timespan of events summarized in a report can start in April and end in May.
// The report itself can be requested in August. If the `endTime` is not
// specified, the report returns all activities from the `startTime` until the
// current time or the most recent 180 days if the `startTime` is more than 180
// days in the past.
func (c *ActivitiesWatchCall) EndTime(endTime string) *ActivitiesWatchCall {
	c.urlParams_.Set("endTime", endTime)
	return c
}

// EventName sets the optional parameter "eventName": The name of the event
// being queried by the API. Each `eventName` is related to a specific Google
// Workspace service or feature which the API organizes into types of events.
// An example is the Google Calendar events in the Admin console application's
// reports. The Calendar Settings `type` structure has all of the Calendar
// `eventName` activities reported by the API. When an administrator changes a
// Calendar setting, the API reports this activity in the Calendar Settings
// `type` and `eventName` parameters. For more information about `eventName`
// query strings and parameters, see the list of event names for various
// applications above in `applicationName`.
func (c *ActivitiesWatchCall) EventName(eventName string) *ActivitiesWatchCall {
	c.urlParams_.Set("eventName", eventName)
	return c
}

// Filters sets the optional parameter "filters": The `filters` query string is
// a comma-separated list composed of event parameters manipulated by
// relational operators. Event parameters are in the form `{parameter1
// name}{relational operator}{parameter1 value},{parameter2 name}{relational
// operator}{parameter2 value},...` These event parameters are associated with
// a specific `eventName`. An empty report is returned if the request's
// parameter doesn't belong to the `eventName`. For more information about the
// available `eventName` fields for each application and their associated
// parameters, go to the ApplicationName (#applicationname) table, then click
// through to the Activity Events page in the Appendix for the application you
// want. In the following Drive activity examples, the returned list consists
// of all `edit` events where the `doc_id` parameter value matches the
// conditions defined by the relational operator. In the first example, the
// request returns all edited documents with a `doc_id` value equal to `12345`.
// In the second example, the report returns any edited documents where the
// `doc_id` value is not equal to `98765`. The `<>` operator is URL-encoded in
// the request's query string (`%3C%3E`): ```
// GET...&eventName=edit&filters=doc_id==12345
// GET...&eventName=edit&filters=doc_id%3C%3E98765 ``` A `filters` query
// supports these relational operators: * `==`—'equal to'. * `<>`—'not
// equal to'. Must be URL-encoded (%3C%3E). * `<`—'less than'. Must be
// URL-encoded (%3C). * `<=`—'less than or equal to'. Must be URL-encoded
// (%3C=). * `>`—'greater than'. Must be URL-encoded (%3E). * `>=`—'greater
// than or equal to'. Must be URL-encoded (%3E=). **Note:** The API doesn't
// accept multiple values of the same parameter. If a parameter is supplied
// more than once in the API request, the API only accepts the last value of
// that parameter. In addition, if an invalid parameter is supplied in the API
// request, the API ignores that parameter and returns the response
// corresponding to the remaining valid parameters. If no parameters are
// requested, all parameters are returned.
func (c *ActivitiesWatchCall) Filters(filters string) *ActivitiesWatchCall {
	c.urlParams_.Set("filters", filters)
	return c
}

// GroupIdFilter sets the optional parameter "groupIdFilter": `Deprecated`.
// This field is deprecated and is no longer supported. Comma separated group
// ids (obfuscated) on which user activities are filtered, i.e. the response
// will contain activities for only those users that are a part of at least one
// of the group ids mentioned here. Format: "id:abc123,id:xyz456" *Important:*
// To filter by groups, you must explicitly add the groups to your filtering
// groups allowlist. For more information about adding groups to filtering
// groups allowlist, see Filter results by Google Group
// (https://support.google.com/a/answer/11482175)
func (c *ActivitiesWatchCall) GroupIdFilter(groupIdFilter string) *ActivitiesWatchCall {
	c.urlParams_.Set("groupIdFilter", groupIdFilter)
	return c
}

// MaxResults sets the optional parameter "maxResults": Determines how many
// activity records are shown on each response page. For example, if the
// request sets `maxResults=1` and the report has two activities, the report
// has two pages. The response's `nextPageToken` property has the token to the
// second page. The `maxResults` query string is optional in the request. The
// default value is 1000.
func (c *ActivitiesWatchCall) MaxResults(maxResults int64) *ActivitiesWatchCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrgUnitID sets the optional parameter "orgUnitID": `Deprecated`. This field
// is deprecated and is no longer supported. ID of the organizational unit to
// report on. Activity records will be shown only for users who belong to the
// specified organizational unit. Data before Dec 17, 2018 doesn't appear in
// the filtered results.
func (c *ActivitiesWatchCall) OrgUnitID(orgUnitID string) *ActivitiesWatchCall {
	c.urlParams_.Set("orgUnitID", orgUnitID)
	return c
}

// PageToken sets the optional parameter "pageToken": The token to specify next
// page. A report with multiple pages has a `nextPageToken` property in the
// response. In your follow-on request getting the next page of the report,
// enter the `nextPageToken` value in the `pageToken` query string.
func (c *ActivitiesWatchCall) PageToken(pageToken string) *ActivitiesWatchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// StartTime sets the optional parameter "startTime": Sets the beginning of the
// range of time shown in the report. The date is in the RFC 3339 format, for
// example 2010-10-28T10:26:35.000Z. The report returns all activities from
// `startTime` until `endTime`. The `startTime` must be before the `endTime`
// (if specified) and the current time when the request is made, or the API
// returns an error.
func (c *ActivitiesWatchCall) StartTime(startTime string) *ActivitiesWatchCall {
	c.urlParams_.Set("startTime", startTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ActivitiesWatchCall) Fields(s ...googleapi.Field) *ActivitiesWatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ActivitiesWatchCall) Context(ctx context.Context) *ActivitiesWatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ActivitiesWatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ActivitiesWatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.channel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/reports/v1/activity/users/{userKey}/applications/{applicationName}/watch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey":         c.userKey,
		"applicationName": c.applicationName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "reports.activities.watch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "reports.activities.watch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Channel.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ActivitiesWatchCall) Do(opts ...googleapi.CallOption) (*Channel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Channel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "reports.activities.watch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ChannelsStopCall struct {
	s          *Service
	channel    *Channel
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Stop: Stop watching resources through this channel.
func (r *ChannelsService) Stop(channel *Channel) *ChannelsStopCall {
	c := &ChannelsStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.channel = channel
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ChannelsStopCall) Fields(s ...googleapi.Field) *ChannelsStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ChannelsStopCall) Context(ctx context.Context) *ChannelsStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ChannelsStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ChannelsStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.channel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/reports_v1/channels/stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "admin.channels.stop", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "admin.channels.stop" call.
func (c *ChannelsStopCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "admin.channels.stop", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type CustomerUsageReportsGetCall struct {
	s            *Service
	date         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a report which is a collection of properties and statistics
// for a specific customer's account. For more information, see the Customers
// Usage Report guide. For more information about the customer report's
// parameters, see the Customers Usage parameters reference guides.
//
//   - date: Represents the date the usage occurred, based on UTC-8:00 (Pacific
//     Standard Time). The timestamp is in the ISO 8601 format
//     (https://en.wikipedia.org/wiki/ISO_8601), `yyyy-mm-dd`.
func (r *CustomerUsageReportsService) Get(date string) *CustomerUsageReportsGetCall {
	c := &CustomerUsageReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.date = date
	return c
}

// CustomerId sets the optional parameter "customerId": The unique ID of the
// customer to retrieve data for.
func (c *CustomerUsageReportsGetCall) CustomerId(customerId string) *CustomerUsageReportsGetCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page. A report with multiple pages has a `nextPageToken` property in the
// response. For your follow-on requests getting all of the report's pages,
// enter the `nextPageToken` value in the `pageToken` query string.
func (c *CustomerUsageReportsGetCall) PageToken(pageToken string) *CustomerUsageReportsGetCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parameters sets the optional parameter "parameters": The `parameters` query
// string is a comma-separated list of event parameters that refine a report's
// results. The parameter is associated with a specific application. The
// application values for the Customers usage report include `accounts`,
// `app_maker`, `apps_scripts`, `calendar`, `chat`, `classroom`, `cros`,
// `docs`, `gmail`, `gplus`, `device_management`, `meet`, and `sites`. A
// `parameters` query string is in the CSV form of `app_name1:param_name1,
// app_name2:param_name2`. *Note:* The API doesn't accept multiple values of a
// parameter. If a particular parameter is supplied more than once in the API
// request, the API only accepts the last value of that request parameter. In
// addition, if an invalid request parameter is supplied in the API request,
// the API ignores that request parameter and returns the response
// corresponding to the remaining valid request parameters. An example of an
// invalid request parameter is one that does not belong to the application. If
// no parameters are requested, all parameters are returned.
func (c *CustomerUsageReportsGetCall) Parameters(parameters string) *CustomerUsageReportsGetCall {
	c.urlParams_.Set("parameters", parameters)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomerUsageReportsGetCall) Fields(s ...googleapi.Field) *CustomerUsageReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomerUsageReportsGetCall) IfNoneMatch(entityTag string) *CustomerUsageReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomerUsageReportsGetCall) Context(ctx context.Context) *CustomerUsageReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomerUsageReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomerUsageReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/reports/v1/usage/dates/{date}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"date": c.date,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "reports.customerUsageReports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "reports.customerUsageReports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UsageReports.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomerUsageReportsGetCall) Do(opts ...googleapi.CallOption) (*UsageReports, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UsageReports{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "reports.customerUsageReports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomerUsageReportsGetCall) Pages(ctx context.Context, f func(*UsageReports) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type EntityUsageReportsGetCall struct {
	s            *Service
	entityType   string
	entityKey    string
	date         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a report which is a collection of properties and statistics
// for entities used by users within the account. For more information, see the
// Entities Usage Report guide. For more information about the entities
// report's parameters, see the Entities Usage parameters reference guides.
//
//   - date: Represents the date the usage occurred, based on UTC-8:00 (Pacific
//     Standard Time). The timestamp is in the ISO 8601 format
//     (https://en.wikipedia.org/wiki/ISO_8601), `yyyy-mm-dd`.
//   - entityKey: Represents the key of the object to filter the data with. It is
//     a string which can take the value `all` to get activity events for all
//     users, or any other value for an app-specific entity. For details on how
//     to obtain the `entityKey` for a particular `entityType`, see the Entities
//     Usage parameters reference guides.
//   - entityType: Represents the type of entity for the report.
func (r *EntityUsageReportsService) Get(entityType string, entityKey string, date string) *EntityUsageReportsGetCall {
	c := &EntityUsageReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entityType = entityType
	c.entityKey = entityKey
	c.date = date
	return c
}

// CustomerId sets the optional parameter "customerId": The unique ID of the
// customer to retrieve data for.
func (c *EntityUsageReportsGetCall) CustomerId(customerId string) *EntityUsageReportsGetCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Filters sets the optional parameter "filters": The `filters` query string is
// a comma-separated list of an application's event parameters where the
// parameter's value is manipulated by a relational operator. The `filters`
// query string includes the name of the application whose usage is returned in
// the report. The application values for the Entities usage report include
// `accounts`, `docs`, and `gmail`. Filters are in the form `[application
// name]:parameter name[parameter value],...`. In this example, the `<>` 'not
// equal to' operator is URL-encoded in the request's query string (%3C%3E):
// GET
// https://www.googleapis.com/admin/reports/v1/usage/gplus_communities/all/dates/2017-12-01
// ?parameters=gplus:community_name,gplus:num_total_members
// &filters=gplus:num_total_members%3C%3E0 The relational operators include: -
// `==` - 'equal to'. - `<>` - 'not equal to'. It is URL-encoded (%3C%3E). -
// `<` - 'less than'. It is URL-encoded (%3C). - `<=` - 'less than or equal
// to'. It is URL-encoded (%3C=). - `>` - 'greater than'. It is URL-encoded
// (%3E). - `>=` - 'greater than or equal to'. It is URL-encoded (%3E=).
// Filters can only be applied to numeric parameters.
func (c *EntityUsageReportsGetCall) Filters(filters string) *EntityUsageReportsGetCall {
	c.urlParams_.Set("filters", filters)
	return c
}

// MaxResults sets the optional parameter "maxResults": Determines how many
// activity records are shown on each response page. For example, if the
// request sets `maxResults=1` and the report has two activities, the report
// has two pages. The response's `nextPageToken` property has the token to the
// second page.
func (c *EntityUsageReportsGetCall) MaxResults(maxResults int64) *EntityUsageReportsGetCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page. A report with multiple pages has a `nextPageToken` property in the
// response. In your follow-on request getting the next page of the report,
// enter the `nextPageToken` value in the `pageToken` query string.
func (c *EntityUsageReportsGetCall) PageToken(pageToken string) *EntityUsageReportsGetCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parameters sets the optional parameter "parameters": The `parameters` query
// string is a comma-separated list of event parameters that refine a report's
// results. The parameter is associated with a specific application. The
// application values for the Entities usage report are only `gplus`. A
// `parameter` query string is in the CSV form of `[app_name1:param_name1],
// [app_name2:param_name2]...`. *Note:* The API doesn't accept multiple values
// of a parameter. If a particular parameter is supplied more than once in the
// API request, the API only accepts the last value of that request parameter.
// In addition, if an invalid request parameter is supplied in the API request,
// the API ignores that request parameter and returns the response
// corresponding to the remaining valid request parameters. An example of an
// invalid request parameter is one that does not belong to the application. If
// no parameters are requested, all parameters are returned.
func (c *EntityUsageReportsGetCall) Parameters(parameters string) *EntityUsageReportsGetCall {
	c.urlParams_.Set("parameters", parameters)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EntityUsageReportsGetCall) Fields(s ...googleapi.Field) *EntityUsageReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *EntityUsageReportsGetCall) IfNoneMatch(entityTag string) *EntityUsageReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EntityUsageReportsGetCall) Context(ctx context.Context) *EntityUsageReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EntityUsageReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EntityUsageReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/reports/v1/usage/{entityType}/{entityKey}/dates/{date}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entityType": c.entityType,
		"entityKey":  c.entityKey,
		"date":       c.date,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "reports.entityUsageReports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "reports.entityUsageReports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UsageReports.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EntityUsageReportsGetCall) Do(opts ...googleapi.CallOption) (*UsageReports, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UsageReports{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "reports.entityUsageReports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EntityUsageReportsGetCall) Pages(ctx context.Context, f func(*UsageReports) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type UserUsageReportGetCall struct {
	s            *Service
	userKey      string
	date         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a report which is a collection of properties and statistics
// for a set of users with the account. For more information, see the User
// Usage Report guide. For more information about the user report's parameters,
// see the Users Usage parameters reference guides.
//
//   - date: Represents the date the usage occurred, based on UTC-8:00 (Pacific
//     Standard Time). The timestamp is in the ISO 8601 format
//     (https://en.wikipedia.org/wiki/ISO_8601), `yyyy-mm-dd`.
//   - userKey: Represents the profile ID or the user email for which the data
//     should be filtered. Can be `all` for all information, or `userKey` for a
//     user's unique Google Workspace profile ID or their primary email address.
//     Must not be a deleted user. For a deleted user, call `users.list` in
//     Directory API with `showDeleted=true`, then use the returned `ID` as the
//     `userKey`.
func (r *UserUsageReportService) Get(userKey string, date string) *UserUsageReportGetCall {
	c := &UserUsageReportGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.userKey = userKey
	c.date = date
	return c
}

// CustomerId sets the optional parameter "customerId": The unique ID of the
// customer to retrieve data for.
func (c *UserUsageReportGetCall) CustomerId(customerId string) *UserUsageReportGetCall {
	c.urlParams_.Set("customerId", customerId)
	return c
}

// Filters sets the optional parameter "filters": The `filters` query string is
// a comma-separated list of an application's event parameters where the
// parameter's value is manipulated by a relational operator. The `filters`
// query string includes the name of the application whose usage is returned in
// the report. The application values for the Users Usage Report include
// `accounts`, `chat`, `docs`, and `gmail`. Filters are in the form
// `[application name]:parameter name[parameter value],...`. In this example,
// the `<>` 'not equal to' operator is URL-encoded in the request's query
// string (%3C%3E): GET
// https://www.googleapis.com/admin/reports/v1/usage/users/all/dates/2013-03-03
// ?parameters=accounts:last_login_time
// &filters=accounts:last_login_time%3C%3E2010-10-28T10:26:35.000Z The
// relational operators include: - `==` - 'equal to'. - `<>` - 'not equal to'.
// It is URL-encoded (%3C%3E). - `<` - 'less than'. It is URL-encoded (%3C). -
// `<=` - 'less than or equal to'. It is URL-encoded (%3C=). - `>` - 'greater
// than'. It is URL-encoded (%3E). - `>=` - 'greater than or equal to'. It is
// URL-encoded (%3E=).
func (c *UserUsageReportGetCall) Filters(filters string) *UserUsageReportGetCall {
	c.urlParams_.Set("filters", filters)
	return c
}

// GroupIdFilter sets the optional parameter "groupIdFilter": Comma separated
// group ids (obfuscated) on which user activities are filtered, i.e. the
// response will contain activities for only those users that are a part of at
// least one of the group ids mentioned here. Format: "id:abc123,id:xyz456"
func (c *UserUsageReportGetCall) GroupIdFilter(groupIdFilter string) *UserUsageReportGetCall {
	c.urlParams_.Set("groupIdFilter", groupIdFilter)
	return c
}

// MaxResults sets the optional parameter "maxResults": Determines how many
// activity records are shown on each response page. For example, if the
// request sets `maxResults=1` and the report has two activities, the report
// has two pages. The response's `nextPageToken` property has the token to the
// second page. The `maxResults` query string is optional.
func (c *UserUsageReportGetCall) MaxResults(maxResults int64) *UserUsageReportGetCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrgUnitID sets the optional parameter "orgUnitID": ID of the organizational
// unit to report on. User activity will be shown only for users who belong to
// the specified organizational unit. Data before Dec 17, 2018 doesn't appear
// in the filtered results.
func (c *UserUsageReportGetCall) OrgUnitID(orgUnitID string) *UserUsageReportGetCall {
	c.urlParams_.Set("orgUnitID", orgUnitID)
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page. A report with multiple pages has a `nextPageToken` property in the
// response. In your follow-on request getting the next page of the report,
// enter the `nextPageToken` value in the `pageToken` query string.
func (c *UserUsageReportGetCall) PageToken(pageToken string) *UserUsageReportGetCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parameters sets the optional parameter "parameters": The `parameters` query
// string is a comma-separated list of event parameters that refine a report's
// results. The parameter is associated with a specific application. The
// application values for the Customers Usage report include `accounts`,
// `app_maker`, `apps_scripts`, `calendar`, `chat`, `classroom`, `cros`,
// `docs`, `gmail`, `gplus`, `device_management`, `meet`, and `sites`. A
// `parameters` query string is in the CSV form of `app_name1:param_name1,
// app_name2:param_name2`. *Note:* The API doesn't accept multiple values of a
// parameter. If a particular parameter is supplied more than once in the API
// request, the API only accepts the last value of that request parameter. In
// addition, if an invalid request parameter is supplied in the API request,
// the API ignores that request parameter and returns the response
// corresponding to the remaining valid request parameters. An example of an
// invalid request parameter is one that does not belong to the application. If
// no parameters are requested, all parameters are returned.
func (c *UserUsageReportGetCall) Parameters(parameters string) *UserUsageReportGetCall {
	c.urlParams_.Set("parameters", parameters)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UserUsageReportGetCall) Fields(s ...googleapi.Field) *UserUsageReportGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UserUsageReportGetCall) IfNoneMatch(entityTag string) *UserUsageReportGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UserUsageReportGetCall) Context(ctx context.Context) *UserUsageReportGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UserUsageReportGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UserUsageReportGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "admin/reports/v1/usage/users/{userKey}/dates/{date}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"userKey": c.userKey,
		"date":    c.date,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "reports.userUsageReport.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "reports.userUsageReport.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *UsageReports.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UserUsageReportGetCall) Do(opts ...googleapi.CallOption) (*UsageReports, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UsageReports{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "reports.userUsageReport.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *UserUsageReportGetCall) Pages(ctx context.Context, f func(*UsageReports) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
