# Enhancer examples

The CLI exposes support for some enhancers. These are used to scan for additional information only:

1. In files that have license matches
2. In the parts of those files that are not part of the license match
3. When logging is turned on -- so you can see what is found
4. Using the CLI (i.e., not the API yet)

## Keywords and copyrights

* The keywords are currently hard-coded.
* Regex is used, but for performance reasons a future version should do string matching instead where possible.

```go
var DefaultKeywordList = []string{
`public domain`,
`Affero`,
`[a-z]*gpl`,
`[a-z-]*commercial[a-z]*`,
`[a-z-]*licen[cs][a-z]*`,
}
```

### Example 1: HIDDEN inside the license match

We log the matching block of license text. Notice here that, keywords and copyright are INSIDE the matched license text and so they are not logged separately.

```shell
go run ../../.. --file testdata/ANTLR-PD.txt --copyrights --keywords
go run ../../.. --file testdata/0BSD.txt --copyrights --keywords
```

### Example 2: It works outside the license match

If we add a copyright before the license match and some more interesting text after the matching block like this:

```shell
diff -u testdata/ANTLR-PD.txt testdata/ANTLR-PD_plus.txt
```

Diff output:

```diff
+Copyright (c) 2023 by myself
+
 ANTLR 2 License
 
 We reserve no legal rights to the ANTLR--it is fully in the public domain. An individual or company may do whatever they wish with source code distributed with ANTLR or the code generated by ANTLR, including the incorporation of ANTLR, or its output, into commerical software.
 
 We encourage users to develop software with ANTLR. However, we do ask that credit is given to us for developing ANTLR. By "credit", we mean that if you use ANTLR or incorporate any source code into one of your programs (commercial product, research project, or otherwise) that you acknowledge this fact somewhere in the documentation, research report, etc... If you like ANTLR and have developed a nice tool with the output, please mention that you developed it using ANTLR. In addition, we ask that the headers remain intact in our source code. As long as these guidelines are kept, we expect to continue enhancing this system and expect to make other tools available as they are completed.
+
+ANOTHER 2 License
+
+And let's add some xxxlicensxxx keywords like public domain here...
+Did you notice the words public domain and commercial in the original license text?
+We also catch Affero, anyGPL, and noncommercial or non-commercial. Or sublicense, sub-licence?
+And the file could continue on and on...
+
```

```shell
go run ../../.. --file testdata/ANTLR-PD_plus.txt --copyrights --keywords
```

### Example 3: HIDDEN by quiet mode

Quiet mode hides the enhancements which are currently only logged. Here are some license matches, but you don't see keywords or copyrights called out.

```bash
go run ../../.. --dir testdata --copyrights --keywords --quiet
```

### Example 4: HIDDEN when NO license match

With NO license matches (`--spdx none` gives us no ANTLR), the files are not interesting. No enhancements.

```bash
go run ../../.. --dir testdata --copyrights --keywords --spdx none
```
