RabbitMQ `3.11.20` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Fixed a potential resource leak in at-least-once dead lettering from quorum queues.

   GitHub issue: [#8799](https://github.com/rabbitmq/rabbitmq-server/pull/8799)


### CLI Tools

#### Enhancements

 * A new command, `rabbitmqctl deactivate_free_disk_space_monitoring`, can be used to (temporarily or permanently) disable
   free disk space monitoring on a node.

   To re-activate it, use `rabbitmqctl activate_free_disk_space_monitoring`.

   GitHub issue: [#8801](https://github.com/rabbitmq/rabbitmq-server/pull/8801)


### AMQP 1.0 Plugin

#### Bug Fixes

 * AMQP 1.0 clients that try to publish in a way that results in the message not being routed
   anywhere are now notified with a more sensible settlement status.

   GitHub issue: [#7823](https://github.com/rabbitmq/rabbitmq-server/issues/7823)


### Prometheus Plugin

#### Enhancements

 * Prometheus scraping API endpoints now support optional authentication.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#8683](https://github.com/rabbitmq/rabbitmq-server/pull/8683)

 * The plugin now filters out values that are `undefined` or `NaN`, simply excluding
   them from the API endpoint response.

   Previously, if a metric was not computed for any reason (e.g. free disk space monitor
   was disabled on the node), its value could end up being rendered as `undefined` or `NaN`,
   two values that Prometheus scrapers cannot handle (for numerical types such as gauges).

   GitHub issue: [#8660](https://github.com/rabbitmq/rabbitmq-server/issues/8660)


### Management Plugin

#### Bug Fixes

 * It was not possible to close a table column selection pane on
   screens that had little vertical space.

   Contributed by @Antsthebul.

   GitHub issue: [#8701](https://github.com/rabbitmq/rabbitmq-server/pull/8701)


## Dependency Upgrades

 * `ra` was upgraded to [`2.6.3`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.20.tar.xz`
instead of the source tarball produced by GitHub.
