/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractBoundedChromosome;
import io.jenetics.DoubleGene;
import io.jenetics.NumericChromosome;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.reflect;
import io.jenetics.util.DoubleRange;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DoubleChromosome
extends AbstractBoundedChromosome<Double, DoubleGene>
implements NumericChromosome<Double, DoubleGene>,
Serializable {
    private static final long serialVersionUID = 2L;

    protected DoubleChromosome(ISeq<DoubleGene> genes, IntRange lengthRange) {
        super(genes, lengthRange);
    }

    public DoubleChromosome(Double min, Double max, IntRange lengthRange) {
        this(DoubleGene.seq(min, max, lengthRange), lengthRange);
        this._valid = true;
    }

    public DoubleChromosome(Double min, Double max, int length) {
        this(min, max, IntRange.of(length));
    }

    public DoubleChromosome(Double min, Double max) {
        this(min, max, 1);
    }

    public double[] toArray(double[] array2) {
        double[] a = array2.length >= this.length() ? array2 : new double[this.length()];
        int i = this.length();
        while (--i >= 0) {
            a[i] = this.doubleValue(i);
        }
        return a;
    }

    public double[] toArray() {
        return this.toArray(new double[this.length()]);
    }

    public static DoubleChromosome of(DoubleGene ... genes) {
        return new DoubleChromosome(ISeq.of(genes), IntRange.of(genes.length));
    }

    public static DoubleChromosome of(double min, double max, IntRange lengthRange) {
        return new DoubleChromosome((Double)min, (Double)max, lengthRange);
    }

    public static DoubleChromosome of(double min, double max, int length) {
        return new DoubleChromosome((Double)min, (Double)max, length);
    }

    public static DoubleChromosome of(DoubleRange range, IntRange lengthRange) {
        return new DoubleChromosome((Double)range.getMin(), (Double)range.getMax(), lengthRange);
    }

    public static DoubleChromosome of(DoubleRange range, int length) {
        return new DoubleChromosome((Double)range.getMin(), (Double)range.getMax(), length);
    }

    public static DoubleChromosome of(double min, double max) {
        return new DoubleChromosome(min, max);
    }

    public static DoubleChromosome of(DoubleRange range) {
        return new DoubleChromosome(range.getMin(), range.getMax());
    }

    public DoubleChromosome newInstance(ISeq<DoubleGene> genes) {
        return new DoubleChromosome(genes, this.lengthRange());
    }

    @Override
    public DoubleChromosome newInstance() {
        return new DoubleChromosome((Double)this._min, (Double)this._max, this.lengthRange());
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.length());
        out.writeObject(this.lengthRange());
        out.writeDouble((Double)this._min);
        out.writeDouble((Double)this._max);
        for (DoubleGene gene : this._genes) {
            out.writeDouble((Double)gene.getAllele());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        MSeq<DoubleGene> genes = MSeq.ofLength(in.readInt());
        reflect.setField(this, "_lengthRange", in.readObject());
        reflect.setField(this, "_min", in.readDouble());
        reflect.setField(this, "_max", in.readDouble());
        for (int i = 0; i < genes.length(); ++i) {
            genes.set(i, new DoubleGene(in.readDouble(), (Double)this._min, (Double)this._max));
        }
        reflect.setField(this, "_genes", genes.toISeq());
    }
}

