/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class AccumulatorOperators {
    public static AccumulatorOperatorFactory valueOf(String fieldReference) {
        return new AccumulatorOperatorFactory(fieldReference);
    }

    public static AccumulatorOperatorFactory valueOf(AggregationExpression expression) {
        return new AccumulatorOperatorFactory(expression);
    }

    public static class AccumulatorOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public AccumulatorOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public AccumulatorOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Sum sum() {
            return this.usesFieldRef() ? Sum.sumOf(this.fieldReference) : Sum.sumOf(this.expression);
        }

        public Avg avg() {
            return this.usesFieldRef() ? Avg.avgOf(this.fieldReference) : Avg.avgOf(this.expression);
        }

        public Max max() {
            return this.usesFieldRef() ? Max.maxOf(this.fieldReference) : Max.maxOf(this.expression);
        }

        public Max max(int numberOfResults) {
            return this.max().limit(numberOfResults);
        }

        public Min min() {
            return this.usesFieldRef() ? Min.minOf(this.fieldReference) : Min.minOf(this.expression);
        }

        public Min min(int numberOfResults) {
            return this.min().limit(numberOfResults);
        }

        public StdDevPop stdDevPop() {
            return this.usesFieldRef() ? StdDevPop.stdDevPopOf(this.fieldReference) : StdDevPop.stdDevPopOf(this.expression);
        }

        public StdDevSamp stdDevSamp() {
            return this.usesFieldRef() ? StdDevSamp.stdDevSampOf(this.fieldReference) : StdDevSamp.stdDevSampOf(this.expression);
        }

        public CovariancePop covariancePop(String fieldReference) {
            return this.covariancePop().and(fieldReference);
        }

        public CovariancePop covariancePop(AggregationExpression expression) {
            return this.covariancePop().and(expression);
        }

        private CovariancePop covariancePop() {
            return this.usesFieldRef() ? CovariancePop.covariancePopOf(this.fieldReference) : CovariancePop.covariancePopOf(this.expression);
        }

        public CovarianceSamp covarianceSamp(String fieldReference) {
            return this.covarianceSamp().and(fieldReference);
        }

        public CovarianceSamp covarianceSamp(AggregationExpression expression) {
            return this.covarianceSamp().and(expression);
        }

        private CovarianceSamp covarianceSamp() {
            return this.usesFieldRef() ? CovarianceSamp.covarianceSampOf(this.fieldReference) : CovarianceSamp.covarianceSampOf(this.expression);
        }

        public ExpMovingAvgBuilder expMovingAvg() {
            final ExpMovingAvg expMovingAvg = this.usesFieldRef() ? ExpMovingAvg.expMovingAvgOf(this.fieldReference) : ExpMovingAvg.expMovingAvgOf(this.expression);
            return new ExpMovingAvgBuilder(){

                @Override
                public ExpMovingAvg historicalDocuments(int numberOfHistoricalDocuments) {
                    return expMovingAvg.n(numberOfHistoricalDocuments);
                }

                @Override
                public ExpMovingAvg alpha(double exponentialDecayValue) {
                    return expMovingAvg.alpha(exponentialDecayValue);
                }
            };
        }

        public Percentile percentile(Double ... percentages) {
            Percentile percentile = this.usesFieldRef() ? Percentile.percentileOf(this.fieldReference) : Percentile.percentileOf(this.expression);
            return percentile.percentages(percentages);
        }

        public Median median() {
            return this.usesFieldRef() ? Median.medianOf(this.fieldReference) : Median.medianOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }

    public static class Median
    extends AbstractAggregationExpression {
        private Median(Object value) {
            super(value);
        }

        public static Median medianOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("input", Fields.field(fieldReference));
            fields.put("method", "approximate");
            return new Median(fields);
        }

        public static Median medianOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("input", expression);
            fields.put("method", "approximate");
            return new Median(fields);
        }

        public Median and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Median(this.appendTo("input", Fields.field(fieldReference)));
        }

        public Median and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Median(this.appendTo("input", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$median";
        }
    }

    public static class Percentile
    extends AbstractAggregationExpression {
        private Percentile(Object value) {
            super(value);
        }

        public static Percentile percentileOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("input", Fields.field(fieldReference));
            fields.put("method", "approximate");
            return new Percentile(fields);
        }

        public static Percentile percentileOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("input", expression);
            fields.put("method", "approximate");
            return new Percentile(fields);
        }

        public Percentile percentages(Double ... percentages) {
            Assert.notEmpty((Object[])percentages, (String)"Percentages must not be null or empty");
            return new Percentile(this.append("p", Arrays.asList(percentages)));
        }

        public Percentile and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Percentile(this.appendTo("input", Fields.field(fieldReference)));
        }

        public Percentile and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Percentile(this.appendTo("input", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$percentile";
        }
    }

    public static class ExpMovingAvg
    extends AbstractAggregationExpression {
        private ExpMovingAvg(Object value) {
            super(value);
        }

        public static ExpMovingAvg expMovingAvgOf(String fieldReference) {
            return new ExpMovingAvg(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static ExpMovingAvg expMovingAvgOf(AggregationExpression expression) {
            return new ExpMovingAvg(Collections.singletonMap("input", expression));
        }

        public ExpMovingAvg n(int numberOfHistoricalDocuments) {
            return new ExpMovingAvg(this.append("N", numberOfHistoricalDocuments));
        }

        public ExpMovingAvg alpha(double exponentialDecayValue) {
            return new ExpMovingAvg(this.append("alpha", exponentialDecayValue));
        }

        @Override
        protected String getMongoMethod() {
            return "$expMovingAvg";
        }
    }

    public static class CovarianceSamp
    extends AbstractAggregationExpression {
        private CovarianceSamp(Object value) {
            super(value);
        }

        public static CovarianceSamp covarianceSampOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new CovarianceSamp(CovarianceSamp.asFields(fieldReference));
        }

        public static CovarianceSamp covarianceSampOf(AggregationExpression expression) {
            return new CovarianceSamp(Collections.singletonList(expression));
        }

        public CovarianceSamp and(String fieldReference) {
            return new CovarianceSamp(this.append(CovarianceSamp.asFields(fieldReference)));
        }

        public CovarianceSamp and(AggregationExpression expression) {
            return new CovarianceSamp(this.append(expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$covarianceSamp";
        }
    }

    public static class CovariancePop
    extends AbstractAggregationExpression {
        private CovariancePop(Object value) {
            super(value);
        }

        public static CovariancePop covariancePopOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new CovariancePop(CovariancePop.asFields(fieldReference));
        }

        public static CovariancePop covariancePopOf(AggregationExpression expression) {
            return new CovariancePop(Collections.singletonList(expression));
        }

        public CovariancePop and(String fieldReference) {
            return new CovariancePop(this.append(CovariancePop.asFields(fieldReference)));
        }

        public CovariancePop and(AggregationExpression expression) {
            return new CovariancePop(this.append(expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$covariancePop";
        }
    }

    public static class StdDevSamp
    extends AbstractAggregationExpression {
        private StdDevSamp(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$stdDevSamp";
        }

        public static StdDevSamp stdDevSampOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new StdDevSamp(StdDevSamp.asFields(fieldReference));
        }

        public static StdDevSamp stdDevSampOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new StdDevSamp(Collections.singletonList(expression));
        }

        public StdDevSamp and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new StdDevSamp(this.append(Fields.field(fieldReference)));
        }

        public StdDevSamp and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new StdDevSamp(this.append(expression));
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            List list;
            if (value instanceof List && (list = (List)value).size() == 1) {
                return super.toDocument(list.iterator().next(), context);
            }
            return super.toDocument(value, context);
        }
    }

    public static class StdDevPop
    extends AbstractAggregationExpression {
        private StdDevPop(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$stdDevPop";
        }

        public static StdDevPop stdDevPopOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new StdDevPop(StdDevPop.asFields(fieldReference));
        }

        public static StdDevPop stdDevPopOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new StdDevPop(Collections.singletonList(expression));
        }

        public StdDevPop and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new StdDevPop(this.append(Fields.field(fieldReference)));
        }

        public StdDevPop and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new StdDevPop(this.append(expression));
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            List list;
            if (value instanceof List && (list = (List)value).size() == 1) {
                return super.toDocument(list.iterator().next(), context);
            }
            return super.toDocument(value, context);
        }
    }

    public static class Min
    extends AbstractAggregationExpression {
        private Min(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return this.contains("n") ? "$minN" : "$min";
        }

        public static Min minOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Min(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static Min minOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Min(Collections.singletonMap("input", expression));
        }

        public Min and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Min(this.appendTo("input", Fields.field(fieldReference)));
        }

        public Min and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Min(this.appendTo("input", expression));
        }

        public Min limit(int numberOfResults) {
            return new Min(this.append("n", numberOfResults));
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            if (this.get("n") == null) {
                return this.toDocument(this.get("input"), context);
            }
            return super.toDocument(context);
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            List list;
            if (value instanceof List && (list = (List)value).size() == 1) {
                return super.toDocument(list.iterator().next(), context);
            }
            return super.toDocument(value, context);
        }
    }

    public static class Max
    extends AbstractAggregationExpression {
        private Max(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return this.contains("n") ? "$maxN" : "$max";
        }

        public static Max maxOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Max(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static Max maxOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Max(Collections.singletonMap("input", expression));
        }

        public Max and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Max(this.appendTo("input", Fields.field(fieldReference)));
        }

        public Max and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Max(this.appendTo("input", expression));
        }

        public Max limit(int numberOfResults) {
            return new Max(this.append("n", numberOfResults));
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            if (this.get("n") == null) {
                return this.toDocument(this.get("input"), context);
            }
            return super.toDocument(context);
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            List list;
            if (value instanceof List && (list = (List)value).size() == 1) {
                return super.toDocument(list.iterator().next(), context);
            }
            return super.toDocument(value, context);
        }
    }

    public static class Avg
    extends AbstractAggregationExpression {
        private Avg(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$avg";
        }

        public static Avg avgOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Avg(Avg.asFields(fieldReference));
        }

        public static Avg avgOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Avg(Collections.singletonList(expression));
        }

        public Avg and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Avg(this.append(Fields.field(fieldReference)));
        }

        public Avg and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Avg(this.append(expression));
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            List list;
            if (value instanceof List && (list = (List)value).size() == 1) {
                return super.toDocument(list.iterator().next(), context);
            }
            return super.toDocument(value, context);
        }
    }

    public static class Sum
    extends AbstractAggregationExpression {
        private Sum(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$sum";
        }

        public static Sum sumOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Sum(Sum.asFields(fieldReference));
        }

        public static Sum sumOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Sum(Collections.singletonList(expression));
        }

        public Sum and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null");
            return new Sum(this.append(Fields.field(fieldReference)));
        }

        public Sum and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            return new Sum(this.append(expression));
        }

        public Sum and(Number value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new Sum(this.append(value));
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            List list;
            if (value instanceof List && (list = (List)value).size() == 1) {
                return super.toDocument(list.iterator().next(), context);
            }
            return super.toDocument(value, context);
        }
    }

    public static interface ExpMovingAvgBuilder {
        public ExpMovingAvg historicalDocuments(int var1);

        public ExpMovingAvg alpha(double var1);
    }
}

