/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.ReadPreference;
import java.time.Duration;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.bson.Document;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

abstract class AggregationUtils {
    private AggregationUtils() {
    }

    static AggregationOptions.Builder applyCollation(AggregationOptions.Builder builder, @Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, parameters, expressionParser, evaluationContextProvider);
        return collation == null ? builder : builder.collation(collation);
    }

    static AggregationOptions.Builder applyMeta(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        Meta meta = queryMethod.getQueryMetaAttributes();
        if (meta.hasComment()) {
            builder.comment(meta.getComment());
        }
        if (meta.getCursorBatchSize() != null) {
            builder.cursorBatchSize(meta.getCursorBatchSize());
        }
        if (meta.hasMaxTime()) {
            builder.maxTime(Duration.ofMillis(meta.getRequiredMaxTimeMsec()));
        }
        if (meta.getAllowDiskUse() != null) {
            builder.allowDiskUse(meta.getAllowDiskUse());
        }
        return builder;
    }

    static AggregationOptions.Builder applyHint(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        if (!queryMethod.hasAnnotatedHint()) {
            return builder;
        }
        return builder.hint(queryMethod.getAnnotatedHint());
    }

    static AggregationOptions.Builder applyReadPreference(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        if (!queryMethod.hasAnnotatedReadPreference()) {
            return builder;
        }
        return builder.readPreference(ReadPreference.valueOf((String)queryMethod.getAnnotatedReadPreference()));
    }

    static void appendSortIfPresent(AggregationPipeline aggregationPipeline, ConvertingParameterAccessor accessor, Class<?> targetType) {
        if (accessor.getSort().isUnsorted()) {
            return;
        }
        aggregationPipeline.add(ctx -> {
            Document sort = new Document();
            for (Sort.Order order : accessor.getSort()) {
                sort.append(order.getProperty(), (Object)(order.isAscending() ? 1 : -1));
            }
            return ctx.getMappedObject(new Document("$sort", (Object)sort), targetType);
        });
    }

    static void appendLimitAndOffsetIfPresent(AggregationPipeline aggregationPipeline, ConvertingParameterAccessor accessor) {
        AggregationUtils.appendLimitAndOffsetIfPresent(aggregationPipeline, accessor, LongUnaryOperator.identity(), IntUnaryOperator.identity());
    }

    static void appendLimitAndOffsetIfPresent(AggregationPipeline aggregationPipeline, ConvertingParameterAccessor accessor, LongUnaryOperator offsetOperator, IntUnaryOperator limitOperator) {
        Pageable pageable = accessor.getPageable();
        if (pageable.isUnpaged()) {
            return;
        }
        if (pageable.getOffset() > 0L) {
            aggregationPipeline.add(Aggregation.skip(offsetOperator.applyAsLong(pageable.getOffset())));
        }
        aggregationPipeline.add(Aggregation.limit(limitOperator.applyAsInt(pageable.getPageSize())));
    }

    @Nullable
    static <T> T extractSimpleTypeResult(@Nullable Document source, Class<T> targetType, MongoConverter converter) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        if (source.size() == 1) {
            return AggregationUtils.getPotentiallyConvertedSimpleTypeValue(converter, source.values().iterator().next(), targetType);
        }
        Document intermediate = new Document((Map)source);
        intermediate.remove((Object)FieldName.ID.name());
        if (intermediate.size() == 1) {
            return AggregationUtils.getPotentiallyConvertedSimpleTypeValue(converter, intermediate.values().iterator().next(), targetType);
        }
        for (Map.Entry entry : intermediate.entrySet()) {
            if (entry == null || !ClassUtils.isAssignable(targetType, entry.getValue().getClass())) continue;
            return targetType.cast(entry.getValue());
        }
        throw new IllegalArgumentException(String.format("o_O no entry of type %s found in %s.", targetType.getSimpleName(), source.toJson()));
    }

    @Nullable
    private static <T> T getPotentiallyConvertedSimpleTypeValue(MongoConverter converter, @Nullable Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(targetType, (Object)value)) {
            return (T)value;
        }
        return (T)converter.getConversionService().convert(value, targetType);
    }
}

