/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PaginatedResponse<T> {
    public static final PaginatedResponse EMPTY = new PaginatedResponse(Collections.emptyList());
    private Map<String, Object> meta;
    private List<T> data;
    private List<Error> errors;

    public PaginatedResponse() {
        this(new ArrayList(), new HashMap<String, Object>());
    }

    private PaginatedResponse(List<T> list) {
        this(list, null);
    }

    private PaginatedResponse(List<T> list, Map<String, Object> map) {
        this.data = list;
        this.meta = map;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public List<T> getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public PaginatedResponse<T> setMeta(Map<String, Object> map) {
        this.meta = map;
        return this;
    }

    public PaginatedResponse<T> setData(List<T> list) {
        this.data = list;
        return this;
    }

    public PaginatedResponse<T> setErrors(List<Error> list) {
        this.errors = list;
        return this;
    }

    public static <T> PaginatedResponse<T> of(List<T> list) {
        return new PaginatedResponse<T>(list);
    }

    @SafeVarargs
    public static <T> PaginatedResponse<T> of(T ... TArray) {
        return new PaginatedResponse<T>(ImmutableList.copyOf((Object[])TArray));
    }

    public static class Error {
        private final String id;
        private final int httpCode;
        private final String description;

        public Error(String string, int n2, String string2) {
            this.id = string;
            this.httpCode = n2;
            this.description = string2;
        }

        public String getId() {
            return this.id;
        }

        public int getHttpCode() {
            return this.httpCode;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

