/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wan.loadbalancing.sla;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.wan.loadbalancing.sla.ImmutableWanSlaDto;
import com.ubnt.model.api.wan.loadbalancing.sla.WanMonitorDto;
import com.ubnt.return.F;
import com.ubnt.service.config.ubios.wanfailover.sla.OOoO;
import com.ubnt.service.config.ubios.wanfailover.sla.WanSlaDocument;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableWanSlaDto.Builder.class)
@Value.Immutable(copy=true)
@F
public interface WanSlaDto {
    @JsonProperty(value="_id")
    @Nullable
    public String id();

    @JsonProperty(value="name")
    public String name();

    @JsonProperty(value="monitor_health_type")
    public OOoO monitorHealthType();

    @JsonProperty(value="monitor_down_threshold")
    public Optional<@Min(value=1L) @Max(value=10L) Integer> monitorDownThreshold();

    @JsonProperty(value="monitors")
    public List<WanMonitorDto> monitors();

    public static ImmutableWanSlaDto.Builder builder() {
        return ImmutableWanSlaDto.builder();
    }

    public static WanSlaDto fromDocument(WanSlaDocument wanSlaDocument) {
        return ImmutableWanSlaDto.builder().id(wanSlaDocument.getId()).name(wanSlaDocument.getName()).monitorHealthType(wanSlaDocument.getMonitorHealthType()).monitorDownThreshold(wanSlaDocument.getMonitorDownThreshold()).monitors(WanMonitorDto.fromDocument(wanSlaDocument.getMonitors())).build();
    }

    default public WanSlaDocument toDocument(String string) {
        return WanSlaDocument.builder().\u00d300000(this.id()).\u00d800000(string).\u00d600000(this.name()).class(this.monitorHealthType()).\u00d200000(this.monitorDownThreshold().orElse(null)).super(WanMonitorDto.toDocument(this.monitors())).\u00d400000();
    }

    public static WanSlaDto withId(WanSlaDto wanSlaDto, String string) {
        return ImmutableWanSlaDto.copyOf(wanSlaDto).withId(string);
    }
}

