/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.Device;
import com.ubnt.service.trace.api.device.DeviceStateTransitionEvent;
import com.ubnt.service.trace.api.device.TraceDeviceStats;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceStateTransitionReport {
    @JsonProperty(value="eventTimestampMillis")
    private long eventTimestampMillis;
    @JsonProperty(value="previousState")
    private String previousState;
    @JsonProperty(value="newState")
    private String newState;
    @JsonProperty(value="deviceStats")
    private TraceDeviceStats deviceStats;
    @JsonProperty(value="transitionReasonType")
    private String transitionReasonType;
    @JsonProperty(value="transitionReasonDetails")
    private String transitionReasonDetails;
    @JsonProperty(value="newUpgradeState")
    private String newUpgradeState;
    @JsonProperty(value="previousUpgradeState")
    private String previousUpgradeState;

    public long getEventTimestampMillis() {
        return this.eventTimestampMillis;
    }

    public String getPreviousState() {
        return this.previousState;
    }

    public String getNewState() {
        return this.newState;
    }

    public TraceDeviceStats getDeviceStats() {
        return this.deviceStats;
    }

    public String getTransitionReasonType() {
        return this.transitionReasonType;
    }

    public String getTransitionReasonDetails() {
        return this.transitionReasonDetails;
    }

    public String getNewUpgradeState() {
        return this.newUpgradeState;
    }

    public String getPreviousUpgradeState() {
        return this.previousUpgradeState;
    }

    public static DeviceStateTransitionReport of(DeviceStateTransitionEvent deviceStateTransitionEvent) {
        Device device = deviceStateTransitionEvent.device();
        DeviceStateTransitionReport deviceStateTransitionReport = new DeviceStateTransitionReport();
        deviceStateTransitionReport.deviceStats = TraceDeviceStats.of(device);
        deviceStateTransitionReport.eventTimestampMillis = deviceStateTransitionEvent.eventTimestampMillis();
        deviceStateTransitionReport.previousState = Device.getStateName(deviceStateTransitionEvent.previousState());
        deviceStateTransitionReport.newState = Device.getStateName(deviceStateTransitionEvent.newState());
        deviceStateTransitionReport.transitionReasonType = deviceStateTransitionEvent.reason().name();
        deviceStateTransitionReport.transitionReasonDetails = deviceStateTransitionEvent.reason().formatReason(device).orElse(null);
        deviceStateTransitionReport.previousUpgradeState = deviceStateTransitionEvent.previousUpgradeState().flatMap(Device.UpgradeState::fromOrdinal).map(Enum::name).orElse(null);
        deviceStateTransitionReport.newUpgradeState = deviceStateTransitionEvent.newUpgradeState().flatMap(Device.UpgradeState::fromOrdinal).map(Enum::name).orElse(null);
        return deviceStateTransitionReport;
    }
}

