// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/retail/v2alpha/branch_service.proto

package retailpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for
// [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches]
// method.
type ListBranchesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent catalog resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The view to apply to the returned
	// [Branch][google.cloud.retail.v2alpha.Branch]. Defaults to
	// [Branch.BranchView.BASIC] if unspecified.
	// See documentation of fields of [Branch][google.cloud.retail.v2alpha.Branch]
	// to find what fields are excluded from BASIC view.
	View BranchView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.retail.v2alpha.BranchView" json:"view,omitempty"`
}

func (x *ListBranchesRequest) Reset() {
	*x = ListBranchesRequest{}
	mi := &file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBranchesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBranchesRequest) ProtoMessage() {}

func (x *ListBranchesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBranchesRequest.ProtoReflect.Descriptor instead.
func (*ListBranchesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_branch_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListBranchesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBranchesRequest) GetView() BranchView {
	if x != nil {
		return x.View
	}
	return BranchView_BRANCH_VIEW_UNSPECIFIED
}

// Response for
// [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches]
// method.
type ListBranchesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Branches.
	Branches []*Branch `protobuf:"bytes,1,rep,name=branches,proto3" json:"branches,omitempty"`
}

func (x *ListBranchesResponse) Reset() {
	*x = ListBranchesResponse{}
	mi := &file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBranchesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBranchesResponse) ProtoMessage() {}

func (x *ListBranchesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBranchesResponse.ProtoReflect.Descriptor instead.
func (*ListBranchesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_branch_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListBranchesResponse) GetBranches() []*Branch {
	if x != nil {
		return x.Branches
	}
	return nil
}

// Request for
// [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
// method.
type GetBranchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the branch to retrieve.
	// Format:
	// `projects/*/locations/global/catalogs/default_catalog/branches/some_branch_id`.
	//
	// "default_branch" can be used as a special branch_id, it returns the
	// default branch that has been set for the catalog.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The view to apply to the returned
	// [Branch][google.cloud.retail.v2alpha.Branch]. Defaults to
	// [Branch.BranchView.BASIC] if unspecified.
	// See documentation of fields of [Branch][google.cloud.retail.v2alpha.Branch]
	// to find what fields are excluded from BASIC view.
	View BranchView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.retail.v2alpha.BranchView" json:"view,omitempty"`
}

func (x *GetBranchRequest) Reset() {
	*x = GetBranchRequest{}
	mi := &file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBranchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBranchRequest) ProtoMessage() {}

func (x *GetBranchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBranchRequest.ProtoReflect.Descriptor instead.
func (*GetBranchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_branch_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetBranchRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetBranchRequest) GetView() BranchView {
	if x != nil {
		return x.View
	}
	return BranchView_BRANCH_VIEW_UNSPECIFIED
}

var File_google_cloud_retail_v2alpha_branch_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2alpha_branch_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x62, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x91, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x22, 0x57, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52,
	0x08, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x22, 0x89, 0x01, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x32, 0xce, 0x03, 0x0a, 0x0d, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc2, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c,
	0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x12, 0xac, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x22, 0x4b,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f,
	0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x49, 0xca, 0x41, 0x15,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd6, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x12, 0x42, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62,
	0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41,
	0x49, 0x4c, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2alpha_branch_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2alpha_branch_service_proto_rawDescData = file_google_cloud_retail_v2alpha_branch_service_proto_rawDesc
)

func file_google_cloud_retail_v2alpha_branch_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2alpha_branch_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2alpha_branch_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2alpha_branch_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2alpha_branch_service_proto_rawDescData
}

var file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_retail_v2alpha_branch_service_proto_goTypes = []any{
	(*ListBranchesRequest)(nil),  // 0: google.cloud.retail.v2alpha.ListBranchesRequest
	(*ListBranchesResponse)(nil), // 1: google.cloud.retail.v2alpha.ListBranchesResponse
	(*GetBranchRequest)(nil),     // 2: google.cloud.retail.v2alpha.GetBranchRequest
	(BranchView)(0),              // 3: google.cloud.retail.v2alpha.BranchView
	(*Branch)(nil),               // 4: google.cloud.retail.v2alpha.Branch
}
var file_google_cloud_retail_v2alpha_branch_service_proto_depIdxs = []int32{
	3, // 0: google.cloud.retail.v2alpha.ListBranchesRequest.view:type_name -> google.cloud.retail.v2alpha.BranchView
	4, // 1: google.cloud.retail.v2alpha.ListBranchesResponse.branches:type_name -> google.cloud.retail.v2alpha.Branch
	3, // 2: google.cloud.retail.v2alpha.GetBranchRequest.view:type_name -> google.cloud.retail.v2alpha.BranchView
	0, // 3: google.cloud.retail.v2alpha.BranchService.ListBranches:input_type -> google.cloud.retail.v2alpha.ListBranchesRequest
	2, // 4: google.cloud.retail.v2alpha.BranchService.GetBranch:input_type -> google.cloud.retail.v2alpha.GetBranchRequest
	1, // 5: google.cloud.retail.v2alpha.BranchService.ListBranches:output_type -> google.cloud.retail.v2alpha.ListBranchesResponse
	4, // 6: google.cloud.retail.v2alpha.BranchService.GetBranch:output_type -> google.cloud.retail.v2alpha.Branch
	5, // [5:7] is the sub-list for method output_type
	3, // [3:5] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2alpha_branch_service_proto_init() }
func file_google_cloud_retail_v2alpha_branch_service_proto_init() {
	if File_google_cloud_retail_v2alpha_branch_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2alpha_branch_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2alpha_branch_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2alpha_branch_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2alpha_branch_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2alpha_branch_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2alpha_branch_service_proto = out.File
	file_google_cloud_retail_v2alpha_branch_service_proto_rawDesc = nil
	file_google_cloud_retail_v2alpha_branch_service_proto_goTypes = nil
	file_google_cloud_retail_v2alpha_branch_service_proto_depIdxs = nil
}
