// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2beta/catalog_service.proto

package retailpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CatalogService_ListCatalogs_FullMethodName                 = "/google.cloud.retail.v2beta.CatalogService/ListCatalogs"
	CatalogService_UpdateCatalog_FullMethodName                = "/google.cloud.retail.v2beta.CatalogService/UpdateCatalog"
	CatalogService_SetDefaultBranch_FullMethodName             = "/google.cloud.retail.v2beta.CatalogService/SetDefaultBranch"
	CatalogService_GetDefaultBranch_FullMethodName             = "/google.cloud.retail.v2beta.CatalogService/GetDefaultBranch"
	CatalogService_GetCompletionConfig_FullMethodName          = "/google.cloud.retail.v2beta.CatalogService/GetCompletionConfig"
	CatalogService_UpdateCompletionConfig_FullMethodName       = "/google.cloud.retail.v2beta.CatalogService/UpdateCompletionConfig"
	CatalogService_GetAttributesConfig_FullMethodName          = "/google.cloud.retail.v2beta.CatalogService/GetAttributesConfig"
	CatalogService_UpdateAttributesConfig_FullMethodName       = "/google.cloud.retail.v2beta.CatalogService/UpdateAttributesConfig"
	CatalogService_AddCatalogAttribute_FullMethodName          = "/google.cloud.retail.v2beta.CatalogService/AddCatalogAttribute"
	CatalogService_RemoveCatalogAttribute_FullMethodName       = "/google.cloud.retail.v2beta.CatalogService/RemoveCatalogAttribute"
	CatalogService_BatchRemoveCatalogAttributes_FullMethodName = "/google.cloud.retail.v2beta.CatalogService/BatchRemoveCatalogAttributes"
	CatalogService_ReplaceCatalogAttribute_FullMethodName      = "/google.cloud.retail.v2beta.CatalogService/ReplaceCatalogAttribute"
)

// CatalogServiceClient is the client API for CatalogService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CatalogServiceClient interface {
	// Lists all the [Catalog][google.cloud.retail.v2beta.Catalog]s associated
	// with the project.
	ListCatalogs(ctx context.Context, in *ListCatalogsRequest, opts ...grpc.CallOption) (*ListCatalogsResponse, error)
	// Updates the [Catalog][google.cloud.retail.v2beta.Catalog]s.
	UpdateCatalog(ctx context.Context, in *UpdateCatalogRequest, opts ...grpc.CallOption) (*Catalog, error)
	// Set a specified branch id as default branch. API methods such as
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search],
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct],
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
	// will treat requests using "default_branch" to the actual branch id set as
	// default.
	//
	// For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as
	// default, setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent
	// to setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/1`.
	//
	// Using multiple branches can be useful when developers would like
	// to have a staging branch to test and verify for future usage. When it
	// becomes ready, developers switch on the staging branch using this API
	// while keeping using
	// `projects/*/locations/*/catalogs/*/branches/default_branch` as
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// route the traffic to this staging branch.
	//
	// CAUTION: If you have live predict/search traffic, switching the default
	// branch could potentially cause outages if the ID space of the new branch
	// is very different from the old one.
	//
	// More specifically:
	//
	//   - PredictionService will only return product IDs from branch {newBranch}.
	//   - SearchService will only return product IDs from branch {newBranch}
	//     (if branch is not explicitly set).
	//   - UserEventService will only join events with products from branch
	//     {newBranch}.
	SetDefaultBranch(ctx context.Context, in *SetDefaultBranchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get which branch is currently default branch set by
	// [CatalogService.SetDefaultBranch][google.cloud.retail.v2beta.CatalogService.SetDefaultBranch]
	// method under a specified parent catalog.
	GetDefaultBranch(ctx context.Context, in *GetDefaultBranchRequest, opts ...grpc.CallOption) (*GetDefaultBranchResponse, error)
	// Gets a [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig].
	GetCompletionConfig(ctx context.Context, in *GetCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error)
	// Updates the
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig]s.
	UpdateCompletionConfig(ctx context.Context, in *UpdateCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error)
	// Gets an [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	GetAttributesConfig(ctx context.Context, in *GetAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Updates the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// The catalog attributes in the request will be updated in the catalog, or
	// inserted if they do not exist. Existing catalog attributes not included in
	// the request will remain unchanged. Attributes that are assigned to
	// products, but do not exist at the catalog level, are always included in the
	// response. The product attribute is assigned default values for missing
	// catalog attribute fields, e.g., searchable and dynamic facetable options.
	UpdateAttributesConfig(ctx context.Context, in *UpdateAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Adds the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// add already exists, an ALREADY_EXISTS error is returned.
	AddCatalogAttribute(ctx context.Context, in *AddCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Removes the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// remove does not exist, a NOT_FOUND error is returned.
	RemoveCatalogAttribute(ctx context.Context, in *RemoveCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
	// Removes all specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute]s from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	BatchRemoveCatalogAttributes(ctx context.Context, in *BatchRemoveCatalogAttributesRequest, opts ...grpc.CallOption) (*BatchRemoveCatalogAttributesResponse, error)
	// Replaces the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] in the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig] by updating
	// the catalog attribute with the same
	// [CatalogAttribute.key][google.cloud.retail.v2beta.CatalogAttribute.key].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// replace does not exist, a NOT_FOUND error is returned.
	ReplaceCatalogAttribute(ctx context.Context, in *ReplaceCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error)
}

type catalogServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCatalogServiceClient(cc grpc.ClientConnInterface) CatalogServiceClient {
	return &catalogServiceClient{cc}
}

func (c *catalogServiceClient) ListCatalogs(ctx context.Context, in *ListCatalogsRequest, opts ...grpc.CallOption) (*ListCatalogsResponse, error) {
	out := new(ListCatalogsResponse)
	err := c.cc.Invoke(ctx, CatalogService_ListCatalogs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateCatalog(ctx context.Context, in *UpdateCatalogRequest, opts ...grpc.CallOption) (*Catalog, error) {
	out := new(Catalog)
	err := c.cc.Invoke(ctx, CatalogService_UpdateCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) SetDefaultBranch(ctx context.Context, in *SetDefaultBranchRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CatalogService_SetDefaultBranch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetDefaultBranch(ctx context.Context, in *GetDefaultBranchRequest, opts ...grpc.CallOption) (*GetDefaultBranchResponse, error) {
	out := new(GetDefaultBranchResponse)
	err := c.cc.Invoke(ctx, CatalogService_GetDefaultBranch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetCompletionConfig(ctx context.Context, in *GetCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error) {
	out := new(CompletionConfig)
	err := c.cc.Invoke(ctx, CatalogService_GetCompletionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateCompletionConfig(ctx context.Context, in *UpdateCompletionConfigRequest, opts ...grpc.CallOption) (*CompletionConfig, error) {
	out := new(CompletionConfig)
	err := c.cc.Invoke(ctx, CatalogService_UpdateCompletionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) GetAttributesConfig(ctx context.Context, in *GetAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, CatalogService_GetAttributesConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) UpdateAttributesConfig(ctx context.Context, in *UpdateAttributesConfigRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, CatalogService_UpdateAttributesConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) AddCatalogAttribute(ctx context.Context, in *AddCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, CatalogService_AddCatalogAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) RemoveCatalogAttribute(ctx context.Context, in *RemoveCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, CatalogService_RemoveCatalogAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) BatchRemoveCatalogAttributes(ctx context.Context, in *BatchRemoveCatalogAttributesRequest, opts ...grpc.CallOption) (*BatchRemoveCatalogAttributesResponse, error) {
	out := new(BatchRemoveCatalogAttributesResponse)
	err := c.cc.Invoke(ctx, CatalogService_BatchRemoveCatalogAttributes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *catalogServiceClient) ReplaceCatalogAttribute(ctx context.Context, in *ReplaceCatalogAttributeRequest, opts ...grpc.CallOption) (*AttributesConfig, error) {
	out := new(AttributesConfig)
	err := c.cc.Invoke(ctx, CatalogService_ReplaceCatalogAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CatalogServiceServer is the server API for CatalogService service.
// All implementations should embed UnimplementedCatalogServiceServer
// for forward compatibility
type CatalogServiceServer interface {
	// Lists all the [Catalog][google.cloud.retail.v2beta.Catalog]s associated
	// with the project.
	ListCatalogs(context.Context, *ListCatalogsRequest) (*ListCatalogsResponse, error)
	// Updates the [Catalog][google.cloud.retail.v2beta.Catalog]s.
	UpdateCatalog(context.Context, *UpdateCatalogRequest) (*Catalog, error)
	// Set a specified branch id as default branch. API methods such as
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search],
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct],
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts]
	// will treat requests using "default_branch" to the actual branch id set as
	// default.
	//
	// For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as
	// default, setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent
	// to setting
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// `projects/*/locations/*/catalogs/*/branches/1`.
	//
	// Using multiple branches can be useful when developers would like
	// to have a staging branch to test and verify for future usage. When it
	// becomes ready, developers switch on the staging branch using this API
	// while keeping using
	// `projects/*/locations/*/catalogs/*/branches/default_branch` as
	// [SearchRequest.branch][google.cloud.retail.v2beta.SearchRequest.branch] to
	// route the traffic to this staging branch.
	//
	// CAUTION: If you have live predict/search traffic, switching the default
	// branch could potentially cause outages if the ID space of the new branch
	// is very different from the old one.
	//
	// More specifically:
	//
	//   - PredictionService will only return product IDs from branch {newBranch}.
	//   - SearchService will only return product IDs from branch {newBranch}
	//     (if branch is not explicitly set).
	//   - UserEventService will only join events with products from branch
	//     {newBranch}.
	SetDefaultBranch(context.Context, *SetDefaultBranchRequest) (*emptypb.Empty, error)
	// Get which branch is currently default branch set by
	// [CatalogService.SetDefaultBranch][google.cloud.retail.v2beta.CatalogService.SetDefaultBranch]
	// method under a specified parent catalog.
	GetDefaultBranch(context.Context, *GetDefaultBranchRequest) (*GetDefaultBranchResponse, error)
	// Gets a [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig].
	GetCompletionConfig(context.Context, *GetCompletionConfigRequest) (*CompletionConfig, error)
	// Updates the
	// [CompletionConfig][google.cloud.retail.v2beta.CompletionConfig]s.
	UpdateCompletionConfig(context.Context, *UpdateCompletionConfigRequest) (*CompletionConfig, error)
	// Gets an [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	GetAttributesConfig(context.Context, *GetAttributesConfigRequest) (*AttributesConfig, error)
	// Updates the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// The catalog attributes in the request will be updated in the catalog, or
	// inserted if they do not exist. Existing catalog attributes not included in
	// the request will remain unchanged. Attributes that are assigned to
	// products, but do not exist at the catalog level, are always included in the
	// response. The product attribute is assigned default values for missing
	// catalog attribute fields, e.g., searchable and dynamic facetable options.
	UpdateAttributesConfig(context.Context, *UpdateAttributesConfigRequest) (*AttributesConfig, error)
	// Adds the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// add already exists, an ALREADY_EXISTS error is returned.
	AddCatalogAttribute(context.Context, *AddCatalogAttributeRequest) (*AttributesConfig, error)
	// Removes the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// remove does not exist, a NOT_FOUND error is returned.
	RemoveCatalogAttribute(context.Context, *RemoveCatalogAttributeRequest) (*AttributesConfig, error)
	// Removes all specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute]s from the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig].
	BatchRemoveCatalogAttributes(context.Context, *BatchRemoveCatalogAttributesRequest) (*BatchRemoveCatalogAttributesResponse, error)
	// Replaces the specified
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] in the
	// [AttributesConfig][google.cloud.retail.v2beta.AttributesConfig] by updating
	// the catalog attribute with the same
	// [CatalogAttribute.key][google.cloud.retail.v2beta.CatalogAttribute.key].
	//
	// If the [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] to
	// replace does not exist, a NOT_FOUND error is returned.
	ReplaceCatalogAttribute(context.Context, *ReplaceCatalogAttributeRequest) (*AttributesConfig, error)
}

// UnimplementedCatalogServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCatalogServiceServer struct {
}

func (UnimplementedCatalogServiceServer) ListCatalogs(context.Context, *ListCatalogsRequest) (*ListCatalogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCatalogs not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateCatalog(context.Context, *UpdateCatalogRequest) (*Catalog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCatalog not implemented")
}
func (UnimplementedCatalogServiceServer) SetDefaultBranch(context.Context, *SetDefaultBranchRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultBranch not implemented")
}
func (UnimplementedCatalogServiceServer) GetDefaultBranch(context.Context, *GetDefaultBranchRequest) (*GetDefaultBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultBranch not implemented")
}
func (UnimplementedCatalogServiceServer) GetCompletionConfig(context.Context, *GetCompletionConfigRequest) (*CompletionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCompletionConfig not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateCompletionConfig(context.Context, *UpdateCompletionConfigRequest) (*CompletionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCompletionConfig not implemented")
}
func (UnimplementedCatalogServiceServer) GetAttributesConfig(context.Context, *GetAttributesConfigRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttributesConfig not implemented")
}
func (UnimplementedCatalogServiceServer) UpdateAttributesConfig(context.Context, *UpdateAttributesConfigRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttributesConfig not implemented")
}
func (UnimplementedCatalogServiceServer) AddCatalogAttribute(context.Context, *AddCatalogAttributeRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddCatalogAttribute not implemented")
}
func (UnimplementedCatalogServiceServer) RemoveCatalogAttribute(context.Context, *RemoveCatalogAttributeRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveCatalogAttribute not implemented")
}
func (UnimplementedCatalogServiceServer) BatchRemoveCatalogAttributes(context.Context, *BatchRemoveCatalogAttributesRequest) (*BatchRemoveCatalogAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRemoveCatalogAttributes not implemented")
}
func (UnimplementedCatalogServiceServer) ReplaceCatalogAttribute(context.Context, *ReplaceCatalogAttributeRequest) (*AttributesConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceCatalogAttribute not implemented")
}

// UnsafeCatalogServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CatalogServiceServer will
// result in compilation errors.
type UnsafeCatalogServiceServer interface {
	mustEmbedUnimplementedCatalogServiceServer()
}

func RegisterCatalogServiceServer(s grpc.ServiceRegistrar, srv CatalogServiceServer) {
	s.RegisterService(&CatalogService_ServiceDesc, srv)
}

func _CatalogService_ListCatalogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCatalogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ListCatalogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ListCatalogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ListCatalogs(ctx, req.(*ListCatalogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateCatalog(ctx, req.(*UpdateCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_SetDefaultBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).SetDefaultBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_SetDefaultBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).SetDefaultBranch(ctx, req.(*SetDefaultBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetDefaultBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetDefaultBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetDefaultBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetDefaultBranch(ctx, req.(*GetDefaultBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetCompletionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCompletionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetCompletionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetCompletionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetCompletionConfig(ctx, req.(*GetCompletionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateCompletionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCompletionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateCompletionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateCompletionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateCompletionConfig(ctx, req.(*UpdateCompletionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_GetAttributesConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttributesConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).GetAttributesConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_GetAttributesConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).GetAttributesConfig(ctx, req.(*GetAttributesConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_UpdateAttributesConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttributesConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).UpdateAttributesConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_UpdateAttributesConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).UpdateAttributesConfig(ctx, req.(*UpdateAttributesConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_AddCatalogAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddCatalogAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).AddCatalogAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_AddCatalogAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).AddCatalogAttribute(ctx, req.(*AddCatalogAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_RemoveCatalogAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveCatalogAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).RemoveCatalogAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_RemoveCatalogAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).RemoveCatalogAttribute(ctx, req.(*RemoveCatalogAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_BatchRemoveCatalogAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRemoveCatalogAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).BatchRemoveCatalogAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_BatchRemoveCatalogAttributes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).BatchRemoveCatalogAttributes(ctx, req.(*BatchRemoveCatalogAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CatalogService_ReplaceCatalogAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceCatalogAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CatalogServiceServer).ReplaceCatalogAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CatalogService_ReplaceCatalogAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CatalogServiceServer).ReplaceCatalogAttribute(ctx, req.(*ReplaceCatalogAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CatalogService_ServiceDesc is the grpc.ServiceDesc for CatalogService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CatalogService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2beta.CatalogService",
	HandlerType: (*CatalogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCatalogs",
			Handler:    _CatalogService_ListCatalogs_Handler,
		},
		{
			MethodName: "UpdateCatalog",
			Handler:    _CatalogService_UpdateCatalog_Handler,
		},
		{
			MethodName: "SetDefaultBranch",
			Handler:    _CatalogService_SetDefaultBranch_Handler,
		},
		{
			MethodName: "GetDefaultBranch",
			Handler:    _CatalogService_GetDefaultBranch_Handler,
		},
		{
			MethodName: "GetCompletionConfig",
			Handler:    _CatalogService_GetCompletionConfig_Handler,
		},
		{
			MethodName: "UpdateCompletionConfig",
			Handler:    _CatalogService_UpdateCompletionConfig_Handler,
		},
		{
			MethodName: "GetAttributesConfig",
			Handler:    _CatalogService_GetAttributesConfig_Handler,
		},
		{
			MethodName: "UpdateAttributesConfig",
			Handler:    _CatalogService_UpdateAttributesConfig_Handler,
		},
		{
			MethodName: "AddCatalogAttribute",
			Handler:    _CatalogService_AddCatalogAttribute_Handler,
		},
		{
			MethodName: "RemoveCatalogAttribute",
			Handler:    _CatalogService_RemoveCatalogAttribute_Handler,
		},
		{
			MethodName: "BatchRemoveCatalogAttributes",
			Handler:    _CatalogService_BatchRemoveCatalogAttributes_Handler,
		},
		{
			MethodName: "ReplaceCatalogAttribute",
			Handler:    _CatalogService_ReplaceCatalogAttribute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2beta/catalog_service.proto",
}
