// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/retail/v2/safety.proto

package retailpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Harm categories that will block the content.
type HarmCategory int32

const (
	// The harm category is unspecified.
	HarmCategory_HARM_CATEGORY_UNSPECIFIED HarmCategory = 0
	// The harm category is hate speech.
	HarmCategory_HARM_CATEGORY_HATE_SPEECH HarmCategory = 1
	// The harm category is dangerous content.
	HarmCategory_HARM_CATEGORY_DANGEROUS_CONTENT HarmCategory = 2
	// The harm category is harassment.
	HarmCategory_HARM_CATEGORY_HARASSMENT HarmCategory = 3
	// The harm category is sexually explicit content.
	HarmCategory_HARM_CATEGORY_SEXUALLY_EXPLICIT HarmCategory = 4
	// The harm category is civic integrity.
	HarmCategory_HARM_CATEGORY_CIVIC_INTEGRITY HarmCategory = 5
)

// Enum value maps for HarmCategory.
var (
	HarmCategory_name = map[int32]string{
		0: "HARM_CATEGORY_UNSPECIFIED",
		1: "HARM_CATEGORY_HATE_SPEECH",
		2: "HARM_CATEGORY_DANGEROUS_CONTENT",
		3: "HARM_CATEGORY_HARASSMENT",
		4: "HARM_CATEGORY_SEXUALLY_EXPLICIT",
		5: "HARM_CATEGORY_CIVIC_INTEGRITY",
	}
	HarmCategory_value = map[string]int32{
		"HARM_CATEGORY_UNSPECIFIED":       0,
		"HARM_CATEGORY_HATE_SPEECH":       1,
		"HARM_CATEGORY_DANGEROUS_CONTENT": 2,
		"HARM_CATEGORY_HARASSMENT":        3,
		"HARM_CATEGORY_SEXUALLY_EXPLICIT": 4,
		"HARM_CATEGORY_CIVIC_INTEGRITY":   5,
	}
)

func (x HarmCategory) Enum() *HarmCategory {
	p := new(HarmCategory)
	*p = x
	return p
}

func (x HarmCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HarmCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_safety_proto_enumTypes[0].Descriptor()
}

func (HarmCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_safety_proto_enumTypes[0]
}

func (x HarmCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HarmCategory.Descriptor instead.
func (HarmCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_safety_proto_rawDescGZIP(), []int{0}
}

// Probability based thresholds levels for blocking.
type SafetySetting_HarmBlockThreshold int32

const (
	// Unspecified harm block threshold.
	SafetySetting_HARM_BLOCK_THRESHOLD_UNSPECIFIED SafetySetting_HarmBlockThreshold = 0
	// Block low threshold and above (i.e. block more).
	SafetySetting_BLOCK_LOW_AND_ABOVE SafetySetting_HarmBlockThreshold = 1
	// Block medium threshold and above.
	SafetySetting_BLOCK_MEDIUM_AND_ABOVE SafetySetting_HarmBlockThreshold = 2
	// Block only high threshold (i.e. block less).
	SafetySetting_BLOCK_ONLY_HIGH SafetySetting_HarmBlockThreshold = 3
	// Block none.
	SafetySetting_BLOCK_NONE SafetySetting_HarmBlockThreshold = 4
	// Turn off the safety filter.
	SafetySetting_OFF SafetySetting_HarmBlockThreshold = 5
)

// Enum value maps for SafetySetting_HarmBlockThreshold.
var (
	SafetySetting_HarmBlockThreshold_name = map[int32]string{
		0: "HARM_BLOCK_THRESHOLD_UNSPECIFIED",
		1: "BLOCK_LOW_AND_ABOVE",
		2: "BLOCK_MEDIUM_AND_ABOVE",
		3: "BLOCK_ONLY_HIGH",
		4: "BLOCK_NONE",
		5: "OFF",
	}
	SafetySetting_HarmBlockThreshold_value = map[string]int32{
		"HARM_BLOCK_THRESHOLD_UNSPECIFIED": 0,
		"BLOCK_LOW_AND_ABOVE":              1,
		"BLOCK_MEDIUM_AND_ABOVE":           2,
		"BLOCK_ONLY_HIGH":                  3,
		"BLOCK_NONE":                       4,
		"OFF":                              5,
	}
)

func (x SafetySetting_HarmBlockThreshold) Enum() *SafetySetting_HarmBlockThreshold {
	p := new(SafetySetting_HarmBlockThreshold)
	*p = x
	return p
}

func (x SafetySetting_HarmBlockThreshold) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySetting_HarmBlockThreshold) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_safety_proto_enumTypes[1].Descriptor()
}

func (SafetySetting_HarmBlockThreshold) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_safety_proto_enumTypes[1]
}

func (x SafetySetting_HarmBlockThreshold) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySetting_HarmBlockThreshold.Descriptor instead.
func (SafetySetting_HarmBlockThreshold) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_safety_proto_rawDescGZIP(), []int{0, 0}
}

// Probability vs severity.
type SafetySetting_HarmBlockMethod int32

const (
	// The harm block method is unspecified.
	SafetySetting_HARM_BLOCK_METHOD_UNSPECIFIED SafetySetting_HarmBlockMethod = 0
	// The harm block method uses both probability and severity scores.
	SafetySetting_SEVERITY SafetySetting_HarmBlockMethod = 1
	// The harm block method uses the probability score.
	SafetySetting_PROBABILITY SafetySetting_HarmBlockMethod = 2
)

// Enum value maps for SafetySetting_HarmBlockMethod.
var (
	SafetySetting_HarmBlockMethod_name = map[int32]string{
		0: "HARM_BLOCK_METHOD_UNSPECIFIED",
		1: "SEVERITY",
		2: "PROBABILITY",
	}
	SafetySetting_HarmBlockMethod_value = map[string]int32{
		"HARM_BLOCK_METHOD_UNSPECIFIED": 0,
		"SEVERITY":                      1,
		"PROBABILITY":                   2,
	}
)

func (x SafetySetting_HarmBlockMethod) Enum() *SafetySetting_HarmBlockMethod {
	p := new(SafetySetting_HarmBlockMethod)
	*p = x
	return p
}

func (x SafetySetting_HarmBlockMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySetting_HarmBlockMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_safety_proto_enumTypes[2].Descriptor()
}

func (SafetySetting_HarmBlockMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_safety_proto_enumTypes[2]
}

func (x SafetySetting_HarmBlockMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySetting_HarmBlockMethod.Descriptor instead.
func (SafetySetting_HarmBlockMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_safety_proto_rawDescGZIP(), []int{0, 1}
}

// Safety settings.
type SafetySetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Harm category.
	Category HarmCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.retail.v2.HarmCategory" json:"category,omitempty"`
	// The harm block threshold.
	Threshold SafetySetting_HarmBlockThreshold `protobuf:"varint,2,opt,name=threshold,proto3,enum=google.cloud.retail.v2.SafetySetting_HarmBlockThreshold" json:"threshold,omitempty"`
	// Optional. Specify if the threshold is used for probability or severity
	// score. If not specified, the threshold is used for probability score.
	Method SafetySetting_HarmBlockMethod `protobuf:"varint,3,opt,name=method,proto3,enum=google.cloud.retail.v2.SafetySetting_HarmBlockMethod" json:"method,omitempty"`
}

func (x *SafetySetting) Reset() {
	*x = SafetySetting{}
	mi := &file_google_cloud_retail_v2_safety_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySetting) ProtoMessage() {}

func (x *SafetySetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_safety_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySetting.ProtoReflect.Descriptor instead.
func (*SafetySetting) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_safety_proto_rawDescGZIP(), []int{0}
}

func (x *SafetySetting) GetCategory() HarmCategory {
	if x != nil {
		return x.Category
	}
	return HarmCategory_HARM_CATEGORY_UNSPECIFIED
}

func (x *SafetySetting) GetThreshold() SafetySetting_HarmBlockThreshold {
	if x != nil {
		return x.Threshold
	}
	return SafetySetting_HARM_BLOCK_THRESHOLD_UNSPECIFIED
}

func (x *SafetySetting) GetMethod() SafetySetting_HarmBlockMethod {
	if x != nil {
		return x.Method
	}
	return SafetySetting_HARM_BLOCK_METHOD_UNSPECIFIED
}

var File_google_cloud_retail_v2_safety_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2_safety_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf2,
	0x03, 0x0a, 0x0d, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x40, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x61, 0x72, 0x6d,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x12, 0x56, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x61, 0x72,
	0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52,
	0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x52, 0x0a, 0x06, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x48, 0x61, 0x72, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x9d,
	0x01, 0x0a, 0x12, 0x48, 0x61, 0x72, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x24, 0x0a, 0x20, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x42, 0x4c,
	0x4f, 0x43, 0x4b, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x42,
	0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4d, 0x45,
	0x44, 0x49, 0x55, 0x4d, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x13, 0x0a, 0x0f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x5f, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x05, 0x22, 0x53,
	0x0a, 0x0f, 0x48, 0x61, 0x72, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x21, 0x0a, 0x1d, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x42, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x10, 0x02, 0x2a, 0xd7, 0x01, 0x0a, 0x0c, 0x48, 0x61, 0x72, 0x6d, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54, 0x45,
	0x47, 0x4f, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48,
	0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47,
	0x4f, 0x52, 0x59, 0x5f, 0x44, 0x41, 0x4e, 0x47, 0x45, 0x52, 0x4f, 0x55, 0x53, 0x5f, 0x43, 0x4f,
	0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x41, 0x52, 0x4d, 0x5f,
	0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x52, 0x41, 0x53, 0x53, 0x4d,
	0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x53, 0x45, 0x58, 0x55, 0x41, 0x4c, 0x4c, 0x59, 0x5f,
	0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x04, 0x12, 0x21, 0x0a, 0x1d, 0x48, 0x41,
	0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x43, 0x49, 0x56, 0x49,
	0x43, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x52, 0x49, 0x54, 0x59, 0x10, 0x05, 0x42, 0xb6, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x42, 0x0b, 0x53, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2,
	0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2_safety_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2_safety_proto_rawDescData = file_google_cloud_retail_v2_safety_proto_rawDesc
)

func file_google_cloud_retail_v2_safety_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2_safety_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2_safety_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2_safety_proto_rawDescData)
	})
	return file_google_cloud_retail_v2_safety_proto_rawDescData
}

var file_google_cloud_retail_v2_safety_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_retail_v2_safety_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_retail_v2_safety_proto_goTypes = []any{
	(HarmCategory)(0),                     // 0: google.cloud.retail.v2.HarmCategory
	(SafetySetting_HarmBlockThreshold)(0), // 1: google.cloud.retail.v2.SafetySetting.HarmBlockThreshold
	(SafetySetting_HarmBlockMethod)(0),    // 2: google.cloud.retail.v2.SafetySetting.HarmBlockMethod
	(*SafetySetting)(nil),                 // 3: google.cloud.retail.v2.SafetySetting
}
var file_google_cloud_retail_v2_safety_proto_depIdxs = []int32{
	0, // 0: google.cloud.retail.v2.SafetySetting.category:type_name -> google.cloud.retail.v2.HarmCategory
	1, // 1: google.cloud.retail.v2.SafetySetting.threshold:type_name -> google.cloud.retail.v2.SafetySetting.HarmBlockThreshold
	2, // 2: google.cloud.retail.v2.SafetySetting.method:type_name -> google.cloud.retail.v2.SafetySetting.HarmBlockMethod
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2_safety_proto_init() }
func file_google_cloud_retail_v2_safety_proto_init() {
	if File_google_cloud_retail_v2_safety_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2_safety_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2_safety_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2_safety_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2_safety_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2_safety_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2_safety_proto = out.File
	file_google_cloud_retail_v2_safety_proto_rawDesc = nil
	file_google_cloud_retail_v2_safety_proto_goTypes = nil
	file_google_cloud_retail_v2_safety_proto_depIdxs = nil
}
