// Code generated by go-swagger; DO NOT EDIT.

package contract_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContractServiceGetContractParams creates a new ContractServiceGetContractParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContractServiceGetContractParams() *ContractServiceGetContractParams {
	return &ContractServiceGetContractParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContractServiceGetContractParamsWithTimeout creates a new ContractServiceGetContractParams object
// with the ability to set a timeout on a request.
func NewContractServiceGetContractParamsWithTimeout(timeout time.Duration) *ContractServiceGetContractParams {
	return &ContractServiceGetContractParams{
		timeout: timeout,
	}
}

// NewContractServiceGetContractParamsWithContext creates a new ContractServiceGetContractParams object
// with the ability to set a context for a request.
func NewContractServiceGetContractParamsWithContext(ctx context.Context) *ContractServiceGetContractParams {
	return &ContractServiceGetContractParams{
		Context: ctx,
	}
}

// NewContractServiceGetContractParamsWithHTTPClient creates a new ContractServiceGetContractParams object
// with the ability to set a custom HTTPClient for a request.
func NewContractServiceGetContractParamsWithHTTPClient(client *http.Client) *ContractServiceGetContractParams {
	return &ContractServiceGetContractParams{
		HTTPClient: client,
	}
}

/*
ContractServiceGetContractParams contains all the parameters to send to the API endpoint

	for the contract service get contract operation.

	Typically these are written to a http.Request.
*/
type ContractServiceGetContractParams struct {

	/* BillingAccountID.

	   blling_account_id is the identifier of the contract's billing account.
	*/
	BillingAccountID string

	/* ContractID.

	   contract_id is the public identifier for the requested contract.
	*/
	ContractID string

	/* OrganizationID.

	   organization_id is the organization where the contract's billing account belongs.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the contract service get contract params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContractServiceGetContractParams) WithDefaults() *ContractServiceGetContractParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the contract service get contract params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContractServiceGetContractParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the contract service get contract params
func (o *ContractServiceGetContractParams) WithTimeout(timeout time.Duration) *ContractServiceGetContractParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the contract service get contract params
func (o *ContractServiceGetContractParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the contract service get contract params
func (o *ContractServiceGetContractParams) WithContext(ctx context.Context) *ContractServiceGetContractParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the contract service get contract params
func (o *ContractServiceGetContractParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the contract service get contract params
func (o *ContractServiceGetContractParams) WithHTTPClient(client *http.Client) *ContractServiceGetContractParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the contract service get contract params
func (o *ContractServiceGetContractParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBillingAccountID adds the billingAccountID to the contract service get contract params
func (o *ContractServiceGetContractParams) WithBillingAccountID(billingAccountID string) *ContractServiceGetContractParams {
	o.SetBillingAccountID(billingAccountID)
	return o
}

// SetBillingAccountID adds the billingAccountId to the contract service get contract params
func (o *ContractServiceGetContractParams) SetBillingAccountID(billingAccountID string) {
	o.BillingAccountID = billingAccountID
}

// WithContractID adds the contractID to the contract service get contract params
func (o *ContractServiceGetContractParams) WithContractID(contractID string) *ContractServiceGetContractParams {
	o.SetContractID(contractID)
	return o
}

// SetContractID adds the contractId to the contract service get contract params
func (o *ContractServiceGetContractParams) SetContractID(contractID string) {
	o.ContractID = contractID
}

// WithOrganizationID adds the organizationID to the contract service get contract params
func (o *ContractServiceGetContractParams) WithOrganizationID(organizationID string) *ContractServiceGetContractParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the contract service get contract params
func (o *ContractServiceGetContractParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *ContractServiceGetContractParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param billing_account_id
	if err := r.SetPathParam("billing_account_id", o.BillingAccountID); err != nil {
		return err
	}

	// path param contract_id
	if err := r.SetPathParam("contract_id", o.ContractID); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
