// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105ContractDetails billing 20201105 contract details
//
// swagger:model billing_20201105ContractDetails
type Billing20201105ContractDetails struct {

	// amount is the amount committed for this contract
	Amount string `json:"amount,omitempty"`

	// contract_type is the type of license (i.e. "hashicorp.hcp.flex")
	ContractType string `json:"contract_type,omitempty"`

	// end_date is the end date of the contract
	// Format: date-time
	EndDate strfmt.DateTime `json:"end_date,omitempty"`

	// start_date is the start date of the contract
	// Format: date-time
	StartDate strfmt.DateTime `json:"start_date,omitempty"`
}

// Validate validates this billing 20201105 contract details
func (m *Billing20201105ContractDetails) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEndDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ContractDetails) validateEndDate(formats strfmt.Registry) error {
	if swag.IsZero(m.EndDate) { // not required
		return nil
	}

	if err := validate.FormatOf("end_date", "body", "date-time", m.EndDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ContractDetails) validateStartDate(formats strfmt.Registry) error {
	if swag.IsZero(m.StartDate) { // not required
		return nil
	}

	if err := validate.FormatOf("start_date", "body", "date-time", m.StartDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this billing 20201105 contract details based on context it is used
func (m *Billing20201105ContractDetails) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105ContractDetails) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105ContractDetails) UnmarshalBinary(b []byte) error {
	var res Billing20201105ContractDetails
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
