// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListProvidersParams creates a new ListProvidersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListProvidersParams() *ListProvidersParams {
	return &ListProvidersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListProvidersParamsWithTimeout creates a new ListProvidersParams object
// with the ability to set a timeout on a request.
func NewListProvidersParamsWithTimeout(timeout time.Duration) *ListProvidersParams {
	return &ListProvidersParams{
		timeout: timeout,
	}
}

// NewListProvidersParamsWithContext creates a new ListProvidersParams object
// with the ability to set a context for a request.
func NewListProvidersParamsWithContext(ctx context.Context) *ListProvidersParams {
	return &ListProvidersParams{
		Context: ctx,
	}
}

// NewListProvidersParamsWithHTTPClient creates a new ListProvidersParams object
// with the ability to set a custom HTTPClient for a request.
func NewListProvidersParamsWithHTTPClient(client *http.Client) *ListProvidersParams {
	return &ListProvidersParams{
		HTTPClient: client,
	}
}

/*
ListProvidersParams contains all the parameters to send to the API endpoint

	for the list providers operation.

	Typically these are written to a http.Request.
*/
type ListProvidersParams struct {

	// Capabilities.
	Capabilities []string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list providers params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListProvidersParams) WithDefaults() *ListProvidersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list providers params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListProvidersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list providers params
func (o *ListProvidersParams) WithTimeout(timeout time.Duration) *ListProvidersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list providers params
func (o *ListProvidersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list providers params
func (o *ListProvidersParams) WithContext(ctx context.Context) *ListProvidersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list providers params
func (o *ListProvidersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list providers params
func (o *ListProvidersParams) WithHTTPClient(client *http.Client) *ListProvidersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list providers params
func (o *ListProvidersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCapabilities adds the capabilities to the list providers params
func (o *ListProvidersParams) WithCapabilities(capabilities []string) *ListProvidersParams {
	o.SetCapabilities(capabilities)
	return o
}

// SetCapabilities adds the capabilities to the list providers params
func (o *ListProvidersParams) SetCapabilities(capabilities []string) {
	o.Capabilities = capabilities
}

// WithOrganizationID adds the organizationID to the list providers params
func (o *ListProvidersParams) WithOrganizationID(organizationID string) *ListProvidersParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the list providers params
func (o *ListProvidersParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the list providers params
func (o *ListProvidersParams) WithProjectID(projectID string) *ListProvidersParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the list providers params
func (o *ListProvidersParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *ListProvidersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Capabilities != nil {

		// binding items for capabilities
		joinedCapabilities := o.bindParamCapabilities(reg)

		// query array param capabilities
		if err := r.SetQueryParam("capabilities", joinedCapabilities...); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListProviders binds the parameter capabilities
func (o *ListProvidersParams) bindParamCapabilities(formats strfmt.Registry) []string {
	capabilitiesIR := o.Capabilities

	var capabilitiesIC []string
	for _, capabilitiesIIR := range capabilitiesIR { // explode []string

		capabilitiesIIV := capabilitiesIIR // string as string
		capabilitiesIC = append(capabilitiesIC, capabilitiesIIV)
	}

	// items.CollectionFormat: "multi"
	capabilitiesIS := swag.JoinByFormat(capabilitiesIC, "multi")

	return capabilitiesIS
}
