// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateAppDynamicSecretParams creates a new UpdateAppDynamicSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateAppDynamicSecretParams() *UpdateAppDynamicSecretParams {
	return &UpdateAppDynamicSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateAppDynamicSecretParamsWithTimeout creates a new UpdateAppDynamicSecretParams object
// with the ability to set a timeout on a request.
func NewUpdateAppDynamicSecretParamsWithTimeout(timeout time.Duration) *UpdateAppDynamicSecretParams {
	return &UpdateAppDynamicSecretParams{
		timeout: timeout,
	}
}

// NewUpdateAppDynamicSecretParamsWithContext creates a new UpdateAppDynamicSecretParams object
// with the ability to set a context for a request.
func NewUpdateAppDynamicSecretParamsWithContext(ctx context.Context) *UpdateAppDynamicSecretParams {
	return &UpdateAppDynamicSecretParams{
		Context: ctx,
	}
}

// NewUpdateAppDynamicSecretParamsWithHTTPClient creates a new UpdateAppDynamicSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateAppDynamicSecretParamsWithHTTPClient(client *http.Client) *UpdateAppDynamicSecretParams {
	return &UpdateAppDynamicSecretParams{
		HTTPClient: client,
	}
}

/*
UpdateAppDynamicSecretParams contains all the parameters to send to the API endpoint

	for the update app dynamic secret operation.

	Typically these are written to a http.Request.
*/
type UpdateAppDynamicSecretParams struct {

	// AppName.
	AppName string

	// Body.
	Body *models.SecretServiceUpdateAppDynamicSecretBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update app dynamic secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAppDynamicSecretParams) WithDefaults() *UpdateAppDynamicSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update app dynamic secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAppDynamicSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithTimeout(timeout time.Duration) *UpdateAppDynamicSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithContext(ctx context.Context) *UpdateAppDynamicSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithHTTPClient(client *http.Client) *UpdateAppDynamicSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithAppName(appName string) *UpdateAppDynamicSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithBody(body *models.SecretServiceUpdateAppDynamicSecretBody) *UpdateAppDynamicSecretParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetBody(body *models.SecretServiceUpdateAppDynamicSecretBody) {
	o.Body = body
}

// WithName adds the name to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithName(name string) *UpdateAppDynamicSecretParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithOrganizationID(organizationID string) *UpdateAppDynamicSecretParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) WithProjectID(projectID string) *UpdateAppDynamicSecretParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update app dynamic secret params
func (o *UpdateAppDynamicSecretParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateAppDynamicSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
