// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceDestroyAddOn2Reader is a Reader for the WaypointServiceDestroyAddOn2 structure.
type WaypointServiceDestroyAddOn2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDestroyAddOn2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDestroyAddOn2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDestroyAddOn2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDestroyAddOn2OK creates a WaypointServiceDestroyAddOn2OK with default headers values
func NewWaypointServiceDestroyAddOn2OK() *WaypointServiceDestroyAddOn2OK {
	return &WaypointServiceDestroyAddOn2OK{}
}

/*
WaypointServiceDestroyAddOn2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDestroyAddOn2OK struct {
	Payload models.HashicorpCloudWaypointDestroyAddOnResponse
}

// IsSuccess returns true when this waypoint service destroy add on2 o k response has a 2xx status code
func (o *WaypointServiceDestroyAddOn2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service destroy add on2 o k response has a 3xx status code
func (o *WaypointServiceDestroyAddOn2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service destroy add on2 o k response has a 4xx status code
func (o *WaypointServiceDestroyAddOn2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service destroy add on2 o k response has a 5xx status code
func (o *WaypointServiceDestroyAddOn2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service destroy add on2 o k response a status code equal to that given
func (o *WaypointServiceDestroyAddOn2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service destroy add on2 o k response
func (o *WaypointServiceDestroyAddOn2OK) Code() int {
	return 200
}

func (o *WaypointServiceDestroyAddOn2OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}][%d] waypointServiceDestroyAddOn2OK %s", 200, payload)
}

func (o *WaypointServiceDestroyAddOn2OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}][%d] waypointServiceDestroyAddOn2OK %s", 200, payload)
}

func (o *WaypointServiceDestroyAddOn2OK) GetPayload() models.HashicorpCloudWaypointDestroyAddOnResponse {
	return o.Payload
}

func (o *WaypointServiceDestroyAddOn2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDestroyAddOn2Default creates a WaypointServiceDestroyAddOn2Default with default headers values
func NewWaypointServiceDestroyAddOn2Default(code int) *WaypointServiceDestroyAddOn2Default {
	return &WaypointServiceDestroyAddOn2Default{
		_statusCode: code,
	}
}

/*
WaypointServiceDestroyAddOn2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDestroyAddOn2Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service destroy add on2 default response has a 2xx status code
func (o *WaypointServiceDestroyAddOn2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service destroy add on2 default response has a 3xx status code
func (o *WaypointServiceDestroyAddOn2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service destroy add on2 default response has a 4xx status code
func (o *WaypointServiceDestroyAddOn2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service destroy add on2 default response has a 5xx status code
func (o *WaypointServiceDestroyAddOn2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service destroy add on2 default response a status code equal to that given
func (o *WaypointServiceDestroyAddOn2Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service destroy add on2 default response
func (o *WaypointServiceDestroyAddOn2Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDestroyAddOn2Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}][%d] WaypointService_DestroyAddOn2 default %s", o._statusCode, payload)
}

func (o *WaypointServiceDestroyAddOn2Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/by-name/{add_on.name}][%d] WaypointService_DestroyAddOn2 default %s", o._statusCode, payload)
}

func (o *WaypointServiceDestroyAddOn2Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDestroyAddOn2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
