// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceListAddOnDefinitionsReader is a Reader for the WaypointServiceListAddOnDefinitions structure.
type WaypointServiceListAddOnDefinitionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListAddOnDefinitionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListAddOnDefinitionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListAddOnDefinitionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListAddOnDefinitionsOK creates a WaypointServiceListAddOnDefinitionsOK with default headers values
func NewWaypointServiceListAddOnDefinitionsOK() *WaypointServiceListAddOnDefinitionsOK {
	return &WaypointServiceListAddOnDefinitionsOK{}
}

/*
WaypointServiceListAddOnDefinitionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListAddOnDefinitionsOK struct {
	Payload *models.HashicorpCloudWaypointListAddOnDefinitionsResponse
}

// IsSuccess returns true when this waypoint service list add on definitions o k response has a 2xx status code
func (o *WaypointServiceListAddOnDefinitionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list add on definitions o k response has a 3xx status code
func (o *WaypointServiceListAddOnDefinitionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list add on definitions o k response has a 4xx status code
func (o *WaypointServiceListAddOnDefinitionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list add on definitions o k response has a 5xx status code
func (o *WaypointServiceListAddOnDefinitionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list add on definitions o k response a status code equal to that given
func (o *WaypointServiceListAddOnDefinitionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list add on definitions o k response
func (o *WaypointServiceListAddOnDefinitionsOK) Code() int {
	return 200
}

func (o *WaypointServiceListAddOnDefinitionsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definitions][%d] waypointServiceListAddOnDefinitionsOK %s", 200, payload)
}

func (o *WaypointServiceListAddOnDefinitionsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definitions][%d] waypointServiceListAddOnDefinitionsOK %s", 200, payload)
}

func (o *WaypointServiceListAddOnDefinitionsOK) GetPayload() *models.HashicorpCloudWaypointListAddOnDefinitionsResponse {
	return o.Payload
}

func (o *WaypointServiceListAddOnDefinitionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListAddOnDefinitionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListAddOnDefinitionsDefault creates a WaypointServiceListAddOnDefinitionsDefault with default headers values
func NewWaypointServiceListAddOnDefinitionsDefault(code int) *WaypointServiceListAddOnDefinitionsDefault {
	return &WaypointServiceListAddOnDefinitionsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListAddOnDefinitionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListAddOnDefinitionsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list add on definitions default response has a 2xx status code
func (o *WaypointServiceListAddOnDefinitionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list add on definitions default response has a 3xx status code
func (o *WaypointServiceListAddOnDefinitionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list add on definitions default response has a 4xx status code
func (o *WaypointServiceListAddOnDefinitionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list add on definitions default response has a 5xx status code
func (o *WaypointServiceListAddOnDefinitionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list add on definitions default response a status code equal to that given
func (o *WaypointServiceListAddOnDefinitionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list add on definitions default response
func (o *WaypointServiceListAddOnDefinitionsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListAddOnDefinitionsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definitions][%d] WaypointService_ListAddOnDefinitions default %s", o._statusCode, payload)
}

func (o *WaypointServiceListAddOnDefinitionsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definitions][%d] WaypointService_ListAddOnDefinitions default %s", o._statusCode, payload)
}

func (o *WaypointServiceListAddOnDefinitionsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListAddOnDefinitionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
