// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudWaypointUIActionConfigBundle hashicorp cloud waypoint UI action config bundle
//
// swagger:model hashicorp.cloud.waypoint.UI.ActionConfigBundle
type HashicorpCloudWaypointUIActionConfigBundle struct {

	// action config
	ActionConfig *HashicorpCloudWaypointActionConfig `json:"action_config,omitempty"`

	// A list of assigned application templates to this action config
	AssignedApplicationTemplates []*HashicorpCloudWaypointUIActionConfigBundleApplicationTemplateAssignment `json:"assigned_application_templates"`

	// A list of assigned applications to this action config
	AssignedApplications []*HashicorpCloudWaypointUIActionConfigBundleApplicationAssignment `json:"assigned_applications"`

	// The latest run for this action_config, if one exists
	LatestRun *HashicorpCloudWaypointActionRun `json:"latest_run,omitempty"`

	// The total number of runs for this action_config
	TotalRuns *HashicorpCloudWaypointUIActionConfigBundleTotalRuns `json:"total_runs,omitempty"`

	// The list of variables this action has been defined to use.
	// This field is currently unimplemented and will always be empty
	// until it is turned back on in the future.
	VariablesUsed []*HashicorpCloudWaypointUIActionConfigBundleVariable `json:"variables_used"`
}

// Validate validates this hashicorp cloud waypoint UI action config bundle
func (m *HashicorpCloudWaypointUIActionConfigBundle) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActionConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAssignedApplicationTemplates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAssignedApplications(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatestRun(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTotalRuns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariablesUsed(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) validateActionConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.ActionConfig) { // not required
		return nil
	}

	if m.ActionConfig != nil {
		if err := m.ActionConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("action_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("action_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) validateAssignedApplicationTemplates(formats strfmt.Registry) error {
	if swag.IsZero(m.AssignedApplicationTemplates) { // not required
		return nil
	}

	for i := 0; i < len(m.AssignedApplicationTemplates); i++ {
		if swag.IsZero(m.AssignedApplicationTemplates[i]) { // not required
			continue
		}

		if m.AssignedApplicationTemplates[i] != nil {
			if err := m.AssignedApplicationTemplates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("assigned_application_templates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("assigned_application_templates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) validateAssignedApplications(formats strfmt.Registry) error {
	if swag.IsZero(m.AssignedApplications) { // not required
		return nil
	}

	for i := 0; i < len(m.AssignedApplications); i++ {
		if swag.IsZero(m.AssignedApplications[i]) { // not required
			continue
		}

		if m.AssignedApplications[i] != nil {
			if err := m.AssignedApplications[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("assigned_applications" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("assigned_applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) validateLatestRun(formats strfmt.Registry) error {
	if swag.IsZero(m.LatestRun) { // not required
		return nil
	}

	if m.LatestRun != nil {
		if err := m.LatestRun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latest_run")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("latest_run")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) validateTotalRuns(formats strfmt.Registry) error {
	if swag.IsZero(m.TotalRuns) { // not required
		return nil
	}

	if m.TotalRuns != nil {
		if err := m.TotalRuns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("total_runs")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("total_runs")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) validateVariablesUsed(formats strfmt.Registry) error {
	if swag.IsZero(m.VariablesUsed) { // not required
		return nil
	}

	for i := 0; i < len(m.VariablesUsed); i++ {
		if swag.IsZero(m.VariablesUsed[i]) { // not required
			continue
		}

		if m.VariablesUsed[i] != nil {
			if err := m.VariablesUsed[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables_used" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables_used" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint UI action config bundle based on the context it is used
func (m *HashicorpCloudWaypointUIActionConfigBundle) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActionConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAssignedApplicationTemplates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAssignedApplications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatestRun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariablesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) contextValidateActionConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.ActionConfig != nil {

		if swag.IsZero(m.ActionConfig) { // not required
			return nil
		}

		if err := m.ActionConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("action_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("action_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) contextValidateAssignedApplicationTemplates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AssignedApplicationTemplates); i++ {

		if m.AssignedApplicationTemplates[i] != nil {

			if swag.IsZero(m.AssignedApplicationTemplates[i]) { // not required
				return nil
			}

			if err := m.AssignedApplicationTemplates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("assigned_application_templates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("assigned_application_templates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) contextValidateAssignedApplications(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AssignedApplications); i++ {

		if m.AssignedApplications[i] != nil {

			if swag.IsZero(m.AssignedApplications[i]) { // not required
				return nil
			}

			if err := m.AssignedApplications[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("assigned_applications" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("assigned_applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) contextValidateLatestRun(ctx context.Context, formats strfmt.Registry) error {

	if m.LatestRun != nil {

		if swag.IsZero(m.LatestRun) { // not required
			return nil
		}

		if err := m.LatestRun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latest_run")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("latest_run")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) contextValidateTotalRuns(ctx context.Context, formats strfmt.Registry) error {

	if m.TotalRuns != nil {

		if swag.IsZero(m.TotalRuns) { // not required
			return nil
		}

		if err := m.TotalRuns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("total_runs")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("total_runs")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointUIActionConfigBundle) contextValidateVariablesUsed(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VariablesUsed); i++ {

		if m.VariablesUsed[i] != nil {

			if swag.IsZero(m.VariablesUsed[i]) { // not required
				return nil
			}

			if err := m.VariablesUsed[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables_used" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables_used" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointUIActionConfigBundle) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointUIActionConfigBundle) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointUIActionConfigBundle
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
