// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudWebhookUpdateWebhookRequestBody hashicorp cloud webhook update webhook request body
//
// swagger:model hashicorp.cloud.webhook.UpdateWebhookRequestBody
type HashicorpCloudWebhookUpdateWebhookRequestBody struct {

	// The optional payload used to deliver a test request to validate the webhook configuration.
	// The endpoint only sends the test payload when the `webhook.config` is updated or webhook is enabled.
	// Othewise, the webhook service delivers a generic payload.
	TestPayload *HashicorpCloudWebhookWebhookPayload `json:"test_payload,omitempty"`

	// The required mask of webhook fields to update. The endpoint converts field names to the lower-camel naming convention.
	// Fields that you can update are `description`, `config`, `subscriptions`, and `enabled`.
	//
	// Example of usage:
	// * `"description,config"` updates the description, `config.url`, and `config.hmac_key`.
	// * `"config.hmacKey"` only updates `config.hmac_key`.
	// * `"description,config,subscriptions,enabled"` update all allowed fields.
	UpdateMask string `json:"update_mask,omitempty"`

	// The webhook to update.
	Webhook *HashicorpCloudWebhookWebhook `json:"webhook,omitempty"`
}

// Validate validates this hashicorp cloud webhook update webhook request body
func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTestPayload(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebhook(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) validateTestPayload(formats strfmt.Registry) error {
	if swag.IsZero(m.TestPayload) { // not required
		return nil
	}

	if m.TestPayload != nil {
		if err := m.TestPayload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("test_payload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("test_payload")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) validateWebhook(formats strfmt.Registry) error {
	if swag.IsZero(m.Webhook) { // not required
		return nil
	}

	if m.Webhook != nil {
		if err := m.Webhook.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("webhook")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("webhook")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud webhook update webhook request body based on the context it is used
func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTestPayload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebhook(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) contextValidateTestPayload(ctx context.Context, formats strfmt.Registry) error {

	if m.TestPayload != nil {

		if swag.IsZero(m.TestPayload) { // not required
			return nil
		}

		if err := m.TestPayload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("test_payload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("test_payload")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) contextValidateWebhook(ctx context.Context, formats strfmt.Registry) error {

	if m.Webhook != nil {

		if swag.IsZero(m.Webhook) { // not required
			return nil
		}

		if err := m.Webhook.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("webhook")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("webhook")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWebhookUpdateWebhookRequestBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWebhookUpdateWebhookRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
