/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.browser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;

abstract class BrowserNode
extends CCTNode {
    private static final BrowserNode[] NO_NODES = new BrowserNode[0];
    private final BrowserNode parent;
    private final List<BrowserNode> children;
    final String name;
    final Icon icon;
    long eventsCount;

    BrowserNode(String name, Icon icon, BrowserNode parent, List<BrowserNode> children) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    BrowserNode getChild(String name) {
        if (this.children != null) {
            for (BrowserNode child : this.children) {
                if (!Objects.equals(name, child.name)) continue;
                return child;
            }
        }
        return null;
    }

    void addEvent() {
        ++this.eventsCount;
        if (this.parent != null) {
            this.parent.addEvent();
        }
    }

    public BrowserNode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public BrowserNode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public BrowserNode getParent() {
        return this.parent;
    }

    protected void addChild(BrowserNode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BrowserNode)) {
            return false;
        }
        return Objects.equals(this.name, ((BrowserNode)((Object)o)).name);
    }

    public String toString() {
        return this.name;
    }

    static class Root
    extends BrowserNode
    implements JFREventVisitor {
        Root(String name) {
            this();
            EventType e = new EventType(null, null, this);
            this.addChild(e);
        }

        Root() {
            super(null, null, null, new ArrayList<BrowserNode>());
        }

        JFREventType type(String typeName) {
            return null;
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            JFREventType type = this.type(typeName);
            if (type == null) {
                return false;
            }
            String eventName = type.getName();
            BrowserNode categoryNode = Root.getOrCreateCategory(this, type.getCategory());
            BrowserNode eventNode = categoryNode.getChild(eventName);
            if (eventNode == null) {
                eventNode = new EventType(typeName, type, categoryNode);
                categoryNode.addChild(eventNode);
            } else {
                eventNode.addEvent();
            }
            return false;
        }

        private static BrowserNode getOrCreateCategory(BrowserNode parent, List<String> category) {
            ArrayList<String> names = new ArrayList<String>(category);
            while (!names.isEmpty()) {
                String name = (String)names.remove(0);
                BrowserNode node = parent.getChild(name);
                if (node == null) {
                    node = new Category(name, parent);
                    parent.addChild(node);
                }
                parent = node;
            }
            return parent;
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Root;
        }
    }

    static final class Category
    extends BrowserNode {
        Category(String name, BrowserNode parent) {
            super(name, null, parent, new ArrayList<BrowserNode>());
        }
    }

    static final class EventType
    extends BrowserNode {
        final String typeName;
        final JFREventType type;

        EventType(String typeName, JFREventType type, BrowserNode parent) {
            super(typeName == null ? "loading..." : type.getName(), null, parent, new ArrayList<BrowserNode>());
            this.typeName = typeName;
            this.type = type;
            if (type != null) {
                ++this.eventsCount;
                parent.addEvent();
            }
        }

        @Override
        public String toString() {
            return this.type == null ? this.name : this.type.getDisplayName();
        }
    }
}

