/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components.treetable;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.ui.components.JTreeTable;
import org.graalvm.visualvm.lib.ui.components.treetable.AbstractTreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    protected AbstractTreeTableModel treeTableModel;
    protected JTree tree;
    protected JTreeTable treeTable;
    private boolean firingChange;

    public TreeTableModelAdapter(AbstractTreeTableModel treeTableModel, JTreeTable treeTable) {
        this.treeTable = treeTable;
        this.tree = treeTable.getTree();
        this.treeTableModel = treeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public List<TreePath> getExpandedPaths() {
        Enumeration<TreePath> expanded = this.tree.getExpandedDescendants(this.getRootPath());
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                paths.add(expanded.nextElement());
            }
        }
        return paths;
    }

    public TreePath getRootPath() {
        return new TreePath(this.treeTableModel.getPathToRoot((CCTNode)this.treeTableModel.getRoot()));
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object j = this.treeTableModel.getValueAt(this.nodeForRow(row), column);
        return j;
    }

    public void expandRoot() {
        this.tree.expandPath(this.getRootPath());
    }

    public void restoreExpandedPaths(List<TreePath> paths) {
        this.tree.putClientProperty("expansion_transaction", Boolean.TRUE);
        for (TreePath p : paths) {
            this.tree.expandPath(p);
        }
        this.tree.putClientProperty("expansion_transaction", Boolean.FALSE);
    }

    private TreePath getCurrentPath(TreePath oldPath) {
        if (oldPath == null || oldPath.getPathCount() < 1) {
            return null;
        }
        if (!this.treeTableModel.getRoot().equals(oldPath.getPathComponent(0))) {
            return null;
        }
        TreePath p = this.getRootPath();
        Object[] op = oldPath.getPath();
        CCTNode n = (CCTNode)this.treeTableModel.getRoot();
        for (int i = 1; i < op.length; ++i) {
            CCTNode[] children = n.getChildren();
            if (children == null) {
                return null;
            }
            CCTNode nn = null;
            for (CCTNode c : children) {
                if (!c.equals(op[i])) continue;
                nn = c;
                break;
            }
            if (nn == null) {
                return null;
            }
            n = nn;
            p = p.pathByAddingChild(n);
        }
        return p;
    }

    public void updateTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<TreePath> pathState = TreeTableModelAdapter.this.getExpandedPaths();
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.tree.getSelectionModel().clearSelection();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, TreeTableModelAdapter.this.treeTableModel.getPathToRoot((CCTNode)TreeTableModelAdapter.this.treeTableModel.getRoot()), null, null);
                if (selectedPaths != null) {
                    for (int i = 0; i < selectedPaths.length; ++i) {
                        selectedPaths[i] = TreeTableModelAdapter.this.getCurrentPath(selectedPaths[i]);
                    }
                }
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
                TreeTableModelAdapter.this.restoreExpandedPaths(pathState);
                TreeTableModelAdapter.this.treeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public void changeRoot(final CCTNode newRoot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<TreePath> pathState = TreeTableModelAdapter.this.getExpandedPaths();
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.treeTableModel.setRoot(newRoot);
                TreeTableModelAdapter.this.tree.getSelectionModel().clearSelection();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, TreeTableModelAdapter.this.treeTableModel.getPathToRoot((CCTNode)TreeTableModelAdapter.this.treeTableModel.getRoot()), null, null);
                if (selectedPaths != null) {
                    for (int i = 0; i < selectedPaths.length; ++i) {
                        selectedPaths[i] = TreeTableModelAdapter.this.getCurrentPath(selectedPaths[i]);
                    }
                }
                ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
                for (TreePath tp : pathState) {
                    expandedPaths.add(TreeTableModelAdapter.this.getCurrentPath(tp));
                }
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
                TreeTableModelAdapter.this.restoreExpandedPaths(expandedPaths);
                TreeTableModelAdapter.this.treeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public void setup(List<TreePath> expanded, TreePath selected) {
        this.tree.getSelectionModel().clearSelection();
        this.treeTableModel.fireTreeStructureChanged(this, this.treeTableModel.getPathToRoot((CCTNode)this.treeTableModel.getRoot()), null, null);
        this.treeTable.getTableHeader().repaint();
        this.fireTableDataChanged();
        if (expanded != null) {
            this.restoreExpandedPaths(expanded);
        }
        if (selected != null) {
            this.tree.setSelectionPath(selected);
            final Rectangle rect = this.tree.getPathBounds(selected);
            if (rect != null) {
                this.treeTable.scrollRectToVisible(this.tree.getPathBounds(selected));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeTableModelAdapter.this.treeTable.scrollRectToVisible(rect);
                    }
                });
            }
        }
    }

    public final boolean isFiringChange() {
        return this.firingChange;
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath[] selectedPaths = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.firingChange = true;
                try {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
                finally {
                    TreeTableModelAdapter.this.firingChange = false;
                }
                TreeTableModelAdapter.this.tree.setSelectionPaths(selectedPaths);
            }
        });
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }
}

