// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteRoleReader is a Reader for the DeleteRole structure.
type DeleteRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /access-control/roles/{roleUID}] deleteRole", response, response.Code())
	}
}

// NewDeleteRoleOK creates a DeleteRoleOK with default headers values
func NewDeleteRoleOK() *DeleteRoleOK {
	return &DeleteRoleOK{}
}

/*
DeleteRoleOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteRoleOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete role Ok response has a 2xx status code
func (o *DeleteRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete role Ok response has a 3xx status code
func (o *DeleteRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete role Ok response has a 4xx status code
func (o *DeleteRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete role Ok response has a 5xx status code
func (o *DeleteRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete role Ok response a status code equal to that given
func (o *DeleteRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete role Ok response
func (o *DeleteRoleOK) Code() int {
	return 200
}

func (o *DeleteRoleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleOk %s", 200, payload)
}

func (o *DeleteRoleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleOk %s", 200, payload)
}

func (o *DeleteRoleOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRoleBadRequest creates a DeleteRoleBadRequest with default headers values
func NewDeleteRoleBadRequest() *DeleteRoleBadRequest {
	return &DeleteRoleBadRequest{}
}

/*
DeleteRoleBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteRoleBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete role bad request response has a 2xx status code
func (o *DeleteRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete role bad request response has a 3xx status code
func (o *DeleteRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete role bad request response has a 4xx status code
func (o *DeleteRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete role bad request response has a 5xx status code
func (o *DeleteRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete role bad request response a status code equal to that given
func (o *DeleteRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete role bad request response
func (o *DeleteRoleBadRequest) Code() int {
	return 400
}

func (o *DeleteRoleBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleBadRequest %s", 400, payload)
}

func (o *DeleteRoleBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleBadRequest %s", 400, payload)
}

func (o *DeleteRoleBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRoleForbidden creates a DeleteRoleForbidden with default headers values
func NewDeleteRoleForbidden() *DeleteRoleForbidden {
	return &DeleteRoleForbidden{}
}

/*
DeleteRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete role forbidden response has a 2xx status code
func (o *DeleteRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete role forbidden response has a 3xx status code
func (o *DeleteRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete role forbidden response has a 4xx status code
func (o *DeleteRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete role forbidden response has a 5xx status code
func (o *DeleteRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete role forbidden response a status code equal to that given
func (o *DeleteRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete role forbidden response
func (o *DeleteRoleForbidden) Code() int {
	return 403
}

func (o *DeleteRoleForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleForbidden %s", 403, payload)
}

func (o *DeleteRoleForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleForbidden %s", 403, payload)
}

func (o *DeleteRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRoleInternalServerError creates a DeleteRoleInternalServerError with default headers values
func NewDeleteRoleInternalServerError() *DeleteRoleInternalServerError {
	return &DeleteRoleInternalServerError{}
}

/*
DeleteRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete role internal server error response has a 2xx status code
func (o *DeleteRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete role internal server error response has a 3xx status code
func (o *DeleteRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete role internal server error response has a 4xx status code
func (o *DeleteRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete role internal server error response has a 5xx status code
func (o *DeleteRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete role internal server error response a status code equal to that given
func (o *DeleteRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete role internal server error response
func (o *DeleteRoleInternalServerError) Code() int {
	return 500
}

func (o *DeleteRoleInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleInternalServerError %s", 500, payload)
}

func (o *DeleteRoleInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /access-control/roles/{roleUID}][%d] deleteRoleInternalServerError %s", 500, payload)
}

func (o *DeleteRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
