// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SetUserRolesReader is a Reader for the SetUserRoles structure.
type SetUserRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SetUserRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSetUserRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSetUserRolesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSetUserRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewSetUserRolesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSetUserRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /access-control/users/{userId}/roles] setUserRoles", response, response.Code())
	}
}

// NewSetUserRolesOK creates a SetUserRolesOK with default headers values
func NewSetUserRolesOK() *SetUserRolesOK {
	return &SetUserRolesOK{}
}

/*
SetUserRolesOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type SetUserRolesOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this set user roles Ok response has a 2xx status code
func (o *SetUserRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this set user roles Ok response has a 3xx status code
func (o *SetUserRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set user roles Ok response has a 4xx status code
func (o *SetUserRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this set user roles Ok response has a 5xx status code
func (o *SetUserRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this set user roles Ok response a status code equal to that given
func (o *SetUserRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the set user roles Ok response
func (o *SetUserRolesOK) Code() int {
	return 200
}

func (o *SetUserRolesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesOk %s", 200, payload)
}

func (o *SetUserRolesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesOk %s", 200, payload)
}

func (o *SetUserRolesOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *SetUserRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetUserRolesBadRequest creates a SetUserRolesBadRequest with default headers values
func NewSetUserRolesBadRequest() *SetUserRolesBadRequest {
	return &SetUserRolesBadRequest{}
}

/*
SetUserRolesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type SetUserRolesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set user roles bad request response has a 2xx status code
func (o *SetUserRolesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set user roles bad request response has a 3xx status code
func (o *SetUserRolesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set user roles bad request response has a 4xx status code
func (o *SetUserRolesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this set user roles bad request response has a 5xx status code
func (o *SetUserRolesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this set user roles bad request response a status code equal to that given
func (o *SetUserRolesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the set user roles bad request response
func (o *SetUserRolesBadRequest) Code() int {
	return 400
}

func (o *SetUserRolesBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesBadRequest %s", 400, payload)
}

func (o *SetUserRolesBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesBadRequest %s", 400, payload)
}

func (o *SetUserRolesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetUserRolesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetUserRolesForbidden creates a SetUserRolesForbidden with default headers values
func NewSetUserRolesForbidden() *SetUserRolesForbidden {
	return &SetUserRolesForbidden{}
}

/*
SetUserRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SetUserRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set user roles forbidden response has a 2xx status code
func (o *SetUserRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set user roles forbidden response has a 3xx status code
func (o *SetUserRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set user roles forbidden response has a 4xx status code
func (o *SetUserRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this set user roles forbidden response has a 5xx status code
func (o *SetUserRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this set user roles forbidden response a status code equal to that given
func (o *SetUserRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the set user roles forbidden response
func (o *SetUserRolesForbidden) Code() int {
	return 403
}

func (o *SetUserRolesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesForbidden %s", 403, payload)
}

func (o *SetUserRolesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesForbidden %s", 403, payload)
}

func (o *SetUserRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetUserRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetUserRolesNotFound creates a SetUserRolesNotFound with default headers values
func NewSetUserRolesNotFound() *SetUserRolesNotFound {
	return &SetUserRolesNotFound{}
}

/*
SetUserRolesNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type SetUserRolesNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set user roles not found response has a 2xx status code
func (o *SetUserRolesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set user roles not found response has a 3xx status code
func (o *SetUserRolesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set user roles not found response has a 4xx status code
func (o *SetUserRolesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this set user roles not found response has a 5xx status code
func (o *SetUserRolesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this set user roles not found response a status code equal to that given
func (o *SetUserRolesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the set user roles not found response
func (o *SetUserRolesNotFound) Code() int {
	return 404
}

func (o *SetUserRolesNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesNotFound %s", 404, payload)
}

func (o *SetUserRolesNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesNotFound %s", 404, payload)
}

func (o *SetUserRolesNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetUserRolesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetUserRolesInternalServerError creates a SetUserRolesInternalServerError with default headers values
func NewSetUserRolesInternalServerError() *SetUserRolesInternalServerError {
	return &SetUserRolesInternalServerError{}
}

/*
SetUserRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SetUserRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set user roles internal server error response has a 2xx status code
func (o *SetUserRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set user roles internal server error response has a 3xx status code
func (o *SetUserRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set user roles internal server error response has a 4xx status code
func (o *SetUserRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this set user roles internal server error response has a 5xx status code
func (o *SetUserRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this set user roles internal server error response a status code equal to that given
func (o *SetUserRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the set user roles internal server error response
func (o *SetUserRolesInternalServerError) Code() int {
	return 500
}

func (o *SetUserRolesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesInternalServerError %s", 500, payload)
}

func (o *SetUserRolesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/users/{userId}/roles][%d] setUserRolesInternalServerError %s", 500, payload)
}

func (o *SetUserRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetUserRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
