// Code generated by go-swagger; DO NOT EDIT.

package admin_users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// AdminGetUserAuthTokensReader is a Reader for the AdminGetUserAuthTokens structure.
type AdminGetUserAuthTokensReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AdminGetUserAuthTokensReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAdminGetUserAuthTokensOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAdminGetUserAuthTokensUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAdminGetUserAuthTokensForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAdminGetUserAuthTokensInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /admin/users/{user_id}/auth-tokens] adminGetUserAuthTokens", response, response.Code())
	}
}

// NewAdminGetUserAuthTokensOK creates a AdminGetUserAuthTokensOK with default headers values
func NewAdminGetUserAuthTokensOK() *AdminGetUserAuthTokensOK {
	return &AdminGetUserAuthTokensOK{}
}

/*
AdminGetUserAuthTokensOK describes a response with status code 200, with default header values.

(empty)
*/
type AdminGetUserAuthTokensOK struct {
	Payload []*models.UserToken
}

// IsSuccess returns true when this admin get user auth tokens Ok response has a 2xx status code
func (o *AdminGetUserAuthTokensOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this admin get user auth tokens Ok response has a 3xx status code
func (o *AdminGetUserAuthTokensOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get user auth tokens Ok response has a 4xx status code
func (o *AdminGetUserAuthTokensOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this admin get user auth tokens Ok response has a 5xx status code
func (o *AdminGetUserAuthTokensOK) IsServerError() bool {
	return false
}

// IsCode returns true when this admin get user auth tokens Ok response a status code equal to that given
func (o *AdminGetUserAuthTokensOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the admin get user auth tokens Ok response
func (o *AdminGetUserAuthTokensOK) Code() int {
	return 200
}

func (o *AdminGetUserAuthTokensOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensOk %s", 200, payload)
}

func (o *AdminGetUserAuthTokensOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensOk %s", 200, payload)
}

func (o *AdminGetUserAuthTokensOK) GetPayload() []*models.UserToken {
	return o.Payload
}

func (o *AdminGetUserAuthTokensOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAdminGetUserAuthTokensUnauthorized creates a AdminGetUserAuthTokensUnauthorized with default headers values
func NewAdminGetUserAuthTokensUnauthorized() *AdminGetUserAuthTokensUnauthorized {
	return &AdminGetUserAuthTokensUnauthorized{}
}

/*
AdminGetUserAuthTokensUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type AdminGetUserAuthTokensUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this admin get user auth tokens unauthorized response has a 2xx status code
func (o *AdminGetUserAuthTokensUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this admin get user auth tokens unauthorized response has a 3xx status code
func (o *AdminGetUserAuthTokensUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get user auth tokens unauthorized response has a 4xx status code
func (o *AdminGetUserAuthTokensUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this admin get user auth tokens unauthorized response has a 5xx status code
func (o *AdminGetUserAuthTokensUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this admin get user auth tokens unauthorized response a status code equal to that given
func (o *AdminGetUserAuthTokensUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the admin get user auth tokens unauthorized response
func (o *AdminGetUserAuthTokensUnauthorized) Code() int {
	return 401
}

func (o *AdminGetUserAuthTokensUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensUnauthorized %s", 401, payload)
}

func (o *AdminGetUserAuthTokensUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensUnauthorized %s", 401, payload)
}

func (o *AdminGetUserAuthTokensUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AdminGetUserAuthTokensUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAdminGetUserAuthTokensForbidden creates a AdminGetUserAuthTokensForbidden with default headers values
func NewAdminGetUserAuthTokensForbidden() *AdminGetUserAuthTokensForbidden {
	return &AdminGetUserAuthTokensForbidden{}
}

/*
AdminGetUserAuthTokensForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type AdminGetUserAuthTokensForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this admin get user auth tokens forbidden response has a 2xx status code
func (o *AdminGetUserAuthTokensForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this admin get user auth tokens forbidden response has a 3xx status code
func (o *AdminGetUserAuthTokensForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get user auth tokens forbidden response has a 4xx status code
func (o *AdminGetUserAuthTokensForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this admin get user auth tokens forbidden response has a 5xx status code
func (o *AdminGetUserAuthTokensForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this admin get user auth tokens forbidden response a status code equal to that given
func (o *AdminGetUserAuthTokensForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the admin get user auth tokens forbidden response
func (o *AdminGetUserAuthTokensForbidden) Code() int {
	return 403
}

func (o *AdminGetUserAuthTokensForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensForbidden %s", 403, payload)
}

func (o *AdminGetUserAuthTokensForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensForbidden %s", 403, payload)
}

func (o *AdminGetUserAuthTokensForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AdminGetUserAuthTokensForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAdminGetUserAuthTokensInternalServerError creates a AdminGetUserAuthTokensInternalServerError with default headers values
func NewAdminGetUserAuthTokensInternalServerError() *AdminGetUserAuthTokensInternalServerError {
	return &AdminGetUserAuthTokensInternalServerError{}
}

/*
AdminGetUserAuthTokensInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type AdminGetUserAuthTokensInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this admin get user auth tokens internal server error response has a 2xx status code
func (o *AdminGetUserAuthTokensInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this admin get user auth tokens internal server error response has a 3xx status code
func (o *AdminGetUserAuthTokensInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this admin get user auth tokens internal server error response has a 4xx status code
func (o *AdminGetUserAuthTokensInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this admin get user auth tokens internal server error response has a 5xx status code
func (o *AdminGetUserAuthTokensInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this admin get user auth tokens internal server error response a status code equal to that given
func (o *AdminGetUserAuthTokensInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the admin get user auth tokens internal server error response
func (o *AdminGetUserAuthTokensInternalServerError) Code() int {
	return 500
}

func (o *AdminGetUserAuthTokensInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensInternalServerError %s", 500, payload)
}

func (o *AdminGetUserAuthTokensInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /admin/users/{user_id}/auth-tokens][%d] adminGetUserAuthTokensInternalServerError %s", 500, payload)
}

func (o *AdminGetUserAuthTokensInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AdminGetUserAuthTokensInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
