// Code generated by go-swagger; DO NOT EDIT.

package group_attribute_sync

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetGroupMappingReader is a Reader for the GetGroupMapping structure.
type GetGroupMappingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetGroupMappingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetGroupMappingOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetGroupMappingBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetGroupMappingUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetGroupMappingForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetGroupMappingNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetGroupMappingInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /groupsync/mappings/{mapping_uid}] getGroupMapping", response, response.Code())
	}
}

// NewGetGroupMappingOK creates a GetGroupMappingOK with default headers values
func NewGetGroupMappingOK() *GetGroupMappingOK {
	return &GetGroupMappingOK{}
}

/*
GetGroupMappingOK describes a response with status code 200, with default header values.

(empty)
*/
type GetGroupMappingOK struct {
	Payload *models.GroupMapping
}

// IsSuccess returns true when this get group mapping Ok response has a 2xx status code
func (o *GetGroupMappingOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get group mapping Ok response has a 3xx status code
func (o *GetGroupMappingOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group mapping Ok response has a 4xx status code
func (o *GetGroupMappingOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get group mapping Ok response has a 5xx status code
func (o *GetGroupMappingOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get group mapping Ok response a status code equal to that given
func (o *GetGroupMappingOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get group mapping Ok response
func (o *GetGroupMappingOK) Code() int {
	return 200
}

func (o *GetGroupMappingOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingOk %s", 200, payload)
}

func (o *GetGroupMappingOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingOk %s", 200, payload)
}

func (o *GetGroupMappingOK) GetPayload() *models.GroupMapping {
	return o.Payload
}

func (o *GetGroupMappingOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GroupMapping)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupMappingBadRequest creates a GetGroupMappingBadRequest with default headers values
func NewGetGroupMappingBadRequest() *GetGroupMappingBadRequest {
	return &GetGroupMappingBadRequest{}
}

/*
GetGroupMappingBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetGroupMappingBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group mapping bad request response has a 2xx status code
func (o *GetGroupMappingBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group mapping bad request response has a 3xx status code
func (o *GetGroupMappingBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group mapping bad request response has a 4xx status code
func (o *GetGroupMappingBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group mapping bad request response has a 5xx status code
func (o *GetGroupMappingBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get group mapping bad request response a status code equal to that given
func (o *GetGroupMappingBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get group mapping bad request response
func (o *GetGroupMappingBadRequest) Code() int {
	return 400
}

func (o *GetGroupMappingBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingBadRequest %s", 400, payload)
}

func (o *GetGroupMappingBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingBadRequest %s", 400, payload)
}

func (o *GetGroupMappingBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupMappingBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupMappingUnauthorized creates a GetGroupMappingUnauthorized with default headers values
func NewGetGroupMappingUnauthorized() *GetGroupMappingUnauthorized {
	return &GetGroupMappingUnauthorized{}
}

/*
GetGroupMappingUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetGroupMappingUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group mapping unauthorized response has a 2xx status code
func (o *GetGroupMappingUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group mapping unauthorized response has a 3xx status code
func (o *GetGroupMappingUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group mapping unauthorized response has a 4xx status code
func (o *GetGroupMappingUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group mapping unauthorized response has a 5xx status code
func (o *GetGroupMappingUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get group mapping unauthorized response a status code equal to that given
func (o *GetGroupMappingUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get group mapping unauthorized response
func (o *GetGroupMappingUnauthorized) Code() int {
	return 401
}

func (o *GetGroupMappingUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingUnauthorized %s", 401, payload)
}

func (o *GetGroupMappingUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingUnauthorized %s", 401, payload)
}

func (o *GetGroupMappingUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupMappingUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupMappingForbidden creates a GetGroupMappingForbidden with default headers values
func NewGetGroupMappingForbidden() *GetGroupMappingForbidden {
	return &GetGroupMappingForbidden{}
}

/*
GetGroupMappingForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetGroupMappingForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group mapping forbidden response has a 2xx status code
func (o *GetGroupMappingForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group mapping forbidden response has a 3xx status code
func (o *GetGroupMappingForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group mapping forbidden response has a 4xx status code
func (o *GetGroupMappingForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group mapping forbidden response has a 5xx status code
func (o *GetGroupMappingForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get group mapping forbidden response a status code equal to that given
func (o *GetGroupMappingForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get group mapping forbidden response
func (o *GetGroupMappingForbidden) Code() int {
	return 403
}

func (o *GetGroupMappingForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingForbidden %s", 403, payload)
}

func (o *GetGroupMappingForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingForbidden %s", 403, payload)
}

func (o *GetGroupMappingForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupMappingForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupMappingNotFound creates a GetGroupMappingNotFound with default headers values
func NewGetGroupMappingNotFound() *GetGroupMappingNotFound {
	return &GetGroupMappingNotFound{}
}

/*
GetGroupMappingNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetGroupMappingNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group mapping not found response has a 2xx status code
func (o *GetGroupMappingNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group mapping not found response has a 3xx status code
func (o *GetGroupMappingNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group mapping not found response has a 4xx status code
func (o *GetGroupMappingNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group mapping not found response has a 5xx status code
func (o *GetGroupMappingNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get group mapping not found response a status code equal to that given
func (o *GetGroupMappingNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get group mapping not found response
func (o *GetGroupMappingNotFound) Code() int {
	return 404
}

func (o *GetGroupMappingNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingNotFound %s", 404, payload)
}

func (o *GetGroupMappingNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingNotFound %s", 404, payload)
}

func (o *GetGroupMappingNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupMappingNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupMappingInternalServerError creates a GetGroupMappingInternalServerError with default headers values
func NewGetGroupMappingInternalServerError() *GetGroupMappingInternalServerError {
	return &GetGroupMappingInternalServerError{}
}

/*
GetGroupMappingInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetGroupMappingInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group mapping internal server error response has a 2xx status code
func (o *GetGroupMappingInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group mapping internal server error response has a 3xx status code
func (o *GetGroupMappingInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group mapping internal server error response has a 4xx status code
func (o *GetGroupMappingInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get group mapping internal server error response has a 5xx status code
func (o *GetGroupMappingInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get group mapping internal server error response a status code equal to that given
func (o *GetGroupMappingInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get group mapping internal server error response
func (o *GetGroupMappingInternalServerError) Code() int {
	return 500
}

func (o *GetGroupMappingInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingInternalServerError %s", 500, payload)
}

func (o *GetGroupMappingInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/mappings/{mapping_uid}][%d] getGroupMappingInternalServerError %s", 500, payload)
}

func (o *GetGroupMappingInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupMappingInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
