// Code generated by go-swagger; DO NOT EDIT.

package library_elements

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetLibraryElementByUIDReader is a Reader for the GetLibraryElementByUID structure.
type GetLibraryElementByUIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLibraryElementByUIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLibraryElementByUIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetLibraryElementByUIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetLibraryElementByUIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetLibraryElementByUIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetLibraryElementByUIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /library-elements/{library_element_uid}] getLibraryElementByUID", response, response.Code())
	}
}

// NewGetLibraryElementByUIDOK creates a GetLibraryElementByUIDOK with default headers values
func NewGetLibraryElementByUIDOK() *GetLibraryElementByUIDOK {
	return &GetLibraryElementByUIDOK{}
}

/*
GetLibraryElementByUIDOK describes a response with status code 200, with default header values.

(empty)
*/
type GetLibraryElementByUIDOK struct {
	Payload *models.LibraryElementResponse
}

// IsSuccess returns true when this get library element by Uid Ok response has a 2xx status code
func (o *GetLibraryElementByUIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get library element by Uid Ok response has a 3xx status code
func (o *GetLibraryElementByUIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library element by Uid Ok response has a 4xx status code
func (o *GetLibraryElementByUIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get library element by Uid Ok response has a 5xx status code
func (o *GetLibraryElementByUIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get library element by Uid Ok response a status code equal to that given
func (o *GetLibraryElementByUIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get library element by Uid Ok response
func (o *GetLibraryElementByUIDOK) Code() int {
	return 200
}

func (o *GetLibraryElementByUIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidOk %s", 200, payload)
}

func (o *GetLibraryElementByUIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidOk %s", 200, payload)
}

func (o *GetLibraryElementByUIDOK) GetPayload() *models.LibraryElementResponse {
	return o.Payload
}

func (o *GetLibraryElementByUIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LibraryElementResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLibraryElementByUIDUnauthorized creates a GetLibraryElementByUIDUnauthorized with default headers values
func NewGetLibraryElementByUIDUnauthorized() *GetLibraryElementByUIDUnauthorized {
	return &GetLibraryElementByUIDUnauthorized{}
}

/*
GetLibraryElementByUIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetLibraryElementByUIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get library element by Uid unauthorized response has a 2xx status code
func (o *GetLibraryElementByUIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get library element by Uid unauthorized response has a 3xx status code
func (o *GetLibraryElementByUIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library element by Uid unauthorized response has a 4xx status code
func (o *GetLibraryElementByUIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get library element by Uid unauthorized response has a 5xx status code
func (o *GetLibraryElementByUIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get library element by Uid unauthorized response a status code equal to that given
func (o *GetLibraryElementByUIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get library element by Uid unauthorized response
func (o *GetLibraryElementByUIDUnauthorized) Code() int {
	return 401
}

func (o *GetLibraryElementByUIDUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidUnauthorized %s", 401, payload)
}

func (o *GetLibraryElementByUIDUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidUnauthorized %s", 401, payload)
}

func (o *GetLibraryElementByUIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLibraryElementByUIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLibraryElementByUIDForbidden creates a GetLibraryElementByUIDForbidden with default headers values
func NewGetLibraryElementByUIDForbidden() *GetLibraryElementByUIDForbidden {
	return &GetLibraryElementByUIDForbidden{}
}

/*
GetLibraryElementByUIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetLibraryElementByUIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get library element by Uid forbidden response has a 2xx status code
func (o *GetLibraryElementByUIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get library element by Uid forbidden response has a 3xx status code
func (o *GetLibraryElementByUIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library element by Uid forbidden response has a 4xx status code
func (o *GetLibraryElementByUIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get library element by Uid forbidden response has a 5xx status code
func (o *GetLibraryElementByUIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get library element by Uid forbidden response a status code equal to that given
func (o *GetLibraryElementByUIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get library element by Uid forbidden response
func (o *GetLibraryElementByUIDForbidden) Code() int {
	return 403
}

func (o *GetLibraryElementByUIDForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidForbidden %s", 403, payload)
}

func (o *GetLibraryElementByUIDForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidForbidden %s", 403, payload)
}

func (o *GetLibraryElementByUIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLibraryElementByUIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLibraryElementByUIDNotFound creates a GetLibraryElementByUIDNotFound with default headers values
func NewGetLibraryElementByUIDNotFound() *GetLibraryElementByUIDNotFound {
	return &GetLibraryElementByUIDNotFound{}
}

/*
GetLibraryElementByUIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetLibraryElementByUIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get library element by Uid not found response has a 2xx status code
func (o *GetLibraryElementByUIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get library element by Uid not found response has a 3xx status code
func (o *GetLibraryElementByUIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library element by Uid not found response has a 4xx status code
func (o *GetLibraryElementByUIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get library element by Uid not found response has a 5xx status code
func (o *GetLibraryElementByUIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get library element by Uid not found response a status code equal to that given
func (o *GetLibraryElementByUIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get library element by Uid not found response
func (o *GetLibraryElementByUIDNotFound) Code() int {
	return 404
}

func (o *GetLibraryElementByUIDNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidNotFound %s", 404, payload)
}

func (o *GetLibraryElementByUIDNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidNotFound %s", 404, payload)
}

func (o *GetLibraryElementByUIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLibraryElementByUIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLibraryElementByUIDInternalServerError creates a GetLibraryElementByUIDInternalServerError with default headers values
func NewGetLibraryElementByUIDInternalServerError() *GetLibraryElementByUIDInternalServerError {
	return &GetLibraryElementByUIDInternalServerError{}
}

/*
GetLibraryElementByUIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetLibraryElementByUIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get library element by Uid internal server error response has a 2xx status code
func (o *GetLibraryElementByUIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get library element by Uid internal server error response has a 3xx status code
func (o *GetLibraryElementByUIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library element by Uid internal server error response has a 4xx status code
func (o *GetLibraryElementByUIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get library element by Uid internal server error response has a 5xx status code
func (o *GetLibraryElementByUIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get library element by Uid internal server error response a status code equal to that given
func (o *GetLibraryElementByUIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get library element by Uid internal server error response
func (o *GetLibraryElementByUIDInternalServerError) Code() int {
	return 500
}

func (o *GetLibraryElementByUIDInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidInternalServerError %s", 500, payload)
}

func (o *GetLibraryElementByUIDInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /library-elements/{library_element_uid}][%d] getLibraryElementByUidInternalServerError %s", 500, payload)
}

func (o *GetLibraryElementByUIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLibraryElementByUIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
