// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetSnapshotParams creates a new GetSnapshotParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetSnapshotParams() *GetSnapshotParams {
	return &GetSnapshotParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetSnapshotParamsWithTimeout creates a new GetSnapshotParams object
// with the ability to set a timeout on a request.
func NewGetSnapshotParamsWithTimeout(timeout time.Duration) *GetSnapshotParams {
	return &GetSnapshotParams{
		timeout: timeout,
	}
}

// NewGetSnapshotParamsWithContext creates a new GetSnapshotParams object
// with the ability to set a context for a request.
func NewGetSnapshotParamsWithContext(ctx context.Context) *GetSnapshotParams {
	return &GetSnapshotParams{
		Context: ctx,
	}
}

// NewGetSnapshotParamsWithHTTPClient creates a new GetSnapshotParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetSnapshotParamsWithHTTPClient(client *http.Client) *GetSnapshotParams {
	return &GetSnapshotParams{
		HTTPClient: client,
	}
}

/*
GetSnapshotParams contains all the parameters to send to the API endpoint

	for the get snapshot operation.

	Typically these are written to a http.Request.
*/
type GetSnapshotParams struct {

	/* ResultLimit.

	   Max limit for snapshot results returned.

	   Format: int64
	   Default: 100
	*/
	ResultLimit *int64

	/* ResultPage.

	   ResultPage is used for pagination with ResultLimit

	   Format: int64
	   Default: 1
	*/
	ResultPage *int64

	/* SnapshotUID.

	   UID of a snapshot
	*/
	SnapshotUID string

	/* UID.

	   Session UID of a session
	*/
	UID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get snapshot params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSnapshotParams) WithDefaults() *GetSnapshotParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get snapshot params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSnapshotParams) SetDefaults() {
	var (
		resultLimitDefault = int64(100)

		resultPageDefault = int64(1)
	)

	val := GetSnapshotParams{
		ResultLimit: &resultLimitDefault,
		ResultPage:  &resultPageDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get snapshot params
func (o *GetSnapshotParams) WithTimeout(timeout time.Duration) *GetSnapshotParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get snapshot params
func (o *GetSnapshotParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get snapshot params
func (o *GetSnapshotParams) WithContext(ctx context.Context) *GetSnapshotParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get snapshot params
func (o *GetSnapshotParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get snapshot params
func (o *GetSnapshotParams) WithHTTPClient(client *http.Client) *GetSnapshotParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get snapshot params
func (o *GetSnapshotParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithResultLimit adds the resultLimit to the get snapshot params
func (o *GetSnapshotParams) WithResultLimit(resultLimit *int64) *GetSnapshotParams {
	o.SetResultLimit(resultLimit)
	return o
}

// SetResultLimit adds the resultLimit to the get snapshot params
func (o *GetSnapshotParams) SetResultLimit(resultLimit *int64) {
	o.ResultLimit = resultLimit
}

// WithResultPage adds the resultPage to the get snapshot params
func (o *GetSnapshotParams) WithResultPage(resultPage *int64) *GetSnapshotParams {
	o.SetResultPage(resultPage)
	return o
}

// SetResultPage adds the resultPage to the get snapshot params
func (o *GetSnapshotParams) SetResultPage(resultPage *int64) {
	o.ResultPage = resultPage
}

// WithSnapshotUID adds the snapshotUID to the get snapshot params
func (o *GetSnapshotParams) WithSnapshotUID(snapshotUID string) *GetSnapshotParams {
	o.SetSnapshotUID(snapshotUID)
	return o
}

// SetSnapshotUID adds the snapshotUid to the get snapshot params
func (o *GetSnapshotParams) SetSnapshotUID(snapshotUID string) {
	o.SnapshotUID = snapshotUID
}

// WithUID adds the uid to the get snapshot params
func (o *GetSnapshotParams) WithUID(uid string) *GetSnapshotParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the get snapshot params
func (o *GetSnapshotParams) SetUID(uid string) {
	o.UID = uid
}

// WriteToRequest writes these params to a swagger request
func (o *GetSnapshotParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ResultLimit != nil {

		// query param resultLimit
		var qrResultLimit int64

		if o.ResultLimit != nil {
			qrResultLimit = *o.ResultLimit
		}
		qResultLimit := swag.FormatInt64(qrResultLimit)
		if qResultLimit != "" {

			if err := r.SetQueryParam("resultLimit", qResultLimit); err != nil {
				return err
			}
		}
	}

	if o.ResultPage != nil {

		// query param resultPage
		var qrResultPage int64

		if o.ResultPage != nil {
			qrResultPage = *o.ResultPage
		}
		qResultPage := swag.FormatInt64(qrResultPage)
		if qResultPage != "" {

			if err := r.SetQueryParam("resultPage", qResultPage); err != nil {
				return err
			}
		}
	}

	// path param snapshotUid
	if err := r.SetPathParam("snapshotUid", o.SnapshotUID); err != nil {
		return err
	}

	// path param uid
	if err := r.SetPathParam("uid", o.UID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
