// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UploadSnapshotReader is a Reader for the UploadSnapshot structure.
type UploadSnapshotReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UploadSnapshotReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUploadSnapshotOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUploadSnapshotBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUploadSnapshotUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUploadSnapshotForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUploadSnapshotInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload] uploadSnapshot", response, response.Code())
	}
}

// NewUploadSnapshotOK creates a UploadSnapshotOK with default headers values
func NewUploadSnapshotOK() *UploadSnapshotOK {
	return &UploadSnapshotOK{}
}

/*
UploadSnapshotOK describes a response with status code 200, with default header values.

(empty)
*/
type UploadSnapshotOK struct {
}

// IsSuccess returns true when this upload snapshot Ok response has a 2xx status code
func (o *UploadSnapshotOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this upload snapshot Ok response has a 3xx status code
func (o *UploadSnapshotOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload snapshot Ok response has a 4xx status code
func (o *UploadSnapshotOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this upload snapshot Ok response has a 5xx status code
func (o *UploadSnapshotOK) IsServerError() bool {
	return false
}

// IsCode returns true when this upload snapshot Ok response a status code equal to that given
func (o *UploadSnapshotOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the upload snapshot Ok response
func (o *UploadSnapshotOK) Code() int {
	return 200
}

func (o *UploadSnapshotOK) Error() string {
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotOk", 200)
}

func (o *UploadSnapshotOK) String() string {
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotOk", 200)
}

func (o *UploadSnapshotOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewUploadSnapshotBadRequest creates a UploadSnapshotBadRequest with default headers values
func NewUploadSnapshotBadRequest() *UploadSnapshotBadRequest {
	return &UploadSnapshotBadRequest{}
}

/*
UploadSnapshotBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UploadSnapshotBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this upload snapshot bad request response has a 2xx status code
func (o *UploadSnapshotBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload snapshot bad request response has a 3xx status code
func (o *UploadSnapshotBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload snapshot bad request response has a 4xx status code
func (o *UploadSnapshotBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this upload snapshot bad request response has a 5xx status code
func (o *UploadSnapshotBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this upload snapshot bad request response a status code equal to that given
func (o *UploadSnapshotBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the upload snapshot bad request response
func (o *UploadSnapshotBadRequest) Code() int {
	return 400
}

func (o *UploadSnapshotBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotBadRequest %s", 400, payload)
}

func (o *UploadSnapshotBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotBadRequest %s", 400, payload)
}

func (o *UploadSnapshotBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UploadSnapshotBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSnapshotUnauthorized creates a UploadSnapshotUnauthorized with default headers values
func NewUploadSnapshotUnauthorized() *UploadSnapshotUnauthorized {
	return &UploadSnapshotUnauthorized{}
}

/*
UploadSnapshotUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UploadSnapshotUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this upload snapshot unauthorized response has a 2xx status code
func (o *UploadSnapshotUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload snapshot unauthorized response has a 3xx status code
func (o *UploadSnapshotUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload snapshot unauthorized response has a 4xx status code
func (o *UploadSnapshotUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this upload snapshot unauthorized response has a 5xx status code
func (o *UploadSnapshotUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this upload snapshot unauthorized response a status code equal to that given
func (o *UploadSnapshotUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the upload snapshot unauthorized response
func (o *UploadSnapshotUnauthorized) Code() int {
	return 401
}

func (o *UploadSnapshotUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotUnauthorized %s", 401, payload)
}

func (o *UploadSnapshotUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotUnauthorized %s", 401, payload)
}

func (o *UploadSnapshotUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UploadSnapshotUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSnapshotForbidden creates a UploadSnapshotForbidden with default headers values
func NewUploadSnapshotForbidden() *UploadSnapshotForbidden {
	return &UploadSnapshotForbidden{}
}

/*
UploadSnapshotForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UploadSnapshotForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this upload snapshot forbidden response has a 2xx status code
func (o *UploadSnapshotForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload snapshot forbidden response has a 3xx status code
func (o *UploadSnapshotForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload snapshot forbidden response has a 4xx status code
func (o *UploadSnapshotForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this upload snapshot forbidden response has a 5xx status code
func (o *UploadSnapshotForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this upload snapshot forbidden response a status code equal to that given
func (o *UploadSnapshotForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the upload snapshot forbidden response
func (o *UploadSnapshotForbidden) Code() int {
	return 403
}

func (o *UploadSnapshotForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotForbidden %s", 403, payload)
}

func (o *UploadSnapshotForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotForbidden %s", 403, payload)
}

func (o *UploadSnapshotForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UploadSnapshotForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSnapshotInternalServerError creates a UploadSnapshotInternalServerError with default headers values
func NewUploadSnapshotInternalServerError() *UploadSnapshotInternalServerError {
	return &UploadSnapshotInternalServerError{}
}

/*
UploadSnapshotInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UploadSnapshotInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this upload snapshot internal server error response has a 2xx status code
func (o *UploadSnapshotInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload snapshot internal server error response has a 3xx status code
func (o *UploadSnapshotInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload snapshot internal server error response has a 4xx status code
func (o *UploadSnapshotInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this upload snapshot internal server error response has a 5xx status code
func (o *UploadSnapshotInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this upload snapshot internal server error response a status code equal to that given
func (o *UploadSnapshotInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the upload snapshot internal server error response
func (o *UploadSnapshotInternalServerError) Code() int {
	return 500
}

func (o *UploadSnapshotInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotInternalServerError %s", 500, payload)
}

func (o *UploadSnapshotInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot/{snapshotUid}/upload][%d] uploadSnapshotInternalServerError %s", 500, payload)
}

func (o *UploadSnapshotInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UploadSnapshotInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
