// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetOrgQuotaParams creates a new GetOrgQuotaParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetOrgQuotaParams() *GetOrgQuotaParams {
	return &GetOrgQuotaParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetOrgQuotaParamsWithTimeout creates a new GetOrgQuotaParams object
// with the ability to set a timeout on a request.
func NewGetOrgQuotaParamsWithTimeout(timeout time.Duration) *GetOrgQuotaParams {
	return &GetOrgQuotaParams{
		timeout: timeout,
	}
}

// NewGetOrgQuotaParamsWithContext creates a new GetOrgQuotaParams object
// with the ability to set a context for a request.
func NewGetOrgQuotaParamsWithContext(ctx context.Context) *GetOrgQuotaParams {
	return &GetOrgQuotaParams{
		Context: ctx,
	}
}

// NewGetOrgQuotaParamsWithHTTPClient creates a new GetOrgQuotaParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetOrgQuotaParamsWithHTTPClient(client *http.Client) *GetOrgQuotaParams {
	return &GetOrgQuotaParams{
		HTTPClient: client,
	}
}

/*
GetOrgQuotaParams contains all the parameters to send to the API endpoint

	for the get org quota operation.

	Typically these are written to a http.Request.
*/
type GetOrgQuotaParams struct {

	// OrgID.
	//
	// Format: int64
	OrgID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get org quota params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOrgQuotaParams) WithDefaults() *GetOrgQuotaParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get org quota params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOrgQuotaParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get org quota params
func (o *GetOrgQuotaParams) WithTimeout(timeout time.Duration) *GetOrgQuotaParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get org quota params
func (o *GetOrgQuotaParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get org quota params
func (o *GetOrgQuotaParams) WithContext(ctx context.Context) *GetOrgQuotaParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get org quota params
func (o *GetOrgQuotaParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get org quota params
func (o *GetOrgQuotaParams) WithHTTPClient(client *http.Client) *GetOrgQuotaParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get org quota params
func (o *GetOrgQuotaParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrgID adds the orgID to the get org quota params
func (o *GetOrgQuotaParams) WithOrgID(orgID int64) *GetOrgQuotaParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the get org quota params
func (o *GetOrgQuotaParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WriteToRequest writes these params to a swagger request
func (o *GetOrgQuotaParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
